/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.LightweightPeer;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.help.BadIDException;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.Map;
import javax.help.SwingHelpUtilities;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CSH {
    private static Hashtable comps;
    private static final boolean debug = false;

    public static void setHelpIDString(Component component, String string) {
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty("HelpID", string);
        } else {
            Hashtable<String, String> hashtable;
            if (comps == null) {
                comps = new Hashtable(5);
            }
            if ((hashtable = (Hashtable<String, String>)comps.get(component)) != null) {
                if (string != null) {
                    hashtable.put("HelpID", string);
                } else {
                    hashtable.remove("HelpID");
                    if (hashtable.isEmpty()) {
                        comps.remove(component);
                    }
                }
            } else if (string != null) {
                hashtable = new Hashtable<String, String>(2);
                hashtable.put("HelpID", string);
                comps.put(component, hashtable);
            }
        }
    }

    public static String getHelpIDString(Component component) {
        Serializable serializable;
        String string = null;
        if (component instanceof JComponent) {
            string = (String)((JComponent)component).getClientProperty("HelpID");
        } else if (comps != null && (serializable = (Hashtable)comps.get(component)) != null) {
            string = (String)((Hashtable)serializable).get("HelpID");
        }
        if (string != null) {
            return string;
        }
        serializable = component.getParent();
        if (serializable != null) {
            return CSH.getHelpIDString((Component)serializable);
        }
        return null;
    }

    public static void setHelpSet(Component component, HelpSet helpSet) {
        if (component == null) {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty("HelpSet", helpSet);
        } else {
            Hashtable<String, HelpSet> hashtable;
            if (comps == null) {
                comps = new Hashtable(5);
            }
            if ((hashtable = (Hashtable<String, HelpSet>)comps.get(component)) != null) {
                if (helpSet != null) {
                    hashtable.put("HelpSet", helpSet);
                } else {
                    hashtable.remove("HelpSet");
                    if (hashtable.isEmpty()) {
                        comps.remove(component);
                    }
                }
            } else if (helpSet != null) {
                hashtable = new Hashtable<String, HelpSet>(2);
                hashtable.put("HelpSet", helpSet);
                comps.put(component, hashtable);
            }
        }
    }

    public static HelpSet getHelpSet(Component component) {
        Serializable serializable;
        String string = null;
        HelpSet helpSet = null;
        if (component instanceof JComponent) {
            string = (String)((JComponent)component).getClientProperty("HelpID");
            if (string != null) {
                helpSet = (HelpSet)((JComponent)component).getClientProperty("HelpSet");
            }
        } else if (comps != null && (serializable = (Hashtable)comps.get(component)) != null && (string = (String)((Hashtable)serializable).get("HelpID")) != null) {
            helpSet = (HelpSet)((Hashtable)serializable).get("HelpSet");
        }
        if (string != null) {
            return helpSet;
        }
        serializable = component.getParent();
        if (serializable != null) {
            return CSH.getHelpSet((Component)serializable);
        }
        return null;
    }

    public static void setHelpIDString(MenuItem menuItem, String string) {
        Hashtable<String, String> hashtable;
        if (comps == null) {
            comps = new Hashtable(5);
        }
        if ((hashtable = (Hashtable<String, String>)comps.get(menuItem)) != null) {
            if (string != null) {
                hashtable.put("HelpID", string);
            } else {
                hashtable.remove("HelpID");
                if (hashtable.isEmpty()) {
                    comps.remove(menuItem);
                }
            }
        } else if (string != null) {
            hashtable = new Hashtable<String, String>(2);
            hashtable.put("HelpID", string);
            comps.put(menuItem, hashtable);
        }
    }

    public static String getHelpIDString(MenuItem menuItem) {
        Object object;
        String string = null;
        if (comps != null && (object = (Hashtable)comps.get(menuItem)) != null) {
            string = (String)((Hashtable)object).get("HelpID");
        }
        if (string != null) {
            return string;
        }
        object = menuItem.getParent();
        if (object != null && object instanceof MenuItem) {
            return CSH.getHelpIDString((MenuItem)object);
        }
        return null;
    }

    public static void setHelpSet(MenuItem menuItem, HelpSet helpSet) {
        Hashtable<String, HelpSet> hashtable;
        if (comps == null) {
            comps = new Hashtable(5);
        }
        if ((hashtable = (Hashtable<String, HelpSet>)comps.get(menuItem)) != null) {
            if (helpSet != null) {
                hashtable.put("HelpSet", helpSet);
            } else {
                hashtable.remove("HelpSet");
                if (hashtable.isEmpty()) {
                    comps.remove(menuItem);
                }
            }
        } else if (helpSet != null) {
            hashtable = new Hashtable<String, HelpSet>(2);
            hashtable.put("HelpSet", helpSet);
            comps.put(menuItem, hashtable);
        }
    }

    public static HelpSet getHelpSet(MenuItem menuItem) {
        Object object;
        String string = null;
        HelpSet helpSet = null;
        if (comps != null && (object = (Hashtable)comps.get(menuItem)) != null && (string = (String)((Hashtable)object).get("HelpID")) != null) {
            helpSet = (HelpSet)((Hashtable)object).get("HelpSet");
        }
        if (string != null) {
            return helpSet;
        }
        object = menuItem.getParent();
        if (object != null && object instanceof MenuItem) {
            return CSH.getHelpSet((MenuItem)object);
        }
        return null;
    }

    public static Object trackCSEvents() {
        block30: {
            int n = -1;
            try {
                if (!Thread.currentThread().getClass().getName().endsWith("EventDispatchThread")) break block30;
                EventQueue eventQueue = null;
                try {
                    eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                }
                catch (Exception exception) {
                    CSH.debug(exception);
                }
                if (eventQueue == null) {
                    return null;
                }
                while (true) {
                    Serializable serializable;
                    ++n;
                    AWTEvent aWTEvent = eventQueue.getNextEvent();
                    Object object = aWTEvent.getSource();
                    try {
                        serializable = Class.forName("java.awt.ActiveEvent");
                        if (serializable != null && ((Class)serializable).isInstance(aWTEvent)) {
                            Method method = null;
                            Class[] classArray = new Class[]{};
                            Object[] objectArray = new Object[]{};
                            method = ((Class)serializable).getMethod("dispatch", classArray);
                            if (method != null) {
                                method.invoke((Object)aWTEvent, objectArray);
                                continue;
                            }
                        }
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (object instanceof Component) {
                        if (aWTEvent instanceof InputEvent) {
                            if (aWTEvent instanceof KeyEvent) {
                                serializable = (KeyEvent)aWTEvent;
                                if (((KeyEvent)serializable).getKeyCode() == 3) {
                                    ((InputEvent)serializable).consume();
                                    return null;
                                }
                                CSH.dispatchEvent(object, aWTEvent);
                                continue;
                            }
                            if (aWTEvent instanceof MouseEvent) {
                                serializable = (MouseEvent)aWTEvent;
                                int n2 = ((AWTEvent)serializable).getID();
                                if (n2 == 500 || n2 == 501 || n2 == 502) {
                                    if (n2 == 500) {
                                        if (n == 0) {
                                            CSH.dispatchEvent(object, aWTEvent);
                                            continue;
                                        }
                                        ((InputEvent)serializable).consume();
                                        return CSH.getDeepestObjectAt(object, ((MouseEvent)serializable).getX(), ((MouseEvent)serializable).getY());
                                    }
                                    ((InputEvent)serializable).consume();
                                    continue;
                                }
                                ((InputEvent)serializable).consume();
                                continue;
                            }
                            CSH.dispatchEvent(object, aWTEvent);
                            continue;
                        }
                        CSH.dispatchEvent(object, aWTEvent);
                        continue;
                    }
                    if (object instanceof MenuComponent) {
                        if (object instanceof MenuItem) {
                            if (!(aWTEvent instanceof InputEvent)) continue;
                            if (aWTEvent instanceof KeyEvent) {
                                serializable = (KeyEvent)aWTEvent;
                                if (((KeyEvent)serializable).getKeyCode() == 3) {
                                    ((InputEvent)serializable).consume();
                                    return null;
                                }
                                CSH.dispatchEvent(object, aWTEvent);
                                continue;
                            }
                            if (aWTEvent instanceof MouseEvent) {
                                serializable = (MouseEvent)aWTEvent;
                                int n3 = ((AWTEvent)serializable).getID();
                                if (n3 == 500 || n3 == 501 || n3 == 502) {
                                    if (n3 == 500) {
                                        if (n == 0) {
                                            CSH.dispatchEvent(object, aWTEvent);
                                            continue;
                                        }
                                        ((InputEvent)serializable).consume();
                                        return CSH.getDeepestObjectAt(object, ((MouseEvent)serializable).getX(), ((MouseEvent)serializable).getY());
                                    }
                                    ((InputEvent)serializable).consume();
                                    continue;
                                }
                                ((InputEvent)serializable).consume();
                                continue;
                            }
                            CSH.dispatchEvent(object, aWTEvent);
                            continue;
                        }
                        CSH.dispatchEvent(object, aWTEvent);
                        continue;
                    }
                    System.err.println("unable to dispatch event: " + aWTEvent);
                }
            }
            catch (InterruptedException interruptedException) {
                CSH.debug("InterrupedExeception");
            }
        }
        CSH.debug("Fall Through code");
        return null;
    }

    private static void dispatchEvent(Object object, AWTEvent aWTEvent) {
        if (object instanceof Component) {
            ((Component)object).dispatchEvent(aWTEvent);
        } else if (object instanceof MenuComponent) {
            ((MenuComponent)object).dispatchEvent(aWTEvent);
        }
    }

    private static Object getDeepestObjectAt(Object object, int n, int n2) {
        Component component;
        if (object != null && object instanceof Container && (component = CSH.findComponentAt((Container)object, n, n2)) != null && component != object) {
            if (component instanceof JRootPane) {
                JLayeredPane jLayeredPane = ((JRootPane)component).getLayeredPane();
                Rectangle rectangle = jLayeredPane.getBounds();
                component = (Component)CSH.getDeepestObjectAt(jLayeredPane, n - rectangle.x, n2 - rectangle.y);
                if (component != null) {
                    return component;
                }
            } else {
                return component;
            }
        }
        return object;
    }

    private static Component findComponentAt(Container container, int n, int n2) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Component component = CSH.findComponentAt(container, n, n2, true, false);
            return component;
        }
    }

    private static Component findComponentAt(Container container, int n, int n2, boolean bl, boolean bl2) {
        Serializable serializable;
        if (!container.contains(n, n2) || !container.isVisible() || !bl && !container.isEnabled()) {
            return null;
        }
        int n3 = container.getComponentCount();
        Component[] componentArray = container.getComponents();
        Component component = null;
        if (bl2 && container instanceof JRootPane) {
            component = ((JRootPane)container).getGlassPane();
        }
        int n4 = 0;
        while (n4 < n3) {
            Component component2 = componentArray[n4];
            if (component2 != null && component2 != component && !(component2.getPeer() instanceof LightweightPeer)) {
                serializable = component2.getLocation();
                if ((component2 = component2 instanceof Container ? CSH.findComponentAt((Container)component2, n - ((Point)serializable).x, n2 - ((Point)serializable).y, bl, bl2) : component2.locate(n - ((Point)serializable).x, n2 - ((Point)serializable).y)) != null && component2.isVisible() && (bl || component2.isEnabled())) {
                    return component2;
                }
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < n3) {
            serializable = componentArray[n5];
            if (serializable != null && serializable != component && serializable.getPeer() instanceof LightweightPeer) {
                Point point = ((Component)serializable).getLocation();
                if ((serializable = serializable instanceof Container ? CSH.findComponentAt((Container)serializable, n - point.x, n2 - point.y, bl, bl2) : ((Component)serializable).locate(n - point.x, n2 - point.y)) != null && ((Component)serializable).isVisible() && (bl || ((Component)serializable).isEnabled())) {
                    return serializable;
                }
            }
            ++n5;
        }
        return container;
    }

    private static JMenuItem findArmedMenuItem(JMenu jMenu) {
        if (jMenu == null) {
            return null;
        }
        Object object = jMenu.getTreeLock();
        synchronized (object) {
            Component component;
            if (!jMenu.isArmed()) {
                JMenuItem jMenuItem = null;
                return jMenuItem;
            }
            int n = 0;
            int n2 = jMenu.getMenuComponentCount();
            while (n < n2) {
                component = jMenu.getMenuComponent(n);
                if (component instanceof JMenuItem && ((JMenuItem)component).isArmed()) {
                    if (component instanceof JMenu) {
                        component = CSH.findArmedMenuItem(component);
                    }
                    JMenuItem jMenuItem = component;
                    return jMenuItem;
                }
                ++n;
            }
            component = jMenu;
            return component;
        }
    }

    private static Component findArmedComponent(JPopupMenu jPopupMenu) {
        if (jPopupMenu == null) {
            return null;
        }
        Object object = jPopupMenu.getTreeLock();
        synchronized (object) {
            Component component;
            if (!jPopupMenu.isVisible()) {
                Component component2 = null;
                return component2;
            }
            int n = 0;
            int n2 = jPopupMenu.getComponentCount();
            while (n < n2) {
                component = jPopupMenu.getComponent(n);
                if (component instanceof JMenuItem && ((JMenuItem)component).isArmed()) {
                    if (component instanceof JMenu) {
                        component = CSH.findArmedMenuItem((JMenu)component);
                    }
                    Component component3 = component;
                    return component3;
                }
                ++n;
            }
            component = jPopupMenu.getInvoker();
            return component;
        }
    }

    private static Component findFocusOwner(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (component instanceof JPopupMenu) {
                Component component2 = CSH.findArmedComponent((JPopupMenu)component);
                return component2;
            }
            if (component instanceof JComponent && ((JComponent)component).hasFocus()) {
                if (component instanceof JMenu) {
                    component = CSH.findArmedMenuItem((JMenu)component);
                }
                Component component3 = component;
                return component3;
            }
            if (component instanceof Container) {
                int n = 0;
                int n2 = ((Container)component).getComponentCount();
                while (n < n2) {
                    Component component4 = CSH.findFocusOwner(((Container)component).getComponent(n));
                    if (component4 != null) {
                        Component component5 = component4;
                        return component5;
                    }
                    ++n;
                }
            }
            Component component6 = null;
            return component6;
        }
    }

    private static void debug(Object object) {
    }

    public static class DisplayHelpFromSource
    implements ActionListener {
        private HelpBroker hb;

        public DisplayHelpFromSource(HelpBroker helpBroker) {
            if (helpBroker == null) {
                throw new NullPointerException("hb");
            }
            this.hb = helpBroker;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            Object object3;
            Object object4 = actionEvent.getSource();
            if (object4 instanceof Component) {
                object3 = (Component)actionEvent.getSource();
                if (object3 instanceof JMenuItem) {
                    while (object3 instanceof JMenuItem) {
                        object2 = ((Component)object3).getParent();
                        if (!(object2 instanceof JPopupMenu)) break;
                        object3 = ((JPopupMenu)object2).getInvoker();
                    }
                }
                try {
                    object2 = (Window)SwingUtilities.getAncestorOfClass(Class.forName("java.awt.Window"), (Component)object3);
                    CSH.debug("owner = " + object2);
                    if (this.hb instanceof DefaultHelpBroker) {
                        ((DefaultHelpBroker)this.hb).setActivationWindow((Window)object2);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else if (object4 instanceof MenuItem) {
                block26: {
                    object3 = (MenuItem)actionEvent.getSource();
                    object2 = null;
                    while (true) {
                        if ((object = ((MenuComponent)object3).getParent()) instanceof Menu) {
                            object3 = (MenuItem)object;
                            continue;
                        }
                        if (object instanceof MenuBar) {
                            try {
                                object2 = (Window)SwingUtilities.getAncestorOfClass(Class.forName("java.awt.Window"), (Component)((MenuBar)object).getParent());
                            }
                            catch (ClassNotFoundException classNotFoundException) {}
                            break block26;
                        }
                        if (object instanceof Frame) {
                            object2 = (Window)object;
                            break block26;
                        }
                        if (object instanceof Component) break;
                    }
                    try {
                        object2 = (Window)SwingUtilities.getAncestorOfClass(Class.forName("java.awt.Window"), (Component)object);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                CSH.debug("owner = " + object2);
                if (this.hb instanceof DefaultHelpBroker) {
                    ((DefaultHelpBroker)this.hb).setActivationWindow((Window)object2);
                }
            }
            object3 = null;
            object2 = null;
            if (object4 instanceof Component) {
                object = (Component)object4;
                object3 = CSH.getHelpIDString((Component)object);
                object2 = CSH.getHelpSet((Component)object);
            } else if (object4 instanceof MenuItem) {
                object = (MenuItem)object4;
                object3 = CSH.getHelpIDString((MenuItem)object);
                object2 = CSH.getHelpSet((MenuItem)object);
            } else {
                return;
            }
            if (object2 == null) {
                object2 = this.hb.getHelpSet();
            }
            try {
                object = Map.ID.create((String)object3, (HelpSet)object2);
                if (object == null) {
                    object = ((HelpSet)object2).getHomeID();
                }
                this.hb.setCurrentID((Map.ID)object);
                this.hb.setDisplayed(true);
            }
            catch (Exception exception) {
                System.err.println("trouble in HelpActionListener");
            }
        }
    }

    public static class DisplayHelpAfterTracking
    implements ActionListener {
        private HelpBroker hb;
        private Hashtable cursors;
        private Stack cursorStack;

        public DisplayHelpAfterTracking(HelpBroker helpBroker) {
            if (helpBroker == null) {
                throw new NullPointerException("hb");
            }
            this.hb = helpBroker;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            Enumeration enumeration;
            SwingHelpUtilities.installUIDefaults();
            Cursor cursor = (Cursor)UIManager.get("HelpOnItemCursor");
            if (cursor == null) {
                return;
            }
            Vector vector = null;
            this.cursors = null;
            if (cursor != null) {
                this.cursors = new Hashtable();
                vector = this.getTopContainers(actionEvent.getSource());
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    this.setCursor((Container)enumeration.nextElement(), cursor);
                }
            }
            enumeration = CSH.trackCSEvents();
            Component component = (Component)actionEvent.getSource();
            try {
                object2 = (Window)SwingUtilities.getAncestorOfClass(Class.forName("java.awt.Window"), component);
                if (this.hb instanceof DefaultHelpBroker) {
                    ((DefaultHelpBroker)this.hb).setActivationWindow((Window)object2);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            object2 = null;
            HelpSet helpSet = null;
            if (enumeration != null && enumeration instanceof Component) {
                object2 = CSH.getHelpIDString((Component)((Object)enumeration));
                helpSet = CSH.getHelpSet((Component)((Object)enumeration));
            } else if (enumeration != null && enumeration instanceof MenuItem) {
                object2 = CSH.getHelpIDString((MenuItem)((Object)enumeration));
                helpSet = CSH.getHelpSet((MenuItem)((Object)enumeration));
            }
            if (helpSet == null) {
                helpSet = this.hb.getHelpSet();
            }
            try {
                object = Map.ID.create((String)object2, helpSet);
                if (object == null) {
                    object = helpSet.getHomeID();
                }
                this.hb.setCurrentID((Map.ID)object);
                this.hb.setDisplayed(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (vector != null) {
                object = vector.elements();
                while (object.hasMoreElements()) {
                    this.resetAndRestoreCursors((Container)object.nextElement());
                }
            }
            this.cursors = null;
        }

        private Vector getTopContainers(Object object) {
            Object object2;
            Vector<Object> vector = new Vector<Object>();
            Component component = null;
            if (object instanceof Component) {
                component = this.getTopComponentForComponent((Component)object);
            } else if (object instanceof MenuItem) {
                component = this.getTopComponentForMenuItem((MenuItem)object);
            }
            if (component instanceof Applet) {
                object2 = ((Applet)component).getAppletContext().getApplets();
                while (object2.hasMoreElements()) {
                    vector.add(object2.nextElement());
                }
            }
            object2 = Frame.getFrames();
            int n = 0;
            while (n < ((Object)object2).length) {
                Window[] windowArray = ((Window)object2[n]).getOwnedWindows();
                int n2 = 0;
                while (n2 < windowArray.length) {
                    vector.add(windowArray[n2]);
                    ++n2;
                }
                if (!vector.contains(object2[n])) {
                    vector.add(object2[n]);
                }
                ++n;
            }
            return vector;
        }

        private Component getTopComponentForComponent(Component component) {
            Component component2 = component;
            while (component2 != null) {
                component = component2;
                if (component2 instanceof Window || component2 instanceof Applet) break;
                if (component2 instanceof MenuElement) {
                    component2 = component2 instanceof JPopupMenu ? ((JPopupMenu)component2).getInvoker() : ((MenuElement)((Object)component2)).getComponent();
                }
                component2 = component2.getParent();
            }
            return component;
        }

        private Component getTopComponentForMenuItem(MenuItem menuItem) {
            MenuContainer menuContainer;
            MenuContainer menuContainer2 = menuContainer = menuItem.getParent();
            while (menuContainer2 != null) {
                if (menuContainer2 instanceof Component) break;
                menuContainer = menuContainer2;
                menuContainer2 = ((MenuComponent)((Object)menuContainer)).getParent();
            }
            if (menuContainer2 == null) {
                return null;
            }
            Component component = this.getTopComponentForComponent((Component)menuContainer2);
            return component;
        }

        private void setCursor(Component component, Cursor cursor) {
            CSH.debug("setCursor");
            if (component == null) {
                return;
            }
            this.cursorStack = new Stack();
            this.setAndStoreCursors(component, cursor);
            this.cursorStack = null;
        }

        private void setAndStoreCursors(Component component, Cursor cursor) {
            boolean bl = false;
            Cursor cursor2 = component.getCursor();
            if (this.cursorStack.empty()) {
                this.cursorStack.push(cursor2);
                this.cursors.put(component, cursor2);
                bl = true;
                CSH.debug("store cursor " + cursor2 + " on " + component);
            } else if (cursor2 != (Cursor)this.cursorStack.peek()) {
                this.cursorStack.push(cursor2);
                this.cursors.put(component, cursor2);
                bl = true;
                CSH.debug("store cursor " + cursor2 + " on " + component);
            }
            if (component instanceof Container) {
                Container container = (Container)component;
                int n = container.getComponentCount();
                Component[] componentArray = container.getComponents();
                int n2 = 0;
                while (n2 < n) {
                    Component component2 = componentArray[n2];
                    if (component != null) {
                        this.setAndStoreCursors(component2, cursor);
                    }
                    ++n2;
                }
            }
            component.setCursor(cursor);
            CSH.debug("set cursor on " + component);
            if (bl) {
                this.cursorStack.pop();
            }
        }

        private void resetAndRestoreCursors(Component component) {
            CSH.debug("resetAndRestoreCursors");
            if (component == null) {
                return;
            }
            this.cursorStack = new Stack();
            this.restoreCursors(component);
            this.cursorStack = null;
        }

        private void restoreCursors(Component component) {
            boolean bl = false;
            Cursor cursor = (Cursor)this.cursors.get(component);
            if (cursor != null) {
                this.cursorStack.push(cursor);
                component.setCursor(cursor);
                CSH.debug("restored cursor " + cursor + " on " + component);
                bl = true;
            } else if (!this.cursorStack.empty()) {
                component.setCursor((Cursor)this.cursorStack.peek());
                CSH.debug("restored cursor " + (Cursor)this.cursorStack.peek() + " on " + component);
            }
            if (component instanceof Container) {
                Container container = (Container)component;
                int n = container.getComponentCount();
                Component[] componentArray = container.getComponents();
                int n2 = 0;
                while (n2 < n) {
                    Component component2 = componentArray[n2];
                    if (component != null) {
                        this.restoreCursors(component2);
                    }
                    ++n2;
                }
            }
            if (bl) {
                this.cursorStack.pop();
            }
        }
    }

    public static class DisplayHelpFromFocus
    implements ActionListener {
        private HelpBroker hb;

        public DisplayHelpFromFocus(HelpBroker helpBroker) {
            if (helpBroker == null) {
                throw new NullPointerException("hb");
            }
            this.hb = helpBroker;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            Component component2 = (Component)actionEvent.getSource();
            if (this.hb instanceof DefaultHelpBroker) {
                component = SwingUtilities.windowForComponent(component2);
                ((DefaultHelpBroker)this.hb).setActivationWindow((Window)component);
            }
            if ((component = CSH.findFocusOwner(component2)) == null) {
                component = component2;
            }
            String string = CSH.getHelpIDString(component);
            HelpSet helpSet = CSH.getHelpSet(component);
            if (helpSet == null) {
                helpSet = this.hb.getHelpSet();
            }
            try {
                Map.ID iD;
                block7: {
                    iD = null;
                    try {
                        iD = Map.ID.create(string, helpSet);
                    }
                    catch (BadIDException badIDException) {
                        iD = helpSet.getHomeID();
                        if (iD != null) break block7;
                        throw badIDException;
                    }
                }
                this.hb.setCurrentID(iD);
                this.hb.setDisplayed(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

