/*Data Access Library. v. 1.1.
 *Connection support. Support class of DA Library.
 *AUTHOR:  Alexander Jaremenko <jarem@altavista.net>
 *RELEASE DATE: 
 */

package JProjects.eab.data;

/**Supports connection events.<p> Used in <code>DatastoreJDBC</code>.</p>
 *@see ConnectionListener
 *@see DatastoreJDBC#addConnectionListener
 *@see DatastoreJDBC#removeConnectionListener
 *@author Alexander Jaremenko  <address><a href="mailto:jarem@altavista.net">&lt jarem@altavista.net &gt</a></address>
 */ 
public class ConnectionSupport extends ParameterSupport {

    public ConnectionSupport(Object src) {
	super(src);
    }

    public void addConnectionListener(ConnectionListener l) {
	addParameterListener(l);
    }

    public void fireCancelled() {
	ConnectionEvent ev = new ConnectionEvent(_source,"cancel()");
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof ConnectionListener)
		((ConnectionListener)_listeners[i]).cancelled(ev);
    }

    public void fireCommitted() {
	ConnectionEvent ev = new ConnectionEvent(_source,"commit()");
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof ConnectionListener)
		((ConnectionListener)_listeners[i]).committed(ev);
    }

    public void fireConnected(String acnN) {
	ConnectionEvent ev = new ConnectionEvent(_source,acnN);
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof ConnectionListener)
		((ConnectionListener)_listeners[i]).connected(ev);
    }

    public void fireDisconnected() {
	ConnectionEvent ev = new ConnectionEvent(_source,"disconnect()");
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof ConnectionListener)
		((ConnectionListener)_listeners[i]).disconnected(ev);
    }

    public void fireExecutedSQL() {
	ConnectionEvent ev = new ConnectionEvent(_source,"executeSQL(String)");
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof ConnectionListener)
		((ConnectionListener)_listeners[i]).executedSQL(ev);
    }

    public void fireRolledback() {
	ConnectionEvent ev = new ConnectionEvent(_source,"rollback()");
	for (int i=0; i<_listeners.length && _listeners[i]!=null; i++)
	    if (_listeners[i] instanceof ConnectionListener)
		((ConnectionListener)_listeners[i]).rolledback(ev);
    }

    public void removeConnectionListener(ConnectionListener l) {
	removeParameterListener(l);
    }
}
