package com.tolstoy.imagemeister;

import com.jconfig.*;
import java.io.*;
import java.awt.*;
import java.util.*;

/**
Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.
*/

class IMUtils {
	private static final String copyright="ImageMeister Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.";

/**
Converts "com/apackage/aclass.class" to "com.apackage.aclass"
*/

	static String zipFileNameToJavaClassName( String in ) {
		StringBuffer		sb;
		int					i, len;
		
		if ( in == null )
			return "";

		sb = new StringBuffer( in );
		len = sb.length();
		for ( i = 0; i < len; i++ )
			if ( sb.charAt( i ) == '/' )
				sb.setCharAt( i, '.' );
		
		if ( ( in.toLowerCase() ).endsWith( ".class" ) )
			sb.setLength( len - 6 );

		return new String( sb );
	}

/**
Create a FileSpecifier from a DiskObject.
*/

	static FileSpecifier makeFileSpecifier( DiskObject diskObj ) {
		FileExtension		ext;
		FinderInfo			finderInfo;

		try {
			ext = new FileExtension( diskObj.getName().toLowerCase() );
		}
		catch ( Exception e ) {
			ext = null;
		}
		
		try {
			finderInfo = ( (DiskFile) diskObj ).getFinderInfo();
		}
		catch ( Exception e ) {
			finderInfo = null;
		}
		
		return new FileSpecifier( diskObj, null, finderInfo, ext );
	}

/**
Read a series of lines from a file, and return an array containing each of the Strings.
*/

	static String[] fileToStringArray( String fileName ) {
		DataInputStream		dis;
		Vector				lines;
		String				tempStr, retArray[];
		int					i;

		lines = new Vector( 10, 10 );

		try {
			dis = new DataInputStream( new FileInputStream( fileName ) );

			for ( i = 0; i < 1000; i++ ) {		
				tempStr = dis.readLine();
				if ( tempStr == null || tempStr == "" )
					break;
				lines.addElement( tempStr );
			}

			dis.close();
		}
		catch ( Exception e ) {
			return null;
		}
		
		if ( lines.size() < 1 )
			return null;
		
		retArray = new String[ lines.size() ];
		lines.copyInto( retArray );
		
		return retArray;
	}
	
	private IMUtils() {
	}
}
