package com.tolstoy.imagemeister;

import java.awt.*;
import java.awt.image.*;

/**
An image button which toggles its state.

Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.
*/

class ImageButtonToggle extends Canvas implements ImageObserver {
	private static final String copyright="ImageMeister Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.";

	Image			uImage, dImage;
	int				w,h;
	boolean			bIsDown, bFirstTime;

/**
@param fileNameU path of the file containing the image to be shown when the button is up.
@param fileNameD path of the file containing the image to be shown when the button is down.
*/
	
	public ImageButtonToggle( String fileNameU, String fileNameD, int w, int h ) {
		this.w = w;
		this.h = h;
		uImage = Toolkit.getDefaultToolkit().getImage( fileNameU );
		dImage = Toolkit.getDefaultToolkit().getImage( fileNameD );
		bIsDown = false;
		bFirstTime = true;
	}
	
	public boolean getState() {
		return bIsDown;
	}

	public void setState( boolean b ) {
		bIsDown = b;
		repaint();
	}

	public boolean mouseDown( Event e, int x, int y ) {
		Event			newE;

		if ( e.target != this )
			return false;

		bIsDown = !bIsDown;
		repaint();

		newE = new Event( this, e.when, Event.ACTION_EVENT, x, y, 0, 0 );
		this.postEvent( newE );

		return true;
	}

	public void paint( Graphics g ) {
		if ( bFirstTime ) {
			bFirstTime = false;
			if ( bIsDown ) {
				g.drawImage( uImage, 0, 0, this );
				g.drawImage( dImage, 0, 0, this );
			}
			else {
				g.drawImage( dImage, 0, 0, this );
				g.drawImage( uImage, 0, 0, this );
			}
			
			return;
		}

		if ( bIsDown )
			g.drawImage( dImage, 0, 0, this );
		else
			g.drawImage( uImage, 0, 0, this );
	}

	public Dimension minimumSize() {
		return new Dimension( w, h );
	}

	public Dimension preferredSize() {
		return new Dimension( w, h );
	}

	public Dimension size() {
		return new Dimension( w, h );
	}
}
