/*
 * Decompiled with CFR 0.152.
 */
package jdbees.ftp;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import jdbees.JBeesConfInfo;
import jdbees.JBeesNetworkIO;

public class JBeesFtpDataChannel {
    private boolean debug = false;
    private String dataIP;
    private int dataPort;
    private long fileLength;
    private JBeesNetworkIO jbnio;
    private DataInputStream dis;
    private JBeesConfInfo jbconf;

    public JBeesFtpDataChannel(String dataIP, int dataPort, JBeesConfInfo jbconf) throws IOException {
        this.dataIP = dataIP;
        this.dataPort = dataPort;
        this.jbconf = jbconf;
        if (this.debug) {
            System.out.println("create datachannel at " + dataIP + ":" + dataPort);
        }
        this.getStream();
    }

    public void close() throws IOException {
        this.dis.close();
        this.jbnio.close();
    }

    private void getStream() throws IOException {
        this.jbnio = new JBeesNetworkIO(this.dataIP, this.dataPort);
        if (this.jbconf.getSocketTimeout() > 0) {
            this.jbnio.setTimeout(this.jbconf.getSocketTimeout());
        }
        this.dis = this.jbnio.getDataInputStream();
        if (this.debug) {
            System.out.println("Create datachannel successfully");
        }
    }

    public String readLine() throws IOException {
        StringBuffer sb = new StringBuffer();
        try {
            while (true) {
                byte c;
                if ((c = this.dis.readByte()) == 13 || c == 10) {
                    this.dis.readByte();
                    break;
                }
                sb.append((char)c);
            }
        }
        catch (EOFException eOFException) {
            return null;
        }
        return sb.toString();
    }

    public DataInputStream getDataInputStream() {
        return this.dis;
    }
}

