/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.shell;

public class TrayMessage {
    public static final int ICON_NONE = 0;
    public static final int ICON_INFO = 1;
    public static final int ICON_WARNING = 2;
    public static final int ICON_ERROR = 3;
    private String _title;
    private String _message;
    private int _iconType = 0;
    private int _timeout = 10;

    public TrayMessage(String message) {
        this(null, message);
    }

    public TrayMessage(String message, int iconType) {
        this(null, message, iconType);
    }

    public TrayMessage(String title, String message) {
        this(title, message, 0);
    }

    public TrayMessage(String title, String message, int iconType) {
        this.setTitle(title);
        this.setMessage(message);
        this.setIconType(iconType);
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getMessage() {
        return this._message;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public int getIconType() {
        return this._iconType;
    }

    public void setIconType(int iconType) {
        switch (iconType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this._iconType = iconType;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }

    static {
        ICON_NONE = 0;
        ICON_INFO = 1;
        ICON_WARNING = 2;
        ICON_ERROR = 3;
    }

    public static class Error
    extends TrayMessage {
        public Error(String title, String message) {
            super(title, message, 3);
        }
    }

    public static class Warning
    extends TrayMessage {
        public Warning(String title, String message) {
            super(title, message, 2);
        }
    }

    public static class Info
    extends TrayMessage {
        public Info(String title, String message) {
            super(title, message, 1);
        }
    }
}

