/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper;

import com.jniwrapper.Library;
import com.jniwrapper.Parameter;

public final class PlatformContext {
    private static final int NOT_INITALIZED = -1;
    private static boolean _isSysInfoLoaded;
    private static int _boolLength;
    private static int _wideCharLength;
    private static int _pointerLength;
    private static int _alignedPointerLength;
    private static int _shortLength;
    private static int _intLength;
    private static int _longLength;
    private static int _floatLength;
    private static int _doubleLength;
    private static int _longDoubleLength;
    private static boolean _isLittleEndian;
    private static short _parameterAlignment;
    private static short _defaultStructureAlignment;
    private static byte _defaultCallingConvention;

    private PlatformContext() {
    }

    public static int getCharLength() {
        return 1;
    }

    public static int getWideCharLength() {
        if (!_isSysInfoLoaded) {
            PlatformContext.loadSysInfo();
        }
        return _wideCharLength;
    }

    private static native int doGetWideCharLength();

    public static int getBoolLength() {
        if (!_isSysInfoLoaded) {
            PlatformContext.loadSysInfo();
        }
        return _boolLength;
    }

    private static native int doGetBoolLength();

    public static int getPointerLength() {
        if (!_isSysInfoLoaded) {
            PlatformContext.loadSysInfo();
        }
        return _pointerLength;
    }

    private static native int doGetPointerLength();

    public static int getShortLength() {
        if (!_isSysInfoLoaded) {
            PlatformContext.loadSysInfo();
        }
        return _shortLength;
    }

    private static native int doGetShortLength();

    public static int getIntLength() {
        if (!_isSysInfoLoaded) {
            PlatformContext.loadSysInfo();
        }
        return _intLength;
    }

    private static native int doGetIntLength();

    public static int getLongLength() {
        if (!_isSysInfoLoaded) {
            PlatformContext.loadSysInfo();
        }
        return _longLength;
    }

    private static native int doGetLongLength();

    public static int getFloatLength() {
        if (!_isSysInfoLoaded) {
            PlatformContext.loadSysInfo();
        }
        return _floatLength;
    }

    private static native int doGetFloatLength();

    public static int getDoubleLength() {
        if (!_isSysInfoLoaded) {
            PlatformContext.loadSysInfo();
        }
        return _doubleLength;
    }

    private static native int doGetDoubleLength();

    public static int getLongDoubleLength() {
        if (!_isSysInfoLoaded) {
            PlatformContext.loadSysInfo();
        }
        return _longDoubleLength;
    }

    private static native int doGetLongDoubleLength();

    public static boolean isLittleEndian() {
        if (!_isSysInfoLoaded) {
            PlatformContext.loadSysInfo();
        }
        return _isLittleEndian;
    }

    private static native boolean doIsLittleEndian();

    public static short getParameterAlignment() {
        if (!_isSysInfoLoaded) {
            PlatformContext.loadSysInfo();
        }
        return _parameterAlignment;
    }

    private static native short doGetParameterAlignment();

    public static short getDefaultStructureAlignment() {
        if (!_isSysInfoLoaded) {
            PlatformContext.loadSysInfo();
        }
        return _defaultStructureAlignment;
    }

    private static native short doGetDefaultStructureAlignment();

    public static byte getDefaultCallingConvention() {
        if (!_isSysInfoLoaded) {
            PlatformContext.loadSysInfo();
        }
        return _defaultCallingConvention;
    }

    private static native byte doGetDefaultCallingConvention();

    public static native byte[] convertDoubleToCFloat(double var0);

    public static native double convertCFloatToDouble(byte[] var0);

    public static native byte[] convertDoubleToCDouble(double var0);

    public static native double convertCDoubleToDouble(byte[] var0);

    public static native byte[] convertDoubleToCLongDouble(double var0);

    public static native double convertCLongDoubleToDouble(byte[] var0);

    public static native int strlen(long var0);

    public static native int wcslen(long var0);

    private static void loadSysInfo() {
        if (!_isSysInfoLoaded) {
            Library.ensureNativeCode();
            _boolLength = PlatformContext.doGetBoolLength();
            _wideCharLength = PlatformContext.doGetWideCharLength();
            _pointerLength = PlatformContext.doGetPointerLength();
            _shortLength = PlatformContext.doGetShortLength();
            _intLength = PlatformContext.doGetIntLength();
            _longLength = PlatformContext.doGetLongLength();
            _floatLength = PlatformContext.doGetFloatLength();
            _doubleLength = PlatformContext.doGetDoubleLength();
            _longDoubleLength = PlatformContext.doGetLongDoubleLength();
            _isLittleEndian = PlatformContext.doIsLittleEndian();
            _parameterAlignment = PlatformContext.doGetParameterAlignment();
            _defaultStructureAlignment = PlatformContext.doGetDefaultStructureAlignment();
            _defaultCallingConvention = PlatformContext.doGetDefaultCallingConvention();
            _isSysInfoLoaded = true;
        }
    }

    public static int getAlignedPointerLength() {
        if (_alignedPointerLength == -1) {
            _alignedPointerLength = PlatformContext.getAlignedParameterLength(PlatformContext.getPointerLength());
        }
        return _alignedPointerLength;
    }

    public static int getAlignedParameterLength(int n2) {
        if (!_isSysInfoLoaded) {
            PlatformContext.loadSysInfo();
        }
        return (n2 += _parameterAlignment - 1) - n2 % _parameterAlignment;
    }

    public static int getAlignedParameterLength(Parameter parameter) {
        return PlatformContext.getAlignedParameterLength(parameter.getLength());
    }

    static {
        NOT_INITALIZED = -1;
        _isSysInfoLoaded = false;
        _alignedPointerLength = -1;
    }
}

