/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.win32.samples.demo.HTMLText;
import com.jniwrapper.win32.samples.demo.LazyPanel;
import com.jniwrapper.win32.ui.AWTWindowDecorator;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class WindowDecoratorSample
extends LazyPanel {
    private JLabel lblAdvisoryText;
    private JCheckBox chkTransparent;
    private JCheckBox chkTopmost;
    private JCheckBox chkPalette;
    private JCheckBox chkCaption;
    private JSlider _slider;
    private AWTWindowDecorator _decorator;

    public WindowDecoratorSample(Window parent) {
        super(parent);
    }

    public void initialize() throws Exception {
        final Window parent = this.getParentWindow();
        this._decorator = new AWTWindowDecorator(parent);
        this.lblAdvisoryText = new HTMLText("This page demonstrates WindowDecorator features.");
        this.chkTransparent = new JCheckBox("Transparent", false);
        this.chkTransparent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean transparent = WindowDecoratorSample.this.chkTransparent.isSelected();
                byte transparency = (byte)WindowDecoratorSample.this._slider.getValue();
                WindowDecoratorSample.this._decorator.setTransparent(transparent);
                WindowDecoratorSample.this._decorator.setTransparency(transparency);
            }
        });
        this._slider = new JSlider(0);
        this._slider.setMinimum(0);
        this._slider.setMaximum(255);
        this._slider.setValue(255);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("Transparent"));
        labelTable.put(new Integer(255), new JLabel("Opaque"));
        this._slider.setLabelTable(labelTable);
        this._slider.setMajorTickSpacing(10);
        this._slider.setPaintTicks(true);
        this._slider.setPaintLabels(true);
        this._slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (WindowDecoratorSample.this._decorator.isTransparent() & !source.getValueIsAdjusting()) {
                    byte transparency = (byte)source.getValue();
                    WindowDecoratorSample.this._decorator.setTransparency(transparency);
                }
            }
        });
        this.chkTopmost = new JCheckBox("Topmost", false);
        this.chkTopmost.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowDecoratorSample.this._decorator.setTopmost(WindowDecoratorSample.this.chkTopmost.isSelected());
            }
        });
        this.chkPalette = new JCheckBox("Palette Style", false);
        this.chkPalette.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowDecoratorSample.this._decorator.setPalleteWindow(WindowDecoratorSample.this.chkPalette.isSelected());
                parent.validate();
            }
        });
        this.chkCaption = new JCheckBox("Show Caption", true);
        this.chkCaption.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowDecoratorSample.this._decorator.setCaptionVisible(WindowDecoratorSample.this.chkCaption.isSelected());
                parent.validate();
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblAdvisoryText, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.chkTransparent, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._slider, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 10), 0, 0));
        this.add((Component)this.chkTopmost, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.chkPalette, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.chkCaption, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        super.initialize();
    }
}

