/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
import com.jniwrapper.*;
import com.jniwrapper.win32.registry.RegistryException;
import com.jniwrapper.win32.registry.RegistryItem;

/**
 * Sample for rgistry operations.
 * @author Alexei Vidmich
 */
public class RegistrySample
{
    private static final String TEST_KEY_PATH = "Software\\JNIWrapper\\TestPath";

    static
    {
        DefaultLibraryLoader.getInstance().addPath("Bin");
    }

    public static void main(String[] args)
    {
        RegistrySample registry = new RegistrySample();
        try
        {
            registry.testDeletingKey();
            registry.testSimpleString();
            registry.testUnicodeSimpleString();
            registry.testBinaryData();
            registry.testCInt32();
            registry.testDoubleZeroEndianSimpleString();
            registry.testDoubleZeroEndianWideString();
        }
        catch (Exception e)
        {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void testDeletingKey()
    {
        final int keyHandle = RegistryItem.HKEY_LOCAL_MACHINE;
        final String keyPath = "Software\\JNIWrapper";
        final String keyName = "TestPath";

        RegistryItem regItem = new RegistryItem(keyHandle, keyPath, keyName, null, RegistryItem.REG_MULTI_SZ);
        regItem.delete();

        try
        {
            regItem = new RegistryItem(keyHandle, keyPath, keyName, null, RegistryItem.REG_MULTI_SZ);
            regItem.delete();   // Exception must be thrown because there is no such key defined.
            throw new RuntimeException("Registry key is present before edding it");
        }
        catch (RegistryException e)
        {
            String errorMessage = e.getMessage();
            if (errorMessage.charAt(errorMessage.length() - 1) != '2')
            {
                throw new RuntimeException("Registry key is not deleted");
            }
            System.out.println("Checked failing when deleting non-existent key");
        }
    }

    public void testSimpleString() throws Exception
    {
        final int keyHandle = RegistryItem.HKEY_LOCAL_MACHINE;
        final String keyPath = TEST_KEY_PATH;
        final String keyName = "SimpleStringTest";
        final AnsiString keyValue = new AnsiString("passed");
        final AnsiString emptyKey = new AnsiString(7);

        readWriteRegistry(
            keyHandle,
            keyPath,
            keyName,
            keyValue,
            emptyKey,
            RegistryItem.REG_SZ);

        System.out.println("Checked storing simple string");
    }

    public void testUnicodeSimpleString() throws Exception
    {
        final int keyHandle = RegistryItem.HKEY_LOCAL_MACHINE;
        final String keyPath = TEST_KEY_PATH;
        final String keyName = "WideStringTest";
        final AnsiString keyValue = new AnsiString("passed\u0430");
        final AnsiString emptyKey = new AnsiString(8);

        readWriteRegistry(
            keyHandle,
            keyPath,
            keyName,
            keyValue,
            emptyKey,
            RegistryItem.REG_SZ);

        System.out.println("Checked storing simple Unicode string");
    }

    public void testBinaryData() throws Exception
    {
        final int keyHandle = RegistryItem.HKEY_LOCAL_MACHINE;
        final String keyPath = TEST_KEY_PATH;
        final String keyName = "BinaryDataTest";
        final PrimitiveArray keyValue = new PrimitiveArray(new Int32(5), 10);
        final PrimitiveArray emptyKey = new PrimitiveArray(new Int32(), 10);

        readWriteRegistry(
            keyHandle,
            keyPath,
            keyName,
            keyValue,
            emptyKey,
            RegistryItem.REG_BINARY);

        System.out.println("Checked storing binary data");
    }

    public void testCInt32() throws Exception
    {
        final int keyHandle = RegistryItem.HKEY_LOCAL_MACHINE;
        final String keyPath = TEST_KEY_PATH;
        final String keyName = "DWORDTest";
        final Int32 keyValue = new Int32(2000);
        final Int32 emptyKey = new Int32();

        readWriteRegistry(
            keyHandle,
            keyPath,
            keyName,
            keyValue,
            emptyKey,
            RegistryItem.REG_DWORD);

        System.out.println("Checked storing simple string");
    }

    public void testDoubleZeroEndianSimpleString() throws Exception
    {
        final int keyHandle = RegistryItem.HKEY_LOCAL_MACHINE;
        final String keyPath = TEST_KEY_PATH;
        final String keyName = "DoubleZeroEndianSimpleStringTest";
        final AnsiString CkeyValue = new AnsiString("passed\u0000");
        final AnsiString emptyKey = new AnsiString(9);

        readWriteRegistry(
            keyHandle,
            keyPath,
            keyName,
            CkeyValue,
            emptyKey,
            RegistryItem.REG_MULTI_SZ);

        System.out.println("Checked storing double zero endian simple string");
    }

    public void testDoubleZeroEndianWideString() throws Exception
    {
        final int keyHandle = RegistryItem.HKEY_LOCAL_MACHINE;
        final String keyPath = TEST_KEY_PATH;
        final String keyName = "DoubleZeroEndianWideStringTest";
        final WideString CkeyValue = new WideString("passed\u0430\u0000");
        final WideString emptyKey = new WideString(10);

        readWriteRegistry(
            keyHandle,
            keyPath,
            keyName,
            CkeyValue,
            emptyKey,
            RegistryItem.REG_MULTI_SZ);

        System.out.println("Checked storing double zero endian wide string");
    }

    private void readWriteRegistry(
        int keyHandle,
        String keyPath,
        String keyName,
        Parameter keyValue,
        Parameter emptyKey,
        int keyType)
    {
        RegistryItem regItem = new RegistryItem(keyHandle, keyPath, keyName, keyValue, keyType);
        regItem.write();

        regItem = new RegistryItem(keyHandle, keyPath, keyName, emptyKey, keyType);
        regItem.read();

        Parameter value = regItem.getValue();
        if (!keyValue.equals(value))
        {
            throw new RuntimeException("registry value");
        }
    }
}
