/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.win32.samples.TransparentNativeWindow;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * @author Serge Piletsky
 */
class NativeWindowSample extends LazyPanel implements ActionListener
{
    private JLabel lblAdvisoryText;
    private JButton btnShowWindow;

    public NativeWindowSample(Window parent)
    {
        super(parent);
    }

    public void initialize() throws Exception
    {
        lblAdvisoryText = new JLabel("This sample demonstrates Native Window crated with WinPack.");
        btnShowWindow = new JButton("Show Window");
        setLayout(new GridBagLayout());

        add(lblAdvisoryText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 10, 10), 0, 0));

        add(btnShowWindow, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0,
                  GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(20, 0, 0, 0), 0, 0));

        add(new JPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0
                , GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

        btnShowWindow.addActionListener(this);

        super.initialize();
    }

    public void actionPerformed(ActionEvent e)
    {
        TransparentNativeWindow window = new TransparentNativeWindow();
        window.run();
    }
}
