/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.shell.SHFileInfo;

import javax.swing.*;
import javax.swing.tree.DefaultTreeCellRenderer;
import java.awt.*;

/**
 * @author Serge Piletsky
 */
class TreeCellRenderer extends DefaultTreeCellRenderer
{
    private static ImageIcon FOLDER_ICON = new ImageIcon(Icon.extractSmallAssociatedIcon("").toImage());
    private static ImageIcon FOLDER_OPEN_ICON =
            new ImageIcon(SHFileInfo.getFileInfo("",
                    SHFileInfo.SHGFI_SMALLICON |
                    SHFileInfo.SHGFI_ICON |
                    SHFileInfo.SHGFI_OPENICON).getIcon().toImage());

    public TreeCellRenderer()
    {
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value,
        boolean sel,
        boolean expanded,
        boolean leaf, int row,
        boolean hasFocus)
    {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (!leaf)
        {
            if (expanded)
            {
                setIcon(FOLDER_OPEN_ICON);
            }
            else
            {
                setIcon(FOLDER_ICON);
            }
        }
        return this;
    }
}
