/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.ui.controls;

import com.jniwrapper.win32.ui.dialogs.SelectFolderDialog;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;

/**
 * Class SelectFolderField is component for selecting folder that uses SelectFolderDialog.
 *
 * @author Serge Piletsky
 */
public class SelectFolderField extends AbstractChooserField
{
    public static final String PROPERTY_FOLDER = "folder";

    public static final int MODE_SELECT_FOLDER = 0;
    public static final int MODE_SELECT_PRINTER = 1;
    public static final int MODE_SELECT_COMPUTER = 2;

    private int _mode = MODE_SELECT_FOLDER;
    private SelectFolderDialog _dialog;

    public SelectFolderField()
    {
        super();
    }

    public SelectFolderField(int mode)
    {
        this();
        setMode(mode);
    }

    /**
     * Sets initially selected folder.
     * @param folder
     */
    public void setFolder(String folder)
    {
        getTextField().setText(folder);
    }

    /**
     * Returns selected folder.
     * @return selcted folder
     */
    public String getFolder()
    {
        return getTextField().getText();
    }

    /**
     * Returns dialog mode.
     * @return dialog mode
     */
    public int getMode()
    {
        return _mode;
    }

    /**
     * Sets dialog mode.
     * @param mode is a dialog mode
     */
    public void setMode(int mode)
    {
        _mode = mode;
    }

    public void actionPerformed(ActionEvent e)
    {
        SelectFolderDialog dialog = getDialog();
        String oldFolder = dialog.getFolder();
        if (dialog.execute())
        {
            String newFolder = dialog.getFolder();
            setFolder(newFolder);
            firePropertyChange(PROPERTY_FOLDER, oldFolder, newFolder);
        }
    }

    /**
     * Creates dialog instance depending on field mode.
     * @return dialog
     */
    protected SelectFolderDialog createDialog()
    {
        switch(getMode())
        {
            case MODE_SELECT_FOLDER:
                return new SelectFolderDialog();
            case MODE_SELECT_PRINTER:
                return SelectFolderDialog.createBrowseForPrintersDialog();
            case MODE_SELECT_COMPUTER:
                return SelectFolderDialog.createBrowseForComputersDialog();
            default:
                throw new IllegalArgumentException();
        }
    }

    /**
     * Returns dialog.
     * @return dialog
     */
    public SelectFolderDialog getDialog()
    {
        if (_dialog == null)
        {
            Window parent = SwingUtilities.getWindowAncestor(this);
            _dialog = createDialog();
            _dialog.setOwner(parent);
        }
        return _dialog;
    }
}
