//-[stdhead]-------------------------------------------------------
//Project:Java preprocessor
//File   :parser.h
//Started:05.07.00 11:15:21
//Updated:23.07.00 13:13:21
//Author :Nick E. Geht
//Subj   :Jpp source parser
//Version:1.0
//Requres:
//-----------------------------------------------------------------
typedef struct _tag_JppSource {                 //Jpp source file descriptor
        char       szFileName[MAX_PATH];        //name of the file
        CJppLexer *pLexer;                      //lexer object
}JppSource;                                     //
//----------------------------------------------//
typedef struct _tag_Define {                    //define descriptor
        char       szDefine[64];                //define identifier
        char       szValue[MAX_PATH];           //define value
}JppDefine;                                     //
//----------------------------------------------//
typedef struct _tag_Inline {                    //Inline descriptor
        char       szName[64];                  //Inline name
        char       szInline[1024];              //up to 1Kb of Inline body
}JppInline;                                     //

class CJppParser
{
 public:
        CJppParser();                           //initialize parser
        ~CJppParser();                          //release parser
        //--------------------------------------//
        bool Compile(PSTR,PSTR,PSTR,            //
                     bool);                     //compile jpp sources
        bool Process(FILE *,PSTR);              //process source
        int  AddDefine(PSTR,PSTR);              //add define
        int  AddInline(PSTR,PSTR);              //add define
        //--------------------------------------//
 protected:                                     //
        int        AddFile(PSTR);               //add file to source list
        int CheckAndProcessDefine(char *, FILE *);  //check and process define
        int CheckAndProcessInline(char *, FILE *,CJppLexer *,char *);  //check and process define
        //--------------------------------------//
        JppSource  m_pSources[32];              //list of source files
        int        m_nSources;                  //count of jpp sources
        char       m_szOutFile[MAX_PATH];       //output file name
        char       m_szErrFile[MAX_PATH];       //error file name
        int        m_nSourceFiles[32767];       //files from which output line was getted
        int        m_nSourceLines[32767];       //line in source file from which output line was getted
        int        m_nOutputLine;               //line number in the output file
        JppDefine  m_pDefines[2048];            //define list
        int        m_nDefines;                  //define quantity
        JppInline  m_pInlines[1024];            //inlines list
        int        m_nInlines;                  //inlines quantity

};
