


// This example is from _Java Examples in a Nutshell_. (http://www.oreilly.com)
// Copyright (c) 1997 by David Flanagan
// This example is provided WITHOUT ANY WARRANTY either expressed or implied.
// You may study, use, modify, and distribute it for non-commercial purposes.
// For any commercial use, see http://www.davidflanagan.com/javaexamples
import java.awt.*;
import java.io.*;
import java.net.*;

/**
 * This Pipes class serves to group a number of pipe classes and interfaces.
 * It has no fields or methods of its own; its only members are static
 * classes and interfaces.  
 **/
public class Pipes {
  /**
   * This class contains a test program for the pipe classes below.
   * It also demonstrates how you typically use these pipes classes.
   * It is basically another implementation of a Unix-like grep command.
   * With the pipe infrastructure defined below, it is easy to define
   * new filters and create pipes to perform many useful operations.
   * Other filter possibilities include sorting lines, removing
   * duplicate lines, and doing search-and-replace.
   **/
   static String Searchterm = null;
   static String Pageterm = "";
   static boolean gotdata = false;
   static boolean finished = false; 
   static String fieldGotit = "";    
 
  
	 
	
	protected transient java.beans.PropertyChangeSupport propertyChange = new java.beans.PropertyChangeSupport(this);
	

/**
 * The addPropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	propertyChange.addPropertyChangeListener(listener);
}
/**
 * The firePropertyChange method was generated to support the propertyChange field.
 */
public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
	propertyChange.firePropertyChange(propertyName, oldValue, newValue);
}
/**
 * Gets the gotit property (String value.
 * @return The gotit property value.
 * @see #setGotit
 */
public String getGotit() {
	/* Returns the gotit property value. */
	return fieldGotit;
}
/**
 * Gets the searchterm property (java.lang.String) value.
 * @return The searchterm property value.
 * @see #setSearchterm
 */
public String getSearchterm() {
	/* Returns the searchterm property value. */
	if (Pipes.Searchterm == null) {
		try {
			Pipes.Searchterm = new String();
		} catch (Throwable exception) {
			System.err.println("Exception creating searchterm property.");
		}
	};
	return Searchterm;
}
/**
 * The removePropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	propertyChange.removePropertyChangeListener(listener);
}
/**
 * Sets the gotit property (byte[]) value.
 * @param gotit The new value for the property.
 * @see #getGotit
 */
public void setGotit(String gotit) {
	/* Get the old property value for fire property change event. */
	String oldValue = fieldGotit;
	/* Set the gotit property (attribute) to the new value. */
	fieldGotit = gotit;
	/* Fire (signal/notify) the gotit property change event. */
	firePropertyChange("gotit", oldValue, gotit);
	return;
}
/**
 * Sets the searchterm property (java.lang.String) value.
 * @param searchterm The new value for the property.
 * @see #getSearchterm
 */
public void setSearchterm(String searchterm) {
	/* Get the old property value for fire property change event. */
	String oldValue = Pipes.Searchterm;
	/* Set the searchterm property (attribute) to the new value. */
	Pipes.Searchterm = searchterm;
	/* Fire (signal/notify) the searchterm property change event. */
	firePropertyChange("searchterm", oldValue, searchterm);
	return;
}
}