/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Version 1.0
 *
 * PRePTagBOOLEAN: It can be very useful to check if something is true or false. 
 *                 This is possible with the BOOLEAN tag.
 *
 *                 
 *                 {BOOLEAN::some_text::compare_sign::some_text::output_if_true::output_if_false}
 *                 where compare_sign is a '<', '>' or a '='
 *
 * History: - Creation 02/10/99 nh
 *
 * Date: 02/10/99
 *
 * @author nh
 * @version 1.0
 */

package com.delec.prep;

public class PRePTagBOOLEAN extends PRePTagCode
{

	public PRePTagBOOLEAN()
	{
		super("BOOLEAN");
	}

	public void compile(Session session)
	{
		TagList tagList = session.getTagList();

		PRePTagCount prepTagCount = (PRePTagCount)tagList.find("ARG0");

		if ( prepTagCount != null )
		{
			int iArgs = prepTagCount.getIntValue();

			if ( iArgs >= 5 )
			{
				compileSeparated(session);
			}
			else if ( iArgs == 3 )
			{
				compileCompare(session);
			}
			else
			{
				session.getExceptionList().addElement(new PRePException(this, "'arguments missing'"));
			}

		}
		else
		{
			session.getExceptionList().addElement(new PRePException(this, "'no arguments'"));
		}
	}

	public void compileSeparated(Session session)
	{
		TagList tagList = session.getTagList();
		PRePTag prepTagFirstArg = tagList.find("ARG1");
		PRePTag prepTagSign = tagList.find("ARG2");
		PRePTag prepTagSecondArg = tagList.find("ARG3");

		PRePTag prepTagOutTrue = tagList.find("ARG4");
		prepTagOutTrue = tagList.find(prepTagOutTrue.getValue());

		if ( prepTagOutTrue != null )
		{
			PRePTag prepTagOutFalse = tagList.find("ARG5");

			if ( prepTagOutFalse != null )
			{

				prepTagOutFalse = tagList.find(prepTagOutFalse.getValue());

				try
				{
					Float floatFirstArg = new Float(prepTagFirstArg.getValue());
					Float floatSecondArg = new Float(prepTagSecondArg.getValue());
					char chSign = prepTagSign.getValue().charAt(0);

					switch ( chSign )
					{
						case '<':

							if ( floatFirstArg.floatValue() < floatSecondArg.floatValue() )
							{
								prepTagOutTrue.compile(session);
							}
							else
							{
								prepTagOutFalse.compile(session);
							}

							break;

						case '=':

							if ( floatFirstArg.floatValue() == floatSecondArg.floatValue() )
							{
								prepTagOutTrue.compile(session);
							}
							else
							{
								prepTagOutFalse.compile(session);
							}

							break;

						case '>':

							if ( floatFirstArg.floatValue() > floatSecondArg.floatValue() )
							{
								prepTagOutTrue.compile(session);
							}
							else
							{
								prepTagOutFalse.compile(session);
							}

							break;

					}

				}
				catch ( Exception e )
				{
					compileString(session, prepTagFirstArg.getValue(), prepTagSecondArg.getValue(), prepTagSign, prepTagOutTrue, prepTagOutFalse);
				}
			}
		}
		else
		{
			session.getExceptionList().addElement(new PRePException(this, "'arguments missing'"));
		}
	}

	public void compileString(Session session, String strFirst, String strSecond, PRePTag prepTagSign, PRePTag prepTagTrue, PRePTag prepTagFalse)
	{
		char chSign = prepTagSign.getValue().charAt(0);
		boolean booCompare = false;

		switch ( chSign )
		{
		case '<':		    
				if ( strFirst.compareTo(strSecond) < 0 )
				{
					booCompare = true;
				}
				break;
			case '=':
				if ( strFirst.compareTo(strSecond) == 0 )
				{
					booCompare = true;
				}
				break;
			case '>':
				if ( strFirst.compareTo(strSecond) > 0 )
				{
					booCompare = true;
				}
				break;
			default:
				booCompare = false;
		}

		if ( booCompare )
		{
			prepTagTrue.compile(session);
		}
		else
		{
			prepTagFalse.compile(session);
		}
	}

	//not yet implemented!!!
	public void compileCompare(Session session)
	{
		TagList tagList = session.getTagList();
		PRePTag prepTagCompare = tagList.find("ARG1");
		PRePTag prepTagOutTrue = tagList.find("ARG2");
		prepTagOutTrue = tagList.find(prepTagOutTrue.getValue());

		PRePTag prepTagOutFalse = tagList.find("ARG3");

		if ( prepTagOutTrue != null )
		{
			prepTagOutFalse = tagList.find(prepTagOutFalse.getValue());
		}
	}

}
