/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Version 1.0
 *
 * PRePTagText: a tag which has a name and a value and compiles
 *              by printing the value with the PrintWriter
 *
 *              if the noparse flag is set (like: *MAIN:noparse)
 *              then the tag is just print the way it looks (without
 *              any formats or substitutes)
 *
 * History: - Creation nh
 *
 * @author nh
 * @version 1.0
 * @see PRePMain, TagList, PRePTag, PRePTagCode
 */
package com.delec.prep;
import java.util.*;
import java.io.*;

public class PRePTagText extends PRePTag
{
	/**
	 * value of the tag
	 */
	String value;
	/**
	 * checks whether the noparse flag is set or not
	 */
	boolean bParse = true;

	/**
	 * looks if the tag has a noparse flag set
	 * @param String tag name
	 */
	public PRePTagText(String sTagName)
	{
		super(sTagName);

		if ( sTagName.indexOf(':') != -1 )
		{
			int iIndex = sTagName.indexOf(':');
			String strSubstring = sTagName.substring(iIndex+1).trim();

			if ( strSubstring.equals("noparse") )
			{
				bParse = false;
			}

			this.sTagName = sTagName.substring(0, iIndex);
		}
	}

	/** convenience constructor, takes a name and a value and constructs the f#$%^ object. other people
		use (new PRePTagText(name)).setValue(value) or so throught their whole code. This is not really funny, is it?
		
		@param String tag Name
		@param String tag Value

	**/
	public PRePTagText(String strTagName, String strTagValue)
	{
		this(strTagName);
		setValue(strTagValue);
	}

	/**
	 * sets the value of the tag
	 * @param String the value to set
	 */
	public void setValue(String value)
	{
		this.value = value;
	}

	/**
	 * gets one line of the value of the tag
	 * @return the value of the tag
	 */
	public String getValue()
	{
		String value = this.value;

		if ( this.value != null )
		{
			if ( this.value.indexOf('\n') != -1 )
			{
				value = this.value.substring(0, this.value.indexOf('\n'));
			}
			if ( this.value.indexOf('\r') != -1 )
			{
				value = this.value.substring(0, this.value.indexOf('\r'));
			}
		}
		return(value);
	}

	/**
	 * gets the whole value of the tag
	 * @return the whole value of the tag
	 */
	public String getAllValue()
	{
		return value;
	}


	/**
	 * @param Session contains the TagList and the PrintWriter
	 */
	public void compile(Session session) 
	{
		String strSubstring = "";
		String strArg = "";
		PRePTagCount pCount = new PRePTagCount();
		Vector vArgs = new Vector();
		int counter = 0;
		int iState = 1;
		int iCount = 0;
		char chIndex;
		PrintWriter pWriter = session.getPrintWriter();
		TagList tagList = session.getTagList();

		char[] chArrValue = value.toCharArray();

		if ( bParse )
		{
			for ( int i = 0; i < chArrValue.length; i++ )
			{
				chIndex = chArrValue[i];

				switch ( iState )
				{
				    case 1:
					//System.out.println("case 1: "+chIndex);

						switch ( chIndex )
						{
							case '{':
								iState = 2;
								strSubstring = "";
								break;

							default:
								iState = 1;
								pWriter.write(chIndex);
//		    pWriter.flush();
								break;
						}
						break;

					case 2:					
					//System.out.println("case 2: "+chIndex);
						switch ( chIndex )
						{
							case '{':
								iState = 3;
								pWriter.print(chIndex);
								pWriter.flush();
								break;

							case '}':
								iState = 1;
								break;

							default:
								iState = 4;
								strSubstring = strSubstring+chIndex;
								break;
						}     
						break;

				    case 3:
					//System.out.println("case 3: "+chIndex);
						switch ( chIndex )
						{
							case '{':
								iState = 2;
								break;

							case '}':
								iState = 1;
								break;

							default:
								iState = 1;
								pWriter.print(chIndex);
								pWriter.flush();
								break;
						}
						break;

				    case 4:
					//System.out.println("case 4: "+chIndex);
						switch ( chIndex )
						{
							case '}':
								iState = 1;
								tagList.compile(strSubstring, session);
								strSubstring = "";
								break;

							case ':':
								iState = 5;
								break;

							default:
								iState = 4;
								strSubstring = strSubstring+chIndex;
								break;
						}
						break;

				    case 5:
				//	System.out.println("case 5: "+chIndex);
						switch ( chIndex )
						{
						   
							case ':':
								iState = 6;
								iCount = 1;
								strArg = "";
								break;

							default:
								strSubstring = strSubstring+":"+chIndex;
								iState = 4;
								break;
						}
						break;

				case 6:
					//System.out.println("case 6: "+chIndex);
						switch ( chIndex )
						{
							case '{':
								iState = 7;
								strArg = strArg+"{";
								counter++;
								break;

							case ':':
								iState = 8;
								break;

							case '}':
								iState = 1;
								PRePTagArg pTemp = new PRePTagArg("ARG"+iCount, strArg, session);
								vArgs.addElement(pTemp);
								strArg = "";
								iCount++;
								int iSize = tagList.size();
								pCount.setCount(iCount);

								for ( int j = 0; j < vArgs.size(); j++ )
								{
									tagList.addElement(vArgs.elementAt(j));
								}

								tagList.addElement(pCount);
								tagList.compile(strSubstring, session);
								tagList.setSize(iSize);
								vArgs.setSize(0);
								break;      

							default:
								iState = 6;
								strArg = strArg + chIndex;
								break;
						}
						break;

				    case 7:
				       // System.out.println("case 7: "+chIndex);

						switch ( chIndex )
						{
							case '}':
								counter--;
								if ( counter == 0 )
								{
									iState = 6;       
									strArg = strArg+chIndex;
								}
								else
								{
									iState = 7;
									strArg = strArg+chIndex;
									//counter--;
								}
								break;

							case '{':
								iState = 7;
								strArg = strArg+chIndex;
								counter++;
								break;

							default:
								iState = 7;
								strArg = strArg+chIndex;
								break;
						}
						break;

				    case 8:
					//System.out.println("case 8: "+chIndex);

						switch ( chIndex )
						{
							case ':':
								iState = 6;
								PRePTagArg pTemp = new PRePTagArg("ARG"+iCount, strArg, session);
								vArgs.addElement(pTemp);
								iCount++;
								pCount.setCount(iCount);
								strArg = "";
								break;

							case '}':
								iState = 1;
								PRePTagArg pTemp2 = new PRePTagArg("ARG"+iCount, strArg, session);  
								vArgs.addElement(pTemp2);
								iCount++;
								int iSize = tagList.size();
								pCount.setCount(iCount);

								for ( int j = 0; j < vArgs.size(); j++ )
								{
									tagList.addElement(vArgs.elementAt(j));
								}
								tagList.addElement(pCount);
								tagList.compile(strSubstring, session);
								tagList.setSize(iSize);
								vArgs.setSize(0);
								break;

						        case '{':
								iState = 7;
								strArg = strArg+":"+"{";
								counter++;
								break;

							default:
								iState = 6;
								strArg = strArg+':'+chIndex;
								break;
						}
						break;
				}  
			}
		}
		else
		{
			pWriter.println(value);
			pWriter.flush();
		}
		pWriter.flush();
	}

	public String debugOutput()
	{
		return super.debugOutput()+value;
	}

}






