/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Polygon;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCArrowButton;
import jclass.bwt.JCContainer;
import jclass.bwt.JCTabButton;
import jclass.bwt.TabPanel;

public class TabArrowPanel
extends JCContainer
implements JCActionListener {
    TabPanel tab_panel;
    JCArrowButton left_arrow;
    JCArrowButton right_arrow;
    static final int ARROW_SIZE = 15;
    static final int WIDTH = 37;
    private static final String base = "tabarrowpanel";
    private static int nameCounter;

    public TabArrowPanel(TabPanel tabPanel) {
        this.setName(base + nameCounter++);
        this.tab_panel = tabPanel;
        this.setLayout(null);
        this.left_arrow = new JCArrowButton(0);
        this.add(this.left_arrow);
        this.left_arrow.addActionListener(this);
        this.right_arrow = new JCArrowButton(2);
        this.add(this.right_arrow);
        this.right_arrow.addActionListener(this);
        this.right_arrow.initial_delay = 250;
        this.left_arrow.initial_delay = 250;
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    public void fillBackground(Graphics graphics) {
        if (!this.coversTabs()) {
            super.fillBackground(graphics);
            return;
        }
        TabArrowPanel tabArrowPanel = this;
        synchronized (tabArrowPanel) {
            Polygon polygon = new Polygon();
            int n = this.size().width;
            int n2 = this.size().height;
            int n3 = 1;
            int n4 = 0;
            int n5 = 2;
            while (n5 < n2) {
                polygon.addPoint(n4, n5);
                if (n4 == n3) {
                    n4 = n3 - 1;
                } else if (n4 == n3 - 1) {
                    n4 = n3 + 1;
                } else if (n4 == n3 + 1) {
                    n4 = n3;
                }
                n5 += 3;
            }
            polygon.addPoint(0, n2);
            polygon.addPoint(n, n2);
            polygon.addPoint(n, 0);
            graphics.fillPolygon(polygon);
            graphics.setColor(BWTUtil.brighter(this.getBackground()));
            int n6 = 1;
            while (n6 < polygon.npoints - 2) {
                graphics.drawLine(polygon.xpoints[n6 - 1], polygon.ypoints[n6 - 1], polygon.xpoints[n6], polygon.ypoints[n6]);
                ++n6;
            }
            return;
        }
    }

    synchronized boolean coversTabs() {
        if (this.tab_panel.countTabs() == 0) {
            return false;
        }
        Component[] componentArray = this.tab_panel.getComponents();
        Component component = null;
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JCTabButton) {
                component = componentArray[n];
            }
            ++n;
        }
        if (component == null) {
            return false;
        }
        return component.bounds().x + component.bounds().width >= this.bounds().x;
    }

    public void layout() {
        int n = this.tab_panel.size().height;
        int n2 = this.tab_panel.tab_manager.getTabSide();
        int n3 = n2 == 5 ? 0 : n - 15;
        this.reshape(this.tab_panel.size().width - 37, 0, 37, n);
        this.left_arrow.reshape(7, n3, 15, 15);
        this.right_arrow.reshape(22, n3, 15, 15);
        int n4 = this.tab_panel.tab_manager.getFirstVisibleTab();
        this.left_arrow.enable(n4 > 0);
        this.right_arrow.enable(this.coversTabs());
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        boolean bl = this.coversTabs();
        int n = this.tab_panel.tab_manager.getFirstVisibleTab();
        if (jCActionEvent.getSource() == this.left_arrow) {
            this.tab_panel.tab_manager.setFirstVisibleTab(--n);
        } else if (jCActionEvent.getSource() == this.right_arrow) {
            this.tab_panel.tab_manager.setFirstVisibleTab(++n);
        }
        this.tab_panel.tab_manager.page_area.drawBorder(this.tab_panel.tab_manager.page_area.getGraphics());
        if (bl != this.coversTabs()) {
            this.repaint();
        }
    }
}

