/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import jclass.chart.ChartText;
import jclass.chart.DerivedInt;
import jclass.chart.Extents;
import jclass.chart.HTMLHandler;
import jclass.chart.HTMLSaveDriver;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;
import jclass.chart.JCChartBundle;
import jclass.util.JCUtilConverter;

public class JCAxisTitle
extends ChartText
implements HTMLHandler {
    public static final String[] anchor_strings = new String[]{"Northeast", "North", "Northwest", "East", "West", "Southeast", "South", "Southwest"};
    public static final int[] anchor_values = new int[]{17, 16, 18, 1, 2, 33, 32, 34};
    DerivedInt placement = new DerivedInt(16, true);

    public JCAxisTitle() {
        this.isShowing = false;
    }

    public JCAxisTitle(String string) {
        this.setText(string, false);
    }

    public JCAxisTitle(String string, boolean bl) {
        this.setText(string, bl);
    }

    void setParentAxis(JCAxis jCAxis) {
        super.setParentAxis(jCAxis);
        this.fixPlacement(jCAxis);
    }

    public void setText(String string, boolean bl, boolean bl2) {
        super.setText(string, bl, bl2);
        if (this.getWidth() == 0) {
            this.setChanged(true, 2);
        }
    }

    public void setPlacement(int n) {
        JCAxisTitle jCAxisTitle = this;
        synchronized (jCAxisTitle) {
            if (n == this.placement.value) {
                Object var3_3 = null;
                return;
            }
            switch (n) {
                case 1: 
                case 2: 
                case 17: 
                case 18: 
                case 33: 
                case 34: {
                    if (this.parentAxis != null && !this.parentAxis.isVertical) {
                        throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key67"));
                    }
                    this.placement.value = n;
                    this.placement.isDefault = false;
                    break;
                }
                case 16: 
                case 32: {
                    if (this.parentAxis != null && this.parentAxis.isVertical) {
                        throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key68"));
                    }
                    this.placement.value = n;
                    this.placement.isDefault = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key69"));
                }
            }
        }
        this.setChanged(true, 2);
    }

    public int getPlacement() {
        return this.placement.value;
    }

    public void setPlacementIsDefault(boolean bl) {
        if (this.placement.isDefault == bl) {
            return;
        }
        this.placement.isDefault = bl;
        this.setChanged(true, 2);
    }

    public boolean getPlacementIsDefault() {
        return this.placement.isDefault;
    }

    /*
     * Enabled aggressive block sorting
     */
    void fixPlacement(JCAxis jCAxis) {
        if (jCAxis == null) {
            return;
        }
        if (this.placement.isDefault) {
            this.placement.value = !this.parentAxis.isVertical && this.rotation != 0 ? jCAxis.getAnnotationAnchor() : (this.parentAxis.otherAxis != null && this.parentAxis.otherAxis.getAnnotationAnchor() == 16 ? (this.parentAxis.getAnnotationAnchor() == 1 ? 33 : 34) : (this.parentAxis.getAnnotationAnchor() == 1 ? 17 : 18));
        }
        if (jCAxis.isVertical) {
            switch (this.placement.value) {
                default: {
                    this.placement.value = jCAxis.getAnnotationAnchor();
                    return;
                }
                case 1: 
                case 2: 
                case 17: 
                case 18: 
                case 33: 
                case 34: 
            }
            return;
        }
        switch (this.placement.value) {
            default: {
                this.placement.value = jCAxis.getAnnotationAnchor();
                return;
            }
            case 16: 
            case 32: 
        }
    }

    void layout() {
        if (this.isShowing) {
            if (this.parentAxis.isVertical) {
                int n = this.parentAxis.getTop() + (this.parentAxis.getHeight() - this.getHeight()) / 2;
                int n2 = this.parentAxis.getLeft();
                int n3 = this.parentAxis.getLeft() + this.parentAxis.getWidth() - this.getWidth();
                Extents extents = this.parentAxis.getExtents();
                switch (this.placement.value) {
                    case 18: {
                        this.move(n2, this.parentAxis.getTop() - extents.minor);
                        return;
                    }
                    case 2: {
                        this.move(n2, n);
                        return;
                    }
                    case 34: {
                        this.move(n2, this.parentAxis.getTop() + this.parentAxis.getHeight() + extents.major - this.getHeight() - 1);
                        return;
                    }
                    case 17: {
                        this.move(n3, this.parentAxis.getTop() - extents.minor);
                        return;
                    }
                    case 1: {
                        this.move(n3, n);
                        return;
                    }
                    case 33: {
                        this.move(n3, this.parentAxis.getTop() + this.parentAxis.getHeight() + extents.major - this.getHeight() - 1);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            int n = this.parentAxis.getLeft() + (this.parentAxis.getWidth() - this.getWidth()) / 2;
            switch (this.placement.value) {
                case 16: {
                    this.move(n, this.parentAxis.getTop());
                    return;
                }
                case 32: {
                    this.move(n, this.parentAxis.getTop() + this.parentAxis.getHeight() - this.getHeight());
                    return;
                }
            }
        }
    }

    public void saveParams(String string, HTMLSaveDriver hTMLSaveDriver) {
        super.saveParams(string, hTMLSaveDriver);
        if (!this.placement.isDefault) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".placement", JCUtilConverter.fromEnum(this.placement.value, anchor_strings, anchor_values));
        }
    }

    public void loadParams(String string, JCChart jCChart) {
        super.loadParams(string, jCChart);
        this.setPlacement(JCChart.getConverter().toEnum(jCChart.getParam(String.valueOf(string) + ".placement"), String.valueOf(string) + " title placement", anchor_strings, anchor_values, this.getPlacement()));
    }
}

