/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartDraw;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCLineStyle;
import jclass.chart.JCSymbolStyle;
import jclass.chart.MinMax;
import jclass.chart.PlotPoint;

class PlotChartDraw
extends ChartDraw {
    PlotPoint[][][] pts;
    Point[][] ptsIndex;
    boolean inStartEdit = false;
    MinMax xlim = new MinMax();
    MinMax ylim = new MinMax();
    Point prev;
    Point next;
    Point last;
    Rectangle r;

    public void recalc() {
        this.recalc(-1, -1, -1);
    }

    public void recalc(int n, int n2) {
        this.recalc(n, n2, -1);
    }

    public void recalc(int n, int n2, int n3) {
        boolean bl;
        super.recalc();
        this.fastUpdate = this.dataObject.getFastUpdate();
        if (this.fastUpdate) {
            bl = true;
            this.cachePlotData = true;
        } else {
            bl = this.inStartEdit;
            this.cachePlotData = this.dataObject.getBufferPlotData();
        }
        boolean bl2 = false;
        if (n >= 0 && n2 >= 0 && n2 >= n && this.pts != null) {
            bl2 = true;
        }
        if (n3 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.xaxis = this.dataObject.xaxis;
        this.yaxis = this.dataObject.yaxis;
        this.inverted = this.xaxis.isVertical;
        if (!bl && !this.cachePlotData && n3 == -1) {
            if (this.pts == null) {
                this.pts = new PlotPoint[this.seriesList.length][][];
            }
            return;
        }
        if (n3 == -1 || n3 == 0) {
            this.xlim = new MinMax();
            this.ylim = new MinMax();
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
        if (!bl2) {
            this.pts = new PlotPoint[this.seriesList.length][][];
            this.ptsIndex = bl ? new Point[this.seriesList.length][] : null;
        }
        int n4 = n3 == -1 ? 0 : n3;
        int n5 = n3 == -1 ? this.seriesList.length : n3 + 1;
        int n6 = n4;
        while (n6 < n5) {
            ChartDataViewSeries chartDataViewSeries = this.seriesList[n6];
            if (!bl2) {
                this.pts[n6] = null;
                if (bl) {
                    this.ptsIndex[n6] = null;
                }
            }
            if (chartDataViewSeries.maxXIndex() != 0 && chartDataViewSeries.maxYIndex() != 0) {
                Object object;
                int n7;
                if (!bl2) {
                    n = chartDataViewSeries.getFirstPoint();
                    n2 = chartDataViewSeries.getLastPoint();
                    n7 = Math.min(chartDataViewSeries.maxXIndex(), chartDataViewSeries.maxYIndex());
                    this.pts[n6] = new PlotPoint[n7][];
                    if (bl) {
                        this.ptsIndex[n6] = new Point[n7];
                    }
                } else {
                    n7 = n2 + 1;
                    PlotPoint[][] plotPointArray = this.pts[n6];
                    Point[] pointArray = this.ptsIndex[n6];
                    int n8 = plotPointArray == null ? 0 : plotPointArray.length;
                    this.pts[n6] = new PlotPoint[n7][];
                    this.ptsIndex[n6] = new Point[n7];
                    if (plotPointArray != null) {
                        System.arraycopy(plotPointArray, 0, this.pts[n6], 0, plotPointArray.length);
                    }
                    if (pointArray != null) {
                        System.arraycopy(pointArray, 0, this.ptsIndex[n6], 0, pointArray.length);
                    }
                    if (n < n8) {
                        n = n8;
                    }
                }
                this.holeValue = this.dataObject.holeValue;
                double d = 0.0;
                double d2 = this.holeValue;
                boolean bl3 = false;
                int n9 = 0;
                int n10 = 0;
                if (bl2 && n > 0) {
                    object = this.ptsIndex[n6][n - 1];
                    if (object == null) {
                        int n11 = n - 2;
                        while (object == null && n11 >= 0) {
                            object = this.ptsIndex[n6][n11];
                            --n11;
                        }
                        if (object != null) {
                            n9 = object.x + 1;
                        }
                        n10 = 0;
                    } else {
                        n9 = object.x;
                        n10 = object.y;
                        d = chartDataViewSeries.getX(this.pts[n6][n9][n10].point);
                        d2 = chartDataViewSeries.getY(this.pts[n6][n9][n10].point);
                        ++n10;
                        bl3 = true;
                    }
                }
                if (!bl2) {
                    this.pts[n6][n9] = new PlotPoint[n7 + 1];
                } else {
                    object = this.pts[n6][n9];
                    this.pts[n6][n9] = new PlotPoint[n7 + 1];
                    if (object != null) {
                        System.arraycopy(object, 0, this.pts[n6][n9], 0, ((PlotPoint[])object).length);
                    }
                }
                int n12 = n;
                while (n12 <= n2) {
                    double d3 = chartDataViewSeries.getX(n12);
                    double d4 = chartDataViewSeries.getY(n12);
                    bl3 = this.plotClip(d, d2, d3, d4, this.xlim, this.ylim, this.pts[n6][n9], n12, n10, 0, this.pts[n6][n9].length, bl3, this.inverted);
                    if (this.pts[n6][n9][n10] != null) {
                        if (bl) {
                            this.ptsIndex[n6][this.pts[n6][n9][n10].point] = new Point(n9, n10);
                        }
                        ++n10;
                    }
                    if (this.pts[n6][n9][n10] != null) {
                        if (bl) {
                            this.ptsIndex[n6][this.pts[n6][n9][n10].point] = new Point(n9, n10);
                        }
                        ++n10;
                    }
                    if (!bl3 && this.pts[n6][n9][0] != null) {
                        this.pts[n6][++n9] = new PlotPoint[n7];
                        this.pts[n6][n9][0] = new PlotPoint();
                        n10 = 0;
                    }
                    d = d3;
                    d2 = d4;
                    ++n12;
                }
            }
            ++n6;
        }
    }

    public void draw(Graphics graphics) {
        this.draw(graphics, -1, -1);
    }

    public void draw(Graphics graphics, int n, int n2) {
        try {
            if (this.seriesList == null) {
                return;
            }
            if (this.fastUpdate) {
                this.cachePlotData = true;
                if (this.ptsIndex == null) {
                    this.recalc(-1, -1, -1);
                }
            }
            boolean bl = false;
            if (n >= 0 && n2 >= 0 && n2 >= n) {
                bl = true;
            }
            if (this.pts == null) {
                return;
            }
            if (this.chartType == 0) {
                this.drawLinesOrPoints(graphics, true, bl, n, n2);
            }
            this.drawLinesOrPoints(graphics, false, bl, n, n2);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    private void drawLinesOrPoints(Graphics graphics, boolean bl, boolean bl2, int n, int n2) {
        int n3 = 0;
        while (n3 < this.pts.length) {
            block19: {
                int n4;
                Point point;
                Point point2;
                int n5;
                int n6;
                JCSymbolStyle jCSymbolStyle;
                JCLineStyle jCLineStyle;
                block20: {
                    JCChartStyle jCChartStyle;
                    if (!this.cachePlotData) {
                        this.recalc(-1, -1, n3);
                    }
                    if (this.pts[n3] == null) break block19;
                    ChartDataViewSeries chartDataViewSeries = this.seriesList[n3];
                    if (!chartDataViewSeries.isShowing || (jCChartStyle = chartDataViewSeries.getStyle()) == null) break block19;
                    jCLineStyle = jCChartStyle.getLineStyle();
                    jCSymbolStyle = jCChartStyle.getSymbolStyle();
                    if (!bl && jCSymbolStyle.getShape() == 0) break block19;
                    n6 = 0;
                    n5 = this.pts[n3].length;
                    point2 = null;
                    point = null;
                    if (!bl2) break block20;
                    if (this.chartType == 0 && n > 0) {
                        point2 = this.ptsIndex[n3][n - 1];
                    }
                    n4 = n;
                    while (point2 == null && n4 <= n2) {
                        point2 = this.ptsIndex[n3][n4];
                        ++n4;
                    }
                    int n7 = n2;
                    while (point == null && n7 >= n) {
                        point = this.ptsIndex[n3][n7];
                        --n7;
                    }
                    if (point2 == null || point == null) break block19;
                    n6 = point2.x;
                    n5 = point.x + 1;
                }
                n4 = n6;
                while (n4 < n5) {
                    if (this.pts[n3][n4] != null) {
                        Point point3 = null;
                        int n8 = 0;
                        int n9 = this.pts[n3][n4].length;
                        if (bl2) {
                            if (point2 != null && n4 == n6) {
                                n8 = point2.y;
                            }
                            if (point != null && n4 == n5 - 1) {
                                n9 = point.y + 1;
                            }
                        }
                        int n10 = n8;
                        while (n10 < n9) {
                            if (this.pts[n3][n4][n10] == null || this.pts[n3][n4][n10].px == Integer.MAX_VALUE || this.pts[n3][n4][n10].py == Integer.MAX_VALUE) {
                                point3 = null;
                            } else {
                                Point point4 = new Point(this.pts[n3][n4][n10].px, this.pts[n3][n4][n10].py);
                                if (bl && point3 != null && this.chartType == 0) {
                                    jCLineStyle.draw(graphics, point3.x, point3.y, point4.x, point4.y);
                                }
                                if (!bl && this.pts[n3][n4][n10].drawPoint) {
                                    jCSymbolStyle.draw(graphics, point4.x, point4.y);
                                }
                                point3 = point4;
                            }
                            ++n10;
                        }
                    }
                    ++n4;
                }
                if (!this.cachePlotData) {
                    this.pts[n3] = null;
                }
            }
            ++n3;
        }
    }

    JCDataIndex pick(Point point, int n) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        int n2 = -1;
        int n3 = -1;
        JCDataIndex jCDataIndex = null;
        int n4 = Integer.MAX_VALUE;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        if (this.fastUpdate) {
            this.cachePlotData = true;
        }
        int n5 = 0;
        while (n5 < this.pts.length) {
            if (!this.cachePlotData) {
                this.recalc(-1, -1, n5);
            }
            if (this.pts[n5] != null && this.seriesList[n5].isShowing) {
                int n6 = 0;
                while (n6 < this.pts[n5].length) {
                    if (this.pts[n5][n6] != null) {
                        int n7 = 0;
                        while (n7 < this.pts[n5][n6].length) {
                            if (this.pts[n5][n6][n7] != null && this.pts[n5][n6][n7].px != Integer.MAX_VALUE && this.pts[n5][n6][n7].py != Integer.MAX_VALUE && this.pts[n5][n6][n7].drawPoint) {
                                int n8 = Integer.MAX_VALUE;
                                switch (n) {
                                    case 1: {
                                        n8 = Math.abs(this.pts[n5][n6][n7].px - point2.x);
                                        break;
                                    }
                                    case 2: {
                                        n8 = Math.abs(this.pts[n5][n6][n7].py - point2.y);
                                        break;
                                    }
                                    default: {
                                        n8 = JCChartUtil.distance(point2.x, point2.y, this.pts[n5][n6][n7].px, this.pts[n5][n6][n7].py);
                                    }
                                }
                                if (n8 < n4) {
                                    n2 = n5;
                                    n3 = this.pts[n5][n6][n7].point;
                                    n4 = n8;
                                }
                            }
                            ++n7;
                        }
                    }
                    ++n6;
                }
                if (!this.cachePlotData) {
                    this.pts[n5] = null;
                }
            }
            ++n5;
        }
        if (n2 >= 0 && n3 >= 0) {
            jCDataIndex = new JCDataIndex(n3, this.seriesList[n2], n2);
            jCDataIndex.distance = n4;
        }
        return jCDataIndex;
    }

    Point unpick(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = this.seriesList[n2];
        double d = chartDataViewSeries.getY(n);
        double d2 = chartDataViewSeries.getX(n);
        int n3 = -1;
        int n4 = -1;
        if (d != this.holeValue && d2 != this.holeValue) {
            if (this.inverted) {
                n3 = this.yaxis.toPixel(d, this.drawFront);
                n4 = this.xaxis.toPixel(d2, this.drawFront);
            } else {
                n3 = this.xaxis.toPixel(d2, this.drawFront);
                n4 = this.yaxis.toPixel(d, this.drawFront);
            }
            return new Point(n3, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        boolean bl;
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        int n = jCDataIndex.series.drawingOrder;
        this.r = this.chartArea.getDrawingArea();
        this.last = null;
        this.next = null;
        this.prev = null;
        boolean bl2 = bl = this.ptsIndex == null;
        if (bl) {
            this.inStartEdit = true;
            this.recalc(-1, -1, n);
        }
        int n2 = this.ptsIndex[n][jCDataIndex.point].x;
        int n3 = this.ptsIndex[n][jCDataIndex.point].y;
        PlotPoint[] plotPointArray = this.pts[n][n2];
        if (n3 - 1 >= 0 && plotPointArray[n3 - 1] != null && plotPointArray[n3 - 1].px != Integer.MAX_VALUE && plotPointArray[n3 - 1].py != Integer.MAX_VALUE) {
            this.prev = new Point(plotPointArray[n3 - 1].px + this.r.x, plotPointArray[n3 - 1].py + this.r.y);
        }
        if (n3 + 1 < plotPointArray.length && plotPointArray[n3 + 1] != null && plotPointArray[n3 + 1].px != Integer.MAX_VALUE && plotPointArray[n3 + 1].py != Integer.MAX_VALUE) {
            this.next = new Point(plotPointArray[n3 + 1].px + this.r.x, plotPointArray[n3 + 1].py + this.r.y);
        }
        this.inStartEdit = false;
        if (bl) {
            this.ptsIndex = null;
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.xaxis.isVertical;
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        if (this.last == null) {
            this.last = bl ? new Point(n, jCDataIndex.dataView.xaxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.y) : new Point(jCDataIndex.dataView.xaxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.x, n2);
        } else if (bl) {
            this.last.x = n;
        } else {
            this.last.y = n2;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        if (jCDataIndex.dataView.xaxis.isVertical) {
            return n - this.r.x;
        }
        return n2 - this.r.y;
    }
}

