/*
 * Decompiled with CFR 0.152.
 */
package jclass.util;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Container;

public class JCEnvironment {
    static int NOVALUE;
    static int os;
    static int java_version;
    public static final int OS_OTHER = 0;
    public static final int OS_UNIX = 1;
    public static final int BROWSER_UNKNOWN;
    public static final int BROWSER_OTHER = 1;
    public static final int BROWSER_INTERPRETER = 1;
    public static final int BROWSER_APPLETVIEWER = 2;
    public static final int BROWSER_NETSCAPE = 3;
    public static final int BROWSER_EXPLORER = 4;
    public static final int BROWSER_VISUALAGE = 5;
    public static String versionString;
    public static String vendorString;
    public static final boolean JAVA_OS;

    public static Applet getApplet(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Applet) {
            return (Applet)component;
        }
        Container container = component.getParent();
        Container container2 = component.getParent();
        while (container2 != null && !(container2 instanceof Applet)) {
            container2 = container;
            container = container == null ? null : container.getParent();
        }
        return (Applet)container2;
    }

    public static AppletContext getAppletContext(Applet applet) {
        if (applet != null) {
            try {
                return applet.getAppletContext();
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static boolean inBrowser(Component component) {
        return JCEnvironment.getAppletContext(JCEnvironment.getApplet(component)) != null;
    }

    public static int getOS() {
        if (os != NOVALUE) {
            return os;
        }
        String string = System.getProperty("os.name");
        os = 0;
        if (string != null && (string.equalsIgnoreCase("SunOS") || string.equalsIgnoreCase("Solaris"))) {
            os = 1;
        }
        return os;
    }

    public static boolean isBrowserExplorer(Component component) {
        return JCEnvironment.getBrowser(component) == 4;
    }

    public static boolean isBrowserAppletViewer(Component component) {
        return JCEnvironment.getBrowser(component) == 2;
    }

    public static boolean isBrowserVisualAge(Component component) {
        return JCEnvironment.getBrowser(component) == 5;
    }

    public static boolean isVisualAge() {
        String string = JCEnvironment.getVendorString();
        return string.indexOf("IBM") != -1;
    }

    public static boolean isJBuilder() {
        String string = JCEnvironment.getVersionString();
        return string.indexOf("Borland") != -1;
    }

    public static synchronized int getBrowser(Component component) {
        if (component.getPeer() == null) {
            return BROWSER_UNKNOWN;
        }
        if (!JCEnvironment.inBrowser(component)) {
            return 1;
        }
        String string = System.getProperty("java.vendor");
        if (string.indexOf("Sun") != -1) {
            return 2;
        }
        if (string.indexOf("Netscape") != -1) {
            return 3;
        }
        if (string.indexOf("Microsoft") != -1) {
            return 4;
        }
        if (string.indexOf("IBM") != -1) {
            return 5;
        }
        return 1;
    }

    public static int getJavaVersion() {
        if (java_version != NOVALUE) {
            return java_version;
        }
        String string = JCEnvironment.getVersionString();
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isDigit(c)) {
                string2 = String.valueOf(string2) + c;
            }
            ++n;
        }
        try {
            java_version = Integer.parseInt(string2);
            if (java_version > 0 && java_version < 100) {
                java_version *= 10;
            }
        }
        catch (NumberFormatException numberFormatException) {
            java_version = NOVALUE;
        }
        return java_version;
    }

    public static String getVendorString() {
        block2: {
            if (vendorString != null) break block2;
            try {
                vendorString = System.getProperty("java.vendor");
            }
            catch (Exception exception) {
                vendorString = null;
            }
        }
        return vendorString;
    }

    public static String getVersionString() {
        block2: {
            if (versionString != null) break block2;
            try {
                versionString = System.getProperty("java.version");
            }
            catch (Exception exception) {
                versionString = null;
            }
        }
        return versionString;
    }

    public static boolean isJavaOS() {
        return JAVA_OS;
    }

    static {
        os = NOVALUE = -999;
        java_version = NOVALUE;
        BROWSER_UNKNOWN = NOVALUE;
        versionString = null;
        vendorString = null;
        JAVA_OS = System.getProperty("os.name").indexOf("JavaOS") > -1;
    }
}

