package cern.lhcias.csgui.Events;

import java.util.*;
/**
The AlarmEvent is an event used to send informations about any anormal situation 
detected in the RemoteView system. It will typically be sent by TagArrays when the
value of a Tag is outside limits or by DataServers when a connection with a remote server
is lost.
*/
public class AlarmEvent extends java.util.EventObject
{
    /** The text of the alarm.
    */
    public String text;
    /** The group of alarms to which this alarm belongs.
    */
    public String group;
    /** The priority of the alarm.
    */
    public int    priority;
    /** The date and time when the problem appeared.
    */
    public long   date;
    
    public AlarmEvent( Object sourceObject, String aString, String aGroup, long aDate) {
        super(sourceObject);
	text = aString;
	group = aGroup;
	date = aDate;
    }

    public void setText(String aString) {
	text = aString;
    }

    public void setGroup(String aGroup) {
	group = aGroup;
    }

    public void setDate(long aDate) {
	date = aDate;
    }
    
    public void setPriority(int aPriority) {
        priority = aPriority;
    }
}