package cern.lhcias.csgui.Services;

import cern.lhcias.csgui.interfaces.*;
import cern.lhcias.csgui.TagsView.*;
import cern.lhcias.csgui.Utils.*;
import cern.lhcias.csgui.MD2Ssupport.*;
import java.util.*;

/**
*   This class is a TagsView component loader. Given the name of the component,
*   it will automatically create an instance of the TagsView. So all the rest of
*   the interface doesn't need to know about the existing TagsViews.
*/
public class componentsType {
	static int nb_components = 8;
	static TagsView components[] = new TagsView[nb_components];
    static Vector aliases;

	/**
	* 	need to be called once at the setup of the system
	*/
	static public void setup() {
		components[0] = new Tagdisplay();
		components[1] = new JComptagView();
		components[2] = new CompoundView();
		components[3] = new BarGraphView();
		components[4] = new TextGraphView();
		components[5] = new Synoptic();
		components[6] = new ChartView();
		components[7] = new MD2SBean();
	}

    /** Load the list of aliases for TagsView names
    */
    static public void loadAlias(String aliasAddress) {
        try {
            aliases = MyUtils.ReadRemoteValueFile(aliasAddress);
        } catch (Exception  e) {}
    }

    /**
        Returns all the possible TagsView types as a Vector of Strings
    */
    static public Vector getPossibleTypes() {
        Vector types = new Vector();
        for (int i=0; i < nb_components; i++) {
            Vector stypes = components[i].getPossibleTypes();
            for (int j=0; j<stypes.size(); j++)
                types.addElement(stypes.elementAt(j));
        }
        return(types);
    }

    /** Checks wether a given type exists as a TagsView.
    * Returns true if type exists.
    * @param type the type to check
    */
    static public boolean isValidType(String type) {
        for (int i=0; i < nb_components; i++) {
			if (components[i].doYouImplement(type))
			    return true;
		}
	    return false;
	}

	/** Load a class named "name" and creates a new instance of it.
	*   The resulting object is returned. In case of error, a null is returned.
	*   @param name The name of the class to load
	*/
	static Object loadClass(String name) {

        Class c = null;
        try {
            c = Class.forName(name);
        }
        catch(ClassNotFoundException e) {
       	    System.out.println("UClass not found: " + e);
        }

        if (c != null) {
          try {
              return c.newInstance();
          } catch (Exception e) {
       	      System.out.println("FrameMain: error: " + e);
          }
    	}
    	return null;
    }

    /** Find the correct TagsView for a given type, create an instance
    * of this TagsView and returns it. In case of error, a null is returned.
    * If an alias list has been loaded it is used to access the correct component.
    * In case the type of the TagsView is unknown, we try to
	* locate a class which name is the type of the TagsView.
    * @param type the type of the TagsView
    */
	static public TagsView get_component(String type) {
        if (aliases != null) type = MyUtils.getAlias(type, aliases);
		for (int i=0; i<nb_components; i++)
			if (components[i].doYouImplement(type)) {
				switch (i) {
				case 0:
					Tagdisplay tg = new Tagdisplay();
                	tg.setProperty("","DISPLAY_TYPE",type);
					return(tg);
                case 1:
                    JComptagView ttg = new JComptagView();
                	ttg.setProperty("","DISPLAY_TYPE",type);
                    return(ttg);
                case 2:
                    CompoundView cv = new CompoundView();
                    return(cv);
                case 3:
                    BarGraphView bgv = new BarGraphView();
                    return(bgv);
                case 4:
                    TextGraphView tgv = new TextGraphView();
                    return(tgv);
                case 5:
                    Synoptic syn = new Synoptic();
                    return(syn);
                case 6:
                    ChartView chv = new ChartView();
                    return(chv);
                case 7:
                    MD2SBean mdb = new MD2SBean();
                    return(mdb);
				default:
				}
		}

		// We didn't find a predefined class which implements type.
		// So we are looking for a class named type.
		return((TagsView) loadClass(type));
	}
}
