/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.broker;

import java.util.Enumeration;
import java.util.Hashtable;
import org.webmacro.broker.ResourceEvent;
import org.webmacro.broker.ResourceListener;
import org.webmacro.broker.ResourceManager;
import org.webmacro.broker.ResourceMap;
import org.webmacro.broker.ResourceRevokedException;
import org.webmacro.broker.ResourceUnavailableException;
import org.webmacro.broker.TestConsumer;
import org.webmacro.broker.TestProvider;
import org.webmacro.util.InvalidArgumentException;
import org.webmacro.util.Log;

public final class ResourceBroker {
    public static final boolean ASYNCHRONOUS = true;
    public static final boolean SYNCHRONOUS = false;
    static final int REQUEST_ = 0;
    static final int CREATE_ = 1;
    static final int DELETE_ = 2;
    static final boolean debug_ = false;
    static final Log log_ = new Log("broker", "resource broker package");
    private static final long _DEFAULT_EXPIRE = 30000L;
    private final Hashtable _managers = new Hashtable();
    private boolean _shutdown = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized void join(ResourceListener resourceListener) {
        if (this._shutdown) {
            return;
        }
        try {
            resourceListener.init(this);
        }
        catch (Exception exception) {
            log_.exception(exception);
            log_.warning("Could not initialize listener: " + resourceListener);
            try {
                resourceListener.destroy();
                return;
            }
            catch (Exception exception2) {
            }
            return;
        }
        String[] stringArray = resourceListener.getTypes();
        int n = 0;
        while (n < stringArray.length) {
            ResourceManager resourceManager = (ResourceManager)this._managers.get(stringArray[n]);
            if (resourceManager == null) {
                resourceManager = new ResourceManager(this, stringArray[n]);
                this._managers.put(stringArray[n], resourceManager);
            }
            resourceManager.addListener(resourceListener);
            ++n;
        }
    }

    public final synchronized void leave(ResourceListener resourceListener) {
        String[] stringArray = resourceListener.getTypes();
        int n = 0;
        while (n < stringArray.length) {
            ResourceManager resourceManager = (ResourceManager)this._managers.get(stringArray[n]);
            if (resourceManager != null) {
                resourceManager.removeListener(resourceListener);
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object getValue(String string, String string2) throws ResourceUnavailableException {
        int n = 0;
        while (n < 100) {
            try {
                ResourceEvent resourceEvent = this.request(string, string2);
                return resourceEvent.getValue();
            }
            catch (ResourceRevokedException resourceRevokedException) {
                Thread.yield();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    throw new ResourceUnavailableException("Thread interrupted.");
                }
            }
            catch (InvalidArgumentException invalidArgumentException) {
                throw new ResourceUnavailableException("No provider for " + string);
            }
            ++n;
        }
        throw new ResourceUnavailableException("Resource locked by revoker.");
    }

    public final ResourceMap get(String string) throws InvalidArgumentException {
        ResourceManager resourceManager = (ResourceManager)this._managers.get(string);
        if (resourceManager == null || !resourceManager.isProvider()) {
            throw new InvalidArgumentException("No provider for " + string);
        }
        return resourceManager;
    }

    public final ResourceEvent request(String string, String string2) throws InvalidArgumentException, ResourceUnavailableException {
        return this.locate(string, string2, null, 0, true);
    }

    public final ResourceEvent request(String string, String string2, boolean bl) throws InvalidArgumentException, ResourceUnavailableException {
        return this.locate(string, string2, null, 0, true);
    }

    public final ResourceEvent delete(String string, String string2) throws InvalidArgumentException, ResourceUnavailableException {
        return this.locate(string, string2, null, 2, true);
    }

    public final ResourceEvent create(String string, String string2, Object object) throws InvalidArgumentException, ResourceUnavailableException {
        return this.locate(string, string2, object, 1, true);
    }

    public final ResourceEvent create(String string, String string2) throws InvalidArgumentException, ResourceUnavailableException {
        return this.locate(string, string2, null, 1, true);
    }

    public final void revoke(ResourceEvent resourceEvent) {
        ResourceManager resourceManager = (ResourceManager)this._managers.get(resourceEvent.getType());
        if (resourceManager == null) {
            log_.error("Attempt to revoke resource with no manager: " + resourceEvent);
            return;
        }
        resourceManager.revoke(resourceEvent, "Resource revoked by request");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void announce(ResourceEvent resourceEvent) {
        ResourceManager resourceManager = (ResourceManager)this._managers.get(resourceEvent.getType());
        try {
            resourceManager.announce(resourceEvent);
            return;
        }
        catch (NullPointerException nullPointerException) {
        }
    }

    public final boolean isProvider(String string) {
        ResourceManager resourceManager = (ResourceManager)this._managers.get(string);
        if (resourceManager == null) {
            return false;
        }
        return resourceManager.isProvider();
    }

    public final boolean isConsumer(String string) {
        ResourceManager resourceManager = (ResourceManager)this._managers.get(string);
        if (resourceManager == null) {
            return false;
        }
        return resourceManager.isConsumer();
    }

    public final void shutdown() {
        ResourceManager resourceManager;
        Enumeration enumeration = this;
        synchronized (enumeration) {
            this._shutdown = true;
        }
        enumeration = this._managers.elements();
        while (enumeration.hasMoreElements()) {
            resourceManager = (ResourceManager)enumeration.nextElement();
            resourceManager.shutdownResources();
        }
        Hashtable hashtable = new Hashtable();
        enumeration = this._managers.elements();
        while (enumeration.hasMoreElements()) {
            resourceManager = (ResourceManager)enumeration.nextElement();
            resourceManager.shutdownListeners(hashtable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ResourceEvent locate(String string, String string2, Object object, int n, boolean bl) throws InvalidArgumentException, ResourceUnavailableException {
        try {
            return ((ResourceManager)this._managers.get(string)).locate(string2, object, n, bl);
        }
        catch (NullPointerException nullPointerException) {
            throw new InvalidArgumentException("No such type: " + string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void blocked(ResourceEvent resourceEvent) throws ResourceUnavailableException {
        try {
            ((ResourceManager)this._managers.get(resourceEvent.getType())).blocked(resourceEvent);
            return;
        }
        catch (NullPointerException nullPointerException) {
            throw new ResourceUnavailableException("No provider for " + resourceEvent);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"type one"};
        String[] stringArray3 = new String[]{"type two"};
        String[] stringArray4 = new String[]{"type three", "type two"};
        System.out.println("MAIN: Creating new broker with 5sec expire time");
        ResourceBroker resourceBroker = new ResourceBroker();
        TestProvider testProvider = new TestProvider(stringArray2, "provider 1", "A");
        TestConsumer testConsumer = new TestConsumer(stringArray2);
        TestConsumer testConsumer2 = new TestConsumer(stringArray4);
        TestProvider testProvider2 = new TestProvider(stringArray3, "provider 2", "B");
        TestProvider testProvider3 = new TestProvider(stringArray4, "provider 3", "C");
        TestConsumer testConsumer3 = new TestConsumer(stringArray3);
        resourceBroker.join(testProvider);
        resourceBroker.join(testProvider2);
        resourceBroker.join(testProvider3);
        resourceBroker.join(testConsumer);
        resourceBroker.join(testConsumer2);
        resourceBroker.join(testConsumer3);
        try {
            System.out.println("MAIN: launching a lot of threads");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            resourceBroker.request("type one", "A");
            resourceBroker.request("type two", "C");
            System.out.println("MAIN1 Requesting type one/A:");
            ResourceEvent resourceEvent = resourceBroker.request("type one", "A");
            System.out.println("MAIN1 request gave: " + resourceEvent);
            System.out.println("MAIN2 Requesting type two/B:");
            ResourceEvent resourceEvent2 = resourceBroker.request("type two", "B");
            System.out.println("MAIN2 request gave: " + resourceEvent2);
            ResourceEvent resourceEvent3 = null;
            try {
                System.out.println("MAIN3: Requesting type four/B:");
                resourceEvent3 = resourceBroker.request("type four", "B");
                System.out.println("ERROR: should not have got here");
            }
            catch (InvalidArgumentException invalidArgumentException) {
                System.out.println("Got expected exception (no type four provider)");
            }
            System.out.println("MAIN4: Requesting type two/D:");
            ResourceEvent resourceEvent4 = resourceBroker.request("type two", "D");
            System.out.println("MAIN4 request gave: " + resourceEvent4);
            System.out.println("MAIN1: " + resourceEvent + " = " + resourceEvent.getValue());
            System.out.println("MAIN2: " + resourceEvent2 + " = " + resourceEvent2.getValue());
            try {
                System.out.println("MAIN4: " + resourceEvent4 + " = " + resourceEvent4.getValue());
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                System.out.println("Got expected excption: " + resourceEvent4 + " has no provider");
            }
            Thread.sleep(2500L);
            System.out.println("Touching " + resourceEvent);
            resourceEvent.update();
            Thread.sleep(2500L);
            System.out.println("Touching " + resourceEvent);
            resourceEvent.update();
            Thread.sleep(2500L);
            System.out.println("---SHUTDOWN---");
            resourceBroker.shutdown();
            System.out.println("---DONE---");
            return;
        }
        catch (Exception exception) {
            System.out.println("---UNEXPECTED EXCEPTION---");
            exception.printStackTrace();
        }
    }
}

