/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Hashtable;
import org.webmacro.engine.ParseException;

public final class ParseTool {
    public static final int TT_UNKNOWN = -99;
    public static final int TT_WORD = -3;
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final String lineSeparator;
    final Object[] asArg = new Object[]{this};
    public String sval = null;
    private int last = -99;
    private String _lastsval = null;
    private final StreamTokenizer _in;
    private final Hashtable _paramContext = new Hashtable();
    public int ttype = -99;
    private int _lineNum = 1;
    private final String _name;

    public final String getName() {
        return this._name;
    }

    public final String toString() {
        return this.getName() + ":" + this._lineNum;
    }

    static final String unique(String string) {
        return string.intern();
    }

    public final boolean parseToEOL() throws IOException {
        boolean bl = false;
        while (this.ttype != -1 && this.ttype != 10) {
            this.nextToken();
            bl = true;
        }
        return bl;
    }

    public final boolean parseEOL() throws IOException {
        return this.parseChar('\n');
    }

    public final boolean parseSpaces() throws IOException {
        boolean bl = false;
        while (this.ttype == 32 || this.ttype == 9) {
            bl = true;
            this.nextToken();
        }
        return bl;
    }

    public final boolean parseWhitespace() throws IOException {
        boolean bl = false;
        while (this.ttype == 32 || this.ttype == 10 || this.ttype == 9) {
            bl = true;
            this.nextToken();
        }
        return bl;
    }

    public final boolean parseChar(char c) throws IOException {
        if (this.ttype != c) {
            return false;
        }
        this.nextToken();
        return true;
    }

    public final String parseString() throws IOException {
        if (this.ttype != -3) {
            return null;
        }
        String string = this.sval;
        this.nextToken();
        return string;
    }

    public final boolean parseWord(String string) throws IOException {
        if (this.ttype != -3) {
            return false;
        }
        if (this.sval.equals(string)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    public final void pushBack() throws ParseException {
        if (this.last == -99) {
            throw new ParseException(this, "Attempt to undo too many times.");
        }
        this.ttype = this.last;
        this.last = -99;
        if (this.ttype == -3) {
            this.sval = this._lastsval;
        }
        this._in.pushBack();
    }

    public final int nextToken() throws IOException {
        this.last = this.ttype;
        if (this.last == -3) {
            this._lastsval = this.sval;
        }
        this.ttype = this._in.nextToken();
        if (this.ttype == 13) {
            this.ttype = lineSeparator == "\r" ? 10 : this._in.nextToken();
        }
        if (this.ttype == 10) {
            ++this._lineNum;
        }
        if (this.ttype == -3) {
            this.sval = ParseTool.unique(this._in.sval.intern());
        }
        return this.ttype;
    }

    public final int lineno() {
        return this._lineNum;
    }

    public final String parseLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(96);
        while (this.ttype != 10 && this.ttype != -1) {
            if (this.ttype == -3) {
                stringBuffer.append(this.sval);
            } else {
                stringBuffer.append((char)this.ttype);
            }
            this.nextToken();
        }
        if (this.ttype == 10) {
            stringBuffer.append((char)this.ttype);
            this.nextToken();
        }
        return stringBuffer.toString();
    }

    public final Hashtable getParamContext() {
        return this._paramContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void main(String[] stringArray) {
        try {
            System.out.println("Parsing the string $;@");
            ParseTool parseTool = new ParseTool("string", new StringReader("$;@"));
            System.out.println("1st token: " + (char)parseTool.nextToken());
            System.out.println("2nd token: " + (char)parseTool.nextToken());
            System.out.println("3rd token: " + (char)parseTool.nextToken());
            System.out.println("undo");
            parseTool.pushBack();
            System.out.println("Current  : " + (char)parseTool.ttype);
            System.out.println("Next tok : " + (char)parseTool.nextToken());
            System.out.println();
            System.out.println("Parsing stdin:");
            System.out.println();
            parseTool = new ParseTool("stdin", new InputStreamReader(System.in));
            while (true) {
                if (parseTool.nextToken() == -1) {
                    return;
                }
                if (parseTool.ttype == -3) {
                    System.out.println("Word: " + parseTool.sval);
                    continue;
                }
                if (parseTool.ttype == 10) {
                    System.out.println("LINEBREAK");
                    continue;
                }
                System.out.println("Token: " + (char)parseTool.ttype);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ParseTool(File file) throws IOException {
        this(file.getName(), new BufferedReader(new FileReader(file)));
    }

    public ParseTool(String string, Reader reader) {
        this._name = string;
        this._in = new StreamTokenizer(reader);
        this._in.resetSyntax();
        this._in.wordChars(0, 65535);
        this._in.ordinaryChar(39);
        this._in.ordinaryChar(34);
        this._in.ordinaryChar(92);
        this._in.ordinaryChar(32);
        this._in.ordinaryChar(10);
        this._in.ordinaryChar(9);
        this._in.ordinaryChar(13);
        this._in.ordinaryChar(35);
        this._in.ordinaryChar(36);
        this._in.ordinaryChar(123);
        this._in.ordinaryChar(125);
        this._in.ordinaryChar(40);
        this._in.ordinaryChar(41);
        this._in.ordinaryChar(59);
        this._in.ordinaryChar(61);
        this._in.ordinaryChar(46);
        this._in.ordinaryChar(33);
        this._in.ordinaryChar(37);
        this._in.ordinaryChar(38);
        this._in.ordinaryChar(42);
        this._in.ordinaryChar(43);
        this._in.ordinaryChar(44);
        this._in.ordinaryChar(47);
        this._in.ordinaryChar(58);
        this._in.ordinaryChar(60);
        this._in.ordinaryChar(62);
        this._in.ordinaryChar(63);
        this._in.ordinaryChar(64);
        this._in.ordinaryChar(91);
        this._in.ordinaryChar(93);
        this._in.ordinaryChar(94);
        this._in.ordinaryChar(124);
        this._in.ordinaryChar(126);
        this._in.ordinaryChar(13);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        String string;
        try {
            string = System.getProperty("line.separator").intern();
        }
        catch (Exception exception) {
            string = "\n".intern();
        }
        lineSeparator = string;
    }
}

