/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Value;

import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueNothing;
import X10Gimli.Value.ValueType;
import java.util.Calendar;

public class ValueOp
extends ValueType {
    private ValueType vcLeft;
    private String sOp;
    private ValueType vcRight;

    public ValueOp() {
        this.vcLeft = ValueNothing.value;
        this.vcRight = ValueNothing.value;
        this.sOp = "";
    }

    public ValueOp(ValueType left, String op, ValueType right) {
        this.vcLeft = left;
        this.sOp = op.toUpperCase();
        this.vcRight = right;
    }

    public void setLeft(ValueType left) {
        if (left != null) {
            this.vcLeft = left;
        }
        this.makeString();
    }

    public void setOp(String op) {
        if (op != null) {
            this.sOp = op.toUpperCase().intern();
        }
        this.makeString();
    }

    public void setRight(ValueType right) {
        if (right != null) {
            this.vcRight = right;
        }
        this.makeString();
    }

    public ValueType getLeft() {
        return this.vcLeft;
    }

    public String getOp() {
        return this.sOp;
    }

    public ValueType getRight() {
        return this.vcRight;
    }

    public Value getValue(EnvironmentSmall env) {
        Value v = this.vcLeft.getValue(env);
        return v.applyOperation(this.sOp, this.vcRight, env);
    }

    public Value applyArithmetic(String op, ValueType val, EnvironmentSmall env) {
        Value v = this.getValue(env);
        return v.applyArithmetic(op, val, env);
    }

    public Value applyCondition(String op, ValueType v2, EnvironmentSmall env) {
        Value v = this.getValue(env);
        return v.applyCondition(op, v2, env);
    }

    public int compareTo(ValueType val, EnvironmentSmall env) {
        Value v = this.getValue(env);
        return v.compareTo(val, env);
    }

    public Value applyLogic(String op, ValueType val, EnvironmentSmall env) {
        Value v = this.getValue(env);
        return v.applyLogic(op, val, env);
    }

    public Calendar resetTime(EnvironmentSmall env) {
        Calendar c2;
        Calendar c1 = this.vcLeft.resetTime(env);
        if (c1.before(c2 = this.vcRight.resetTime(env))) {
            return c2;
        }
        return c1;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(10);
        sbuf.append("(");
        sbuf.append(this.vcLeft.string);
        sbuf.append(" ");
        sbuf.append(this.sOp);
        sbuf.append(" ");
        sbuf.append(this.vcRight.string);
        sbuf.append(")");
        return sbuf.toString();
    }

    public String toX10GIMLI() {
        return this.toString();
    }
}

