/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Inflater;

public final class PngImageProducer
implements ImageProducer,
Runnable {
    Vector theConsumers = new Vector();
    URL url;
    boolean fetching;
    boolean fetched;
    boolean error;
    private static final ColorModel cm = ColorModel.getRGBdefault();
    int w;
    int h;
    int[] pix;
    static final int TRNS_COLOR_0 = 255;
    static final int TRNS_COLOR_2 = 0xFFFFFF;
    int colorType;
    int bitDepth;
    boolean paletUsed;
    boolean colorUsed;
    boolean alphaUsed;
    int[] palette;
    boolean trnsPresent = false;
    int trnsColor;
    private static final byte[] pngSignature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    int iw = -1;
    int ib;
    int ip;
    int lines;

    public PngImageProducer(URL uRL) {
        this.url = uRL;
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        PngImageProducer pngImageProducer = this;
        synchronized (pngImageProducer) {
            block11: {
                block10: {
                    if (!this.fetching) {
                        new Thread(this).start();
                        this.fetching = true;
                    }
                    if (imageConsumer == null) break block10;
                    if (!this.theConsumers.contains(imageConsumer)) break block11;
                }
                Object var3_3 = null;
                return;
            }
            this.theConsumers.addElement(imageConsumer);
            imageConsumer.setColorModel(cm);
            imageConsumer.setHints(26);
            if (this.pix != null) {
                imageConsumer.setDimensions(this.w, this.h);
                int n = 0;
                while (n < this.lines) {
                    imageConsumer.setPixels(0, n, this.w, 1, cm, this.pix, n * this.w, this.w);
                    ++n;
                }
            }
            if (this.fetched) {
                imageConsumer.imageComplete(this.error ? 1 : 3);
            }
            return;
        }
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.theConsumers.contains(imageConsumer);
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.theConsumers.removeElement(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public void run() {
        this.fetch();
    }

    private void fetch() {
        FilterInputStream filterInputStream = null;
        try {
            try {
                filterInputStream = new DataInputStream(new BufferedInputStream(this.url.openStream()));
                this.readSig((DataInputStream)filterInputStream);
                this.readHdr((DataInputStream)filterInputStream);
                this.readDat((DataInputStream)filterInputStream);
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(exception.toString()) + " " + this.url.toString());
                this.error = true;
            }
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
        catch (Exception exception) {}
        PngImageProducer pngImageProducer = this;
        synchronized (pngImageProducer) {
            this.fetched = true;
            Enumeration enumeration = this.theConsumers.elements();
            while (enumeration.hasMoreElements()) {
                ImageConsumer imageConsumer = (ImageConsumer)enumeration.nextElement();
                imageConsumer.imageComplete(this.error ? 1 : 3);
            }
            return;
        }
    }

    private void readSig(DataInputStream dataInputStream) throws Exception {
        byte[] byArray = new byte[8];
        dataInputStream.readFully(byArray);
        int n = 0;
        while (n < 8) {
            if (pngSignature[n] != byArray[n]) {
                throw new Exception("Bad png signature");
            }
            ++n;
        }
    }

    private void readHdr(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[4];
        dataInputStream.readFully(byArray);
        if (!new String(byArray).equals("IHDR")) {
            throw new Exception("png IHDR chunk expected");
        }
        if (n != 13) {
            throw new Exception("Bad png IHDR chunk length");
        }
        byte[] byArray2 = new byte[13];
        dataInputStream.readFully(byArray2);
        int n2 = dataInputStream.readInt();
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        cRC32.update(byArray2);
        if (n2 != (int)cRC32.getValue()) {
            throw new Exception("CRC error");
        }
        this.w = ((byArray2[0] & 0xFF) << 24) + ((byArray2[1] & 0xFF) << 16) + ((byArray2[2] & 0xFF) << 8) + (byArray2[3] & 0xFF);
        this.h = ((byArray2[4] & 0xFF) << 24) + ((byArray2[5] & 0xFF) << 16) + ((byArray2[6] & 0xFF) << 8) + (byArray2[7] & 0xFF);
        if (this.w <= 0 || this.h <= 0) {
            throw new Exception("Bad image size");
        }
        this.bitDepth = byArray2[8];
        this.colorType = byArray2[9];
        this.paletUsed = (this.colorType & 1) != 0;
        this.colorUsed = (this.colorType & 2) != 0;
        this.alphaUsed = (this.colorType & 4) != 0;
        int n3 = this.colorType;
        int n4 = this.bitDepth;
        if ((n3 != 0 || n4 != 1 && n4 != 2 && n4 != 4 && n4 != 8 && n4 != 16) && (n3 != 2 || n4 != 8 && n4 != 16) && (n3 != 3 || n4 != 1 && n4 != 2 && n4 != 4 && n4 != 8) && (n3 != 4 || n4 != 8 && n4 != 16) && (n3 != 6 || n4 != 8 && n4 != 16)) {
            throw new Exception("Unsupported png color type and bit depth combination");
        }
        if (byArray2[8] == 16) {
            throw new Exception("Unsupported png bit depth " + byArray2[8]);
        }
        if (byArray2[10] != 0) {
            throw new Exception("Unsupported png compression method " + byArray2[10]);
        }
        if (byArray2[11] != 0) {
            throw new Exception("Unsupported png filter method " + byArray2[11]);
        }
        if (byArray2[12] != 0) {
            throw new Exception("Unsupported png interlace method " + byArray2[12]);
        }
        PngImageProducer pngImageProducer = this;
        synchronized (pngImageProducer) {
            this.pix = new int[this.w * this.h];
            Enumeration enumeration = this.theConsumers.elements();
            while (enumeration.hasMoreElements()) {
                ImageConsumer imageConsumer = (ImageConsumer)enumeration.nextElement();
                imageConsumer.setDimensions(this.w, this.h);
            }
            return;
        }
    }

    private void readDat(DataInputStream dataInputStream) throws Exception {
        String string;
        CRC32 cRC32 = new CRC32();
        Inflater inflater = new Inflater();
        byte[] byArray = new byte[8192];
        do {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            if ((n5 = dataInputStream.readInt()) < 0) {
                throw new Exception("Bad png chunk length");
            }
            byte[] byArray2 = new byte[4];
            dataInputStream.readFully(byArray2);
            byte[] byArray3 = new byte[n5];
            dataInputStream.readFully(byArray3);
            int n6 = dataInputStream.readInt();
            cRC32.reset();
            cRC32.update(byArray2);
            int n7 = 0;
            while (n7 < n5) {
                cRC32.update(byArray3[n7]);
                ++n7;
            }
            if (n6 != (int)cRC32.getValue()) {
                throw new Exception("CRC error");
            }
            string = new String(byArray2);
            if (string.equals("PLTE")) {
                n4 = n5 / 3;
                if (n4 * 3 != n5 || n4 > 1 << this.bitDepth) {
                    throw new Exception("invalid PLTE chunk length");
                }
                this.palette = new int[n4];
                n3 = 0;
                n2 = 0;
                while (n3 < n4) {
                    n = byArray3[n2++] & 0xFF;
                    int n8 = byArray3[n2++] & 0xFF;
                    int n9 = byArray3[n2++] & 0xFF;
                    this.palette[n3] = 0xFF000000 | n << 16 | n8 << 8 | n9;
                    ++n3;
                }
            }
            if (string.equals("tRNS")) {
                this.trnsPresent = true;
                switch (this.colorType) {
                    case 0: {
                        if (n5 != 2) {
                            throw new Exception("invalid tRNS chunk length");
                        }
                        this.trnsColor = byArray3[1] & 0xFF;
                        break;
                    }
                    case 2: {
                        if (n5 != 6) {
                            throw new Exception("invalid tRNS chunk length");
                        }
                        n4 = byArray3[1] & 0xFF;
                        n3 = byArray3[3] & 0xFF;
                        n2 = byArray3[5] & 0xFF;
                        this.trnsColor = n4 << 16 | n3 << 8 | n2;
                        break;
                    }
                    case 3: {
                        if (this.palette == null) {
                            throw new Exception("PLTE chunk must present");
                        }
                        if (n5 > this.palette.length) {
                            throw new Exception("invalid tRNS chunk length");
                        }
                        n = 0;
                        while (n < n5) {
                            int n10 = n;
                            this.palette[n10] = this.palette[n10] & 0xFFFFFF;
                            int n11 = n;
                            this.palette[n11] = this.palette[n11] + ((byArray3[n] & 0xFF) << 24);
                            ++n;
                        }
                        break;
                    }
                }
            }
            if (!string.equals("IDAT")) continue;
            if (this.paletUsed && this.palette == null) {
                throw new Exception("PLTE chunk must present");
            }
            if (this.colorType == 0 && !this.trnsPresent) {
                this.trnsPresent = true;
                this.trnsColor = 255;
            }
            if (this.colorType == 2 && !this.trnsPresent) {
                this.trnsPresent = true;
                this.trnsColor = 0xFFFFFF;
            }
            if (!inflater.needsInput()) {
                throw new Exception("Extra png IDAT chunk");
            }
            inflater.setInput(byArray3);
            while ((n4 = inflater.inflate(byArray)) != 0) {
                this.acceptData(byArray, n4);
            }
        } while (!string.equals("IEND"));
        if (!inflater.finished()) {
            throw new Exception("Unexpected png IEND chunk");
        }
    }

    private void acceptData(byte[] byArray, int n) throws Exception {
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            if (this.iw == -1) {
                if (by != 0) {
                    throw new Exception("Unsupported png filter type");
                }
                ++this.iw;
            } else {
                int n3 = 8 / this.bitDepth;
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = (by & 0xFF) << this.bitDepth;
                    int n6 = n5 >>> 8;
                    switch (this.colorType) {
                        case 0: {
                            int n7;
                            if (this.trnsPresent && n6 == this.trnsColor) {
                                this.pix[this.ip] = 0xFFFFFF;
                            } else {
                                n7 = n6 * (255 / ((1 << this.bitDepth) - 1));
                                this.pix[this.ip] = 0xFF000000 | n7 << 16 | n7 << 8 | n7;
                            }
                            ++this.ip;
                            break;
                        }
                        case 2: {
                            int n8 = this.ip;
                            this.pix[n8] = this.pix[n8] << 8;
                            int n9 = this.ip;
                            this.pix[n9] = this.pix[n9] + n6;
                            if (this.ib++ != 2) break;
                            if (this.trnsPresent && this.pix[this.ip] == this.trnsColor) {
                                this.pix[this.ip] = 0xFFFFFF;
                            } else {
                                int n10 = this.ip;
                                this.pix[n10] = this.pix[n10] + -16777216;
                            }
                            ++this.ip;
                            this.ib = 0;
                            break;
                        }
                        case 3: {
                            this.pix[this.ip++] = this.palette[n6];
                            break;
                        }
                        case 4: {
                            int n7 = n6 * (255 / ((1 << this.bitDepth) - 1));
                            if (this.ib++ < 1) {
                                this.pix[this.ip] = n7 << 16 | n7 << 8 | n7;
                                break;
                            }
                            int n11 = this.ip++;
                            this.pix[n11] = this.pix[n11] + (n7 << 24);
                            this.ib = 0;
                            break;
                        }
                        case 6: {
                            if (this.ib++ < 3) {
                                int n12 = this.ip;
                                this.pix[n12] = this.pix[n12] << 8;
                                int n13 = this.ip;
                                this.pix[n13] = this.pix[n13] + n6;
                                break;
                            }
                            int n14 = this.ip++;
                            this.pix[n14] = this.pix[n14] + (n6 << 24);
                            this.ib = 0;
                        }
                    }
                    if (this.ib == 0 && ++this.iw == this.w) {
                        this.iw = -1;
                        PngImageProducer pngImageProducer = this;
                        synchronized (pngImageProducer) {
                            Enumeration enumeration = this.theConsumers.elements();
                            while (enumeration.hasMoreElements()) {
                                ImageConsumer imageConsumer = (ImageConsumer)enumeration.nextElement();
                                int n15 = this.lines;
                                imageConsumer.setPixels(0, n15, this.w, 1, cm, this.pix, n15 * this.w, this.w);
                            }
                            ++this.lines;
                            break;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void setLine(int n, ImageConsumer imageConsumer) {
        imageConsumer.setPixels(0, n, this.w, 1, cm, this.pix, n * this.w, this.w);
    }
}

