/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import photoorganizer.formats.AbstractInfo;
import photoorganizer.formats.MP3;
import photoorganizer.renderer.AppearanceOptionsTab;
import photoorganizer.renderer.ColumnDescriptor;
import rogatkin.Serializer;

public abstract class BaseConfigurableTableModel
extends AbstractTableModel {
    public static final Long ZERO = new Long(0L);
    protected ColumnDescriptor[] colsDescriptor;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$photoorganizer$formats$Rational;

    protected abstract int getDescriptionIndex();

    public void updateView(Serializer serializer) {
        this.colsDescriptor = AppearanceOptionsTab.readDescriptions(serializer)[this.getDescriptionIndex()];
    }

    protected Class getFirstColumnClass() {
        return null;
    }

    public int getColumnCount() {
        int n = this.colsDescriptor.length - 1;
        while (n >= 0) {
            if (this.colsDescriptor[n] != null) {
                return n + 1;
            }
            --n;
        }
        return 0;
    }

    public String getColumnName(int n) {
        return this.colsDescriptor[n].label;
    }

    public Class getColumnClass(int n) {
        Class clazz;
        if (n == 0 && (clazz = this.getFirstColumnClass()) != null) {
            return clazz;
        }
        switch (this.colsDescriptor[n].type) {
            case 0: {
                return class$java$lang$String == null ? (class$java$lang$String = BaseConfigurableTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
            case 1: {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = BaseConfigurableTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            case 2: {
                return class$java$lang$Number == null ? (class$java$lang$Number = BaseConfigurableTableModel.class$("java.lang.Number")) : class$java$lang$Number;
            }
            case 3: {
                return class$java$util$Date == null ? (class$java$util$Date = BaseConfigurableTableModel.class$("java.util.Date")) : class$java$util$Date;
            }
            case 4: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = BaseConfigurableTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case 5: {
                return class$java$lang$Float == null ? (class$java$lang$Float = BaseConfigurableTableModel.class$("java.lang.Float")) : class$java$lang$Float;
            }
            case 6: {
                return class$photoorganizer$formats$Rational == null ? (class$photoorganizer$formats$Rational = BaseConfigurableTableModel.class$("photoorganizer.formats.Rational")) : class$photoorganizer$formats$Rational;
            }
        }
        return class$java$lang$String == null ? (class$java$lang$String = BaseConfigurableTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    protected Object getValueAt(File file, AbstractInfo abstractInfo, int n) {
        ColumnDescriptor columnDescriptor = this.colsDescriptor[n];
        String[] stringArray = columnDescriptor.attributes;
        Object object = null;
        if (stringArray == null) {
            return object;
        }
        if (stringArray.length > 0 && abstractInfo != null) {
            object = this.getInfoAttribute(abstractInfo, stringArray[0], columnDescriptor.type);
            if (object != null) {
                return object;
            }
            if (stringArray.length > 1) {
                object = this.getInfoAttribute(abstractInfo, stringArray[1], columnDescriptor.type);
            }
            if (object != null) {
                return object;
            }
        }
        if (stringArray.length > 2) {
            if ("Name".equals(stringArray[2])) {
                object = file.getName();
            } else if ("Type".equals(stringArray[2])) {
                object = file.isDirectory() ? "Dir" : "File";
            } else if ("Length".equals(stringArray[2])) {
                object = file.isFile() ? new Long(file.length()) : ZERO;
            } else if ("Date".equals(stringArray[2])) {
                object = columnDescriptor.type == 3 ? new Date(file.lastModified()) : DateFormat.getDateInstance(3).format(new Date(file.lastModified()));
            } else if ("Attributes".equals(stringArray[2])) {
                object = "" + (file.isDirectory() ? "d" : ".") + (file.isFile() ? "f" : ".") + (file.isHidden() ? "h" : ".");
            }
        }
        return object;
    }

    protected Object getInfoAttribute(AbstractInfo abstractInfo, String string, int n) {
        Object object = null;
        try {
            switch (n) {
                case 0: 
                case 2: {
                    if ("Genre".equals(string)) {
                        try {
                            object = MP3.GENRES[abstractInfo.getIntAttribute(string)];
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    object = abstractInfo.getAttribute(string);
                    break;
                }
                case 1: {
                    object = abstractInfo.getBoolAttribute(string) ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 3: {
                    object = abstractInfo.getAttribute(string);
                    if (!(object instanceof Date)) break;
                    object = DateFormat.getDateInstance(3).format(object);
                    break;
                }
                case 4: {
                    object = new Integer(abstractInfo.getIntAttribute(string));
                    break;
                }
                case 5: {
                    object = new Float(abstractInfo.getFloatAttribute(string));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

