/*
 *   @(#) MPEG-I Video Decoder 1.0 Demicron (demicron@demicron.com)
 *
 *   AP_AudioDeviceBaseFactory.java   2002-08-20
 *
 *   Copyright (C) 2002  Demicron
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


/**
 * An <code>AP_AP_AudioDeviceFactory</code> class is responsible for creating
 * a specific <code>AP_AudioDevice</code> implementation. A factory implementation
 * can be as simple or complex as desired and may support just one implementation
 * or may return several implementations depending upon the execution
 * environment.
 * <p>
 * When implementing a factory that provides an AP_AudioDevice that uses
 * class that may not be present, the factory should dynamically link to any
 * specific implementation classes required to instantiate or test the audio
 * implementation. This is so that the application as a whole
 * can run without these classes being present. The audio
 * device implementation, however, will usually statically link to the classes
 * required. (See the JavaSound deivce and factory for an example
 * of this.)
 *
 * @see AP_FactoryRegistry
 *
 */
public abstract class AP_AudioDeviceFactory
{
	/**
	 * Creates a new <code>AP_AudioDevice</code>.
	 *
	 * @return	a new instance of a specific class of <code>AP_AudioDevice</code>.
	 * @throws	JavaLayerException if an instance of AP_AudioDevice could not
	 *			be created.
	 */
	public abstract AP_AudioDevice createAudioDevice() throws AD_JavaLayerException;

	/**
	 * Creates an instance of an AP_AudioDevice implementation.
	 * @param loader	The <code>ClassLoader</code> to use to
	 *					load the named class, or null to use the
	 *					system class loader.
	 * @param name		The name of the class to load.
	 * @return			A newly-created instance of the audio device class.
	 */
	protected AP_AudioDevice instantiate(ClassLoader loader, String name)
		throws ClassNotFoundException,
			   IllegalAccessException,
			   InstantiationException
	{
		AP_AudioDevice dev = null;

		Class cls = null;
		if (loader==null)
		{
			cls = Class.forName(name);
		}
		else
		{
			cls = loader.loadClass(name);
		}

		Object o = cls.newInstance();
		dev = (AP_AudioDevice)o;

		return dev;
	}
}
