/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm;

import com.sun.comm.Win32ParallelPort;
import com.sun.comm.Win32SerialPort;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.comm.CommDriver;
import javax.comm.CommPort;
import javax.comm.CommPortIdentifier;

public class Win32Driver
implements CommDriver {
    public void initialize() {
        Object object;
        try {
            System.loadLibrary("win32com");
        }
        catch (SecurityException securityException) {
            System.err.println("Security Exception win32com: " + securityException);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Error loading win32com: " + unsatisfiedLinkError);
            return;
        }
        Vector vector = new Vector();
        Win32Driver.readRegistrySerial(vector);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            CommPortIdentifier.addPortName((String)object, 1, this);
        }
        object = new Vector();
        Win32Driver.readRegistryParallel((Vector)object);
        Enumeration enumeration2 = ((Vector)object).elements();
        while (enumeration2.hasMoreElements()) {
            String string = (String)enumeration2.nextElement();
            CommPortIdentifier.addPortName(string, 2, this);
        }
    }

    public CommPort getCommPort(String string, int n) {
        CommPort commPort = null;
        try {
            switch (n) {
                case 1: {
                    commPort = new Win32SerialPort(string);
                    break;
                }
                case 2: {
                    commPort = new Win32ParallelPort(string);
                    break;
                }
                default: {
                    return commPort;
                }
            }
        }
        catch (IOException iOException) {}
        return commPort;
    }

    private static native int readRegistrySerial(Vector var0);

    private static native int readRegistryParallel(Vector var0);
}

