/*
 * Decompiled with CFR 0.152.
 */
package addressbook;

import addressbook.Address;
import addressbook.BaseAttrTableModel;
import addressbook.Chat;
import addressbook.Contact;
import addressbook.EMail;
import addressbook.GenericAttribute;
import addressbook.Link;
import addressbook.Name;
import addressbook.TabbedArrayOfComponents;
import addressbook.Telephone;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import rogatkin.BaseController;
import rogatkin.GranulatedLayout;
import rogatkin.LocalizedInputTextArea;
import rogatkin.LocalizedInputTextField;

public class ContactFrame
extends JFrame
implements ActionListener {
    JTable table;
    Contact contact;
    static final String EMAIL_PAT = "name@host.com";
    static final String PHONE_PAT = "1(222)436-9231";
    static final String NEW_PAT = "<new>";
    static final EMail NEW_EMAIL_ENTRY = new EMail("name@host.com", "<new>");
    static final Telephone NEW_PHONE_ENTRY = new Telephone("1(222)436-9231", "<new>");
    static final SimpleDateFormat DOB_FMT = new SimpleDateFormat("MM-dd-yyyy");
    JTextField tf_name;
    JTextField dob;
    JTextArea ta_cmnt;
    TabbedArrayOfComponents addrs;
    TabbedArrayOfComponents chats;
    TabbedArrayOfComponents webs;
    TabbedArrayOfComponents pgps;
    JTable tb_tphones;
    JTable tb_emails;

    ContactFrame(JTable jTable) {
        this(jTable, -1);
    }

    ContactFrame(JTable jTable, int n) {
        super("New Contact");
        this.table = jTable;
        if (n > -1) {
            this.contact = ((BaseAttrTableModel)this.table.getModel()).getValueAt(n);
            this.setTitle(this.contact.getName().toString());
        }
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        jTabbedPane.insertTab("General", null, new GeneralTab(), "Specify general contact information here", 0);
        jTabbedPane.insertTab("Details", null, new DetailsTab(), "Provide more details for a friend and/or partner", 1);
        jTabbedPane.insertTab("Chat&Web", null, new ChatWebTab(), "Add chat and web information", 2);
        jTabbedPane.insertTab("Certificates", null, new CertificatesTab(), "Add certificates for signing and encryption", 3);
        this.getContentPane().add((Component)jTabbedPane, "Center");
        this.getContentPane().add((Component)this.createButtons(this), "South");
        this.setIconImage(BaseController.getResourceIcon((String)"New.gif").getImage());
        this.pack();
        this.setVisible(true);
    }

    public JPanel createButtons(ActionListener actionListener) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton("OK");
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        jButton = new JButton("<html><i>Apply");
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        jButton = new JButton("Cancel");
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("OK".equals(string)) {
            if (this.updatePerson()) {
                this.dispose();
            }
        } else if ("Cancel".equals(string)) {
            this.dispose();
        } else if ("<html><i>Apply".equals(string)) {
            this.updatePerson();
        }
    }

    boolean updatePerson() {
        String string;
        Object object;
        Name name = null;
        try {
            name = new Name(this.tf_name.getText());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (name == null) {
            JOptionPane.showMessageDialog(this, "Name field can't be empty.", "Warning", 2);
            return false;
        }
        if (this.contact == null) {
            this.contact = new Contact();
            ((BaseAttrTableModel)this.table.getModel()).addValue(this.contact);
            this.contact.add(((GeneralTab.BaseAttrTableModel)this.tb_emails.getModel()).getActualElements());
            this.contact.add(((GeneralTab.BaseAttrTableModel)this.tb_tphones.getModel()).getActualElements());
        }
        this.contact.setValue(name);
        if (this.contact.getComments() != null) {
            this.contact.getComments().removeAllElements();
        }
        this.contact.add(this.ta_cmnt.getText());
        try {
            this.contact.setDOB(DOB_FMT.parse(this.dob.getText()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (this.contact.getAddresses() != null) {
            this.contact.getAddresses().removeAllElements();
        }
        int n = 0;
        while (n < this.addrs.getTabCount()) {
            String string2 = this.addrs.getTitleAt(n);
            object = new StringTokenizer(((JTextArea)this.addrs.getElement(string2)).getText(), "");
            string = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            try {
                string = ((StringTokenizer)object).nextToken("\n");
                string3 = ((StringTokenizer)object).nextToken(",\n");
                string4 = ((StringTokenizer)object).nextToken(" ,");
                string5 = ((StringTokenizer)object).nextToken(", ");
                string6 = ((StringTokenizer)object).nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.contact.add(new Address(string, string3, string4, string6, string5, string2, null));
            ++n;
        }
        if (this.contact.getChats() != null) {
            this.contact.getChats().removeAllElements();
        }
        int n2 = 0;
        while (n2 < this.chats.getTabCount()) {
            object = this.chats.getTitleAt(n2);
            this.contact.add(((ChatAttrs)this.chats.getElement((String)object)).getChat((String)object));
            ++n2;
        }
        if (this.contact.getLinks() != null) {
            this.contact.getLinks().removeAllElements();
        }
        int n3 = 0;
        while (n3 < this.webs.getTabCount()) {
            string = this.webs.getTitleAt(n3);
            this.contact.add(new Link(((JTextArea)this.webs.getElement(string)).getText(), string));
            ++n3;
        }
        this.table.revalidate();
        return true;
    }

    class CertificatesTab
    extends JPanel {
        CertificatesTab() {
            this.setLayout((LayoutManager)new GranulatedLayout(4, 10, 20, 4, 8, 8));
        }
    }

    class ChatAttrs
    extends JPanel {
        JTextField tf_chatId;
        JTextField tf_chatHost;
        JTextField tf_room;
        JComboBox sl_chatType;

        ChatAttrs() {
            this.setLayout((LayoutManager)new GranulatedLayout(3, 4, 20, 4, 8, 8));
            this.add((Component)new JLabel("Chat Id"), "0,0,1");
            this.tf_chatId = new JTextField();
            this.add((Component)this.tf_chatId, "1,0,2");
            this.add((Component)new JLabel("Host"), "0,1,1");
            this.tf_chatHost = new JTextField();
            this.add((Component)this.tf_chatHost, "1,1,2");
            this.add((Component)new JLabel("Type"), "0,2,1");
            this.sl_chatType = new JComboBox<String>(Chat.MNEMO);
            this.add(this.sl_chatType, "1,2,1");
            this.add((Component)new JLabel("Room"), "0,3,1");
            this.tf_room = new JTextField();
            this.add((Component)this.tf_room, "1,3,2");
        }

        Chat getChat(String string) {
            return new Chat(this.tf_chatId.getText(), this.tf_chatHost.getText(), this.sl_chatType.getSelectedIndex() + 1, string, this.tf_room.getText());
        }

        void setChat(Chat chat) {
            this.tf_chatId.setText(chat.getValue());
            this.tf_chatHost.setText(chat.getHost());
            this.tf_room.setText(chat.getRoom());
            this.sl_chatType.setSelectedIndex(chat.getType() - 1);
        }
    }

    class ChatWebTab
    extends JPanel {
        JTextField tf_name;
        JTextField tf_name1;

        ChatWebTab() {
            this.setLayout((LayoutManager)new GranulatedLayout(4, 10, 20, 4, 8, 8));
            this.add((Component)new JLabel("Chats"), "0,0,2");
            this.tf_name = new JTextField();
            this.add((Component)this.tf_name, "3,1");
            ContactFrame.this.chats = new TabbedArrayOfComponents(this, 3){
                private final /* synthetic */ ChatWebTab this$1;
                {
                    this.this$1 = chatWebTab;
                }

                JComponent produce() {
                    return ChatWebTab.access$100(this.this$1).new ChatAttrs();
                }
            };
            this.add((Component)ContactFrame.this.chats, "0,1,3,5");
            AttrActionHandler attrActionHandler = new AttrActionHandler(ContactFrame.this.chats, this.tf_name);
            JButton jButton = new JButton("Add");
            this.add((Component)jButton, "3,2,1");
            jButton.addActionListener(attrActionHandler);
            jButton = new JButton("Modify");
            this.add((Component)jButton, "3,3,1");
            jButton.addActionListener(attrActionHandler);
            jButton = new JButton("Delete");
            this.add((Component)jButton, "3,4,1");
            jButton.addActionListener(attrActionHandler);
            ContactFrame.this.webs = new TabbedArrayOfComponents(this, 3){
                private final /* synthetic */ ChatWebTab this$1;
                {
                    this.this$1 = chatWebTab;
                }

                JComponent produce() {
                    return new JTextArea();
                }
            };
            this.add((Component)ContactFrame.this.webs, "0,7,3,3");
            this.add((Component)new JLabel("Web pages"), "0,6,2");
            this.tf_name1 = new JTextField();
            this.add((Component)this.tf_name1, "3,6");
            attrActionHandler = new AttrActionHandler(ContactFrame.this.webs, this.tf_name1);
            jButton = new JButton("Add");
            this.add((Component)jButton, "3,7,1");
            jButton.addActionListener(attrActionHandler);
            jButton = new JButton("Modify");
            this.add((Component)jButton, "3,8,1");
            jButton.addActionListener(attrActionHandler);
            jButton = new JButton("Delete");
            this.add((Component)jButton, "3,9,1");
            jButton.addActionListener(attrActionHandler);
            if (ContactFrame.this.contact != null) {
                Vector vector = ContactFrame.this.contact.getChats();
                int n = 0;
                while (vector != null && n < vector.size()) {
                    Chat chat = (Chat)vector.elementAt(n);
                    ContactFrame.this.chats.addElement(chat.getShortDescription());
                    ((ChatAttrs)ContactFrame.this.chats.getElement(chat.getShortDescription())).setChat(chat);
                    ++n;
                }
                vector = ContactFrame.this.contact.getLinks();
                int n2 = 0;
                while (vector != null && n2 < vector.size()) {
                    Link link = (Link)vector.elementAt(n2);
                    ContactFrame.this.webs.addElement(link.getShortDescription());
                    ((JTextArea)ContactFrame.this.webs.getElement(link.getShortDescription())).setText(link.toString());
                    ++n2;
                }
            }
        }

        static /* synthetic */ ContactFrame access$100(ChatWebTab chatWebTab) {
            return chatWebTab.ContactFrame.this;
        }

        class AttrActionHandler
        implements ActionListener {
            TabbedArrayOfComponents ta;
            JTextField tf;

            AttrActionHandler(TabbedArrayOfComponents tabbedArrayOfComponents, JTextField jTextField) {
                this.ta = tabbedArrayOfComponents;
                this.tf = jTextField;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if ("Add".equals(string)) {
                    this.ta.addElement(this.tf.getText());
                    ChatWebTab.this.tf_name.setText("");
                } else if ("Modify".equals(string)) {
                    this.ta.modifyElement(this.tf.getText());
                    this.tf.setText("");
                } else if ("Delete".equals(string)) {
                    this.ta.deleteElement();
                }
            }
        }
    }

    class DetailsTab
    extends JPanel
    implements ActionListener {
        JTextField tf_name;

        DetailsTab() {
            this.setLayout((LayoutManager)new GranulatedLayout(4, 10, 20, 4, 8, 8));
            this.add((Component)new JLabel("Addresses"), "0,0,2");
            this.tf_name = new JTextField();
            this.add((Component)this.tf_name, "3,1");
            JButton jButton = new JButton("Add");
            this.add((Component)jButton, "3,2,1");
            jButton.addActionListener(this);
            jButton = new JButton("Modify");
            this.add((Component)jButton, "3,3,1");
            jButton.addActionListener(this);
            jButton = new JButton("Delete");
            this.add((Component)jButton, "3,4,1");
            jButton.addActionListener(this);
            ContactFrame.this.addrs = new TabbedArrayOfComponents(this, 3){
                private final /* synthetic */ DetailsTab this$1;
                {
                    this.this$1 = detailsTab;
                }

                JComponent produce() {
                    return new LocalizedInputTextArea();
                }
            };
            this.add((Component)ContactFrame.this.addrs, "0,1,3,4");
            this.add((Component)new JLabel("Photo"), "2,5,1");
            this.add((Component)new JLabel("DOB as MM-DD-YYYY"), "0,5,2");
            ContactFrame.this.dob = new JTextField();
            this.add((Component)ContactFrame.this.dob, "0,6,1");
            this.add((Component)new JLabel("Comment"), "0,9,1");
            ContactFrame.this.ta_cmnt = new LocalizedInputTextArea();
            this.add((Component)new JScrollPane(ContactFrame.this.ta_cmnt), "1,9,3,2");
            if (ContactFrame.this.contact != null) {
                Date date = ContactFrame.this.contact.getDOB();
                if (date != null) {
                    ContactFrame.this.dob.setText(DOB_FMT.format(date));
                }
                Vector vector = ContactFrame.this.contact.getComments();
                int n = 0;
                while (vector != null && n < vector.size()) {
                    ContactFrame.this.ta_cmnt.append(vector.elementAt(n).toString());
                    ++n;
                }
                vector = ContactFrame.this.contact.getAddresses();
                int n2 = 0;
                while (vector != null && n2 < vector.size()) {
                    Address address = (Address)vector.elementAt(n2);
                    ContactFrame.this.addrs.addElement(address.getShortDescription());
                    ((JTextArea)ContactFrame.this.addrs.getElement(address.getShortDescription())).setText(address.getFormated());
                    ++n2;
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("Add".equals(string)) {
                ContactFrame.this.addrs.addElement(this.tf_name.getText());
                this.tf_name.setText("");
            } else if ("Modify".equals(string)) {
                ContactFrame.this.addrs.modifyElement(this.tf_name.getText());
                this.tf_name.setText("");
            } else if ("Delete".equals(string)) {
                ContactFrame.this.addrs.deleteElement();
            }
        }
    }

    class GeneralTab
    extends JPanel {
        GeneralTab() {
            this.setLayout((LayoutManager)new GranulatedLayout(2, 10, 20, 4, 8, 8));
            this.add((Component)new JLabel("Name"), "0,0,1");
            ContactFrame.this.tf_name = new LocalizedInputTextField();
            this.add((Component)ContactFrame.this.tf_name, "0,1,2");
            ContactFrame.this.tb_emails = new JTable(new EmailsTableModel());
            RowRemover rowRemover = new RowRemover();
            ContactFrame.this.tb_emails.addKeyListener(rowRemover);
            this.add((Component)new JScrollPane(ContactFrame.this.tb_emails), "0,2,2,4,0,12");
            ContactFrame.this.tb_tphones = new JTable(new PnonesTableModel());
            rowRemover = new RowRemover();
            ContactFrame.this.tb_tphones.addKeyListener(rowRemover);
            this.add((Component)new JScrollPane(ContactFrame.this.tb_tphones), "0,6,2,4,0,12");
            if (ContactFrame.this.contact != null) {
                Name name = ContactFrame.this.contact.getName();
                ContactFrame.this.tf_name.setText(name.getFirst() + ' ' + name.getLast());
            }
        }

        class PnonesTableModel
        extends BaseAttrTableModel {
            PnonesTableModel() {
                this.init();
            }

            Vector getElements() {
                return ((GeneralTab)GeneralTab.this).ContactFrame.this.contact.getTelephones();
            }

            GenericAttribute createElement() {
                return new Telephone(ContactFrame.PHONE_PAT, ContactFrame.NEW_PAT);
            }

            GenericAttribute getPatternElement() {
                return NEW_PHONE_ENTRY;
            }

            String getTitle() {
                return "T-Phone";
            }

            String getNewValuePattern() {
                return ContactFrame.PHONE_PAT;
            }
        }

        class EmailsTableModel
        extends BaseAttrTableModel {
            EmailsTableModel() {
                this.init();
            }

            Vector getElements() {
                return ((GeneralTab)GeneralTab.this).ContactFrame.this.contact.getEMails();
            }

            GenericAttribute createElement() {
                return new EMail(ContactFrame.EMAIL_PAT, ContactFrame.NEW_PAT);
            }

            GenericAttribute getPatternElement() {
                return NEW_EMAIL_ENTRY;
            }

            String getTitle() {
                return "E-Mail";
            }

            String getNewValuePattern() {
                return ContactFrame.EMAIL_PAT;
            }
        }

        abstract class BaseAttrTableModel
        extends AbstractTableModel {
            Vector elements;

            BaseAttrTableModel() {
            }

            void init() {
                if (((GeneralTab)GeneralTab.this).ContactFrame.this.contact != null) {
                    this.elements = this.getElements();
                    if (this.elements == null) {
                        ((GeneralTab)GeneralTab.this).ContactFrame.this.contact.add(this.getPatternElement());
                        this.elements = this.getElements();
                        this.elements.removeAllElements();
                    }
                } else {
                    this.elements = new Vector();
                }
            }

            abstract Vector getElements();

            abstract GenericAttribute createElement();

            abstract GenericAttribute getPatternElement();

            abstract String getTitle();

            abstract String getNewValuePattern();

            public boolean isCellEditable(int n, int n2) {
                return true;
            }

            public String getColumnName(int n) {
                if (n == 1) {
                    return this.getTitle();
                }
                return "Abrev";
            }

            public int getRowCount() {
                return (this.elements != null ? this.elements.size() : 0) + 1;
            }

            public int getColumnCount() {
                return 2;
            }

            public Object getValueAt(int n, int n2) {
                if (this.elements != null) {
                    GenericAttribute genericAttribute = n > this.elements.size() - 1 ? null : (GenericAttribute)this.elements.elementAt(n);
                    switch (n2) {
                        case 0: {
                            return genericAttribute == null ? ContactFrame.NEW_PAT : genericAttribute.getShortDescription();
                        }
                        case 1: {
                            return genericAttribute == null ? this.getNewValuePattern() : genericAttribute.getNormalized();
                        }
                    }
                }
                return null;
            }

            public void setValueAt(Object object, int n, int n2) {
                GenericAttribute genericAttribute;
                GenericAttribute genericAttribute2 = genericAttribute = n > this.elements.size() - 1 ? null : (GenericAttribute)this.elements.elementAt(n);
                if (genericAttribute == null) {
                    genericAttribute = this.createElement();
                    this.elements.addElement(genericAttribute);
                }
                switch (n2) {
                    case 0: {
                        genericAttribute.setDescription(object.toString());
                        break;
                    }
                    case 1: {
                        genericAttribute.setValue(object.toString());
                    }
                }
            }

            void remove(int n) {
                if (n < this.elements.size() && n > -1) {
                    this.elements.remove(n);
                }
            }

            public Vector getActualElements() {
                return this.elements;
            }
        }

        class RowRemover
        extends KeyAdapter {
            RowRemover() {
            }

            public void keyPressed(KeyEvent keyEvent) {
                JTable jTable;
                int n;
                if (keyEvent.getKeyCode() == 127 && keyEvent.getSource() instanceof JTable && (n = (jTable = (JTable)keyEvent.getSource()).getSelectedRow()) > -1) {
                    ((BaseAttrTableModel)jTable.getModel()).remove(n);
                    jTable.revalidate();
                }
            }
        }
    }
}

