/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import photoorganizer.Controller;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.BasicIo;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.DirectoryEntry;
import photoorganizer.formats.FileFormatException;
import photoorganizer.formats.Header;
import photoorganizer.formats.Rational;

public class Flashpix
extends AbstractImageInfo {
    public static final String FORMAT = "Flashpix";
    static final int HEADER_LENGTH = 512;
    static final byte[] SIGNATURE = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    Header header;
    byte[] fat;
    Icon icon;

    public Flashpix() {
    }

    public Flashpix(InputStream inputStream, byte[] byArray, int n, String string) throws FileFormatException {
        super(inputStream, byArray, n, string, null);
    }

    public void readInfo() throws FileFormatException {
        try {
            this.data = new byte[504];
            BasicIo.read(this.is, this.data);
            this.offset += this.data.length;
            this.header = new Header();
            this.header.fill(this.data, -8);
            this.intel = this.header.intelByteOrder;
            System.err.println("Header " + this.header.toString() + " of " + this.getName());
            BasicIo.skip(this.is, this.header.fat[0] * this.header.sectorSize);
            this.offset += this.header.fat[0] * this.header.sectorSize;
            this.data = new byte[this.header.sectorSize];
            int n = 0;
            while (n < this.header.sectsFat) {
                System.err.println("Fat sector [" + n + "]=" + this.header.fat[n]);
                ++n;
            }
            BasicIo.read(this.is, this.data);
            this.offset += this.data.length;
            System.err.println("Sector " + this.header.sectDirStart + " marker " + Integer.toHexString(this.s2n(this.header.sectDirStart * 4, 4)));
            this.fat = this.data;
            this.data = new byte[this.header.sectorSize];
            BasicIo.read(this.is, this.data);
            this.offset += this.data.length;
            DirectoryEntry directoryEntry = new DirectoryEntry();
            directoryEntry.fill(this.data, 0);
            System.err.println("Root " + directoryEntry.toString());
            if (directoryEntry._child < 0) {
                return;
            }
            DirectoryEntry directoryEntry2 = new DirectoryEntry();
            directoryEntry2.fill(this.data, directoryEntry._child * 128);
            System.err.println("Child " + directoryEntry2.toString());
            DirectoryEntry directoryEntry3 = new DirectoryEntry();
            if (directoryEntry2._leftSib > 0) {
                directoryEntry3.fill(this.data, directoryEntry2._leftSib * 128);
                System.err.println("Left sib " + directoryEntry3.toString());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getFormat() {
        return FORMAT;
    }

    public int getResolutionX() {
        return 0;
    }

    public int getResolutionY() {
        return 0;
    }

    public String getMake() {
        return null;
    }

    public String getModel() {
        return null;
    }

    public String getDataTimeOriginalString() {
        return null;
    }

    public float getFNumber() {
        return 0.0f;
    }

    public Rational getShutter() {
        return new Rational(0, 1);
    }

    public boolean isFlash() {
        return false;
    }

    public String getQuality() {
        return null;
    }

    public float getFocalLength() {
        return 0.0f;
    }

    public int getMetering() {
        return 0;
    }

    public int getExpoProgram() {
        return 0;
    }

    public String getReport() {
        return null;
    }

    public Icon getThumbnailIcon(BasicJpeg basicJpeg, Dimension dimension) {
        if (this.icon != null) {
            return this.icon;
        }
        if (Controller.getAdvancedImage() != null) {
            try {
                this.icon = Controller.getAdvancedImage().createThumbnailIcon(basicJpeg.getLocationName(), null);
                return this.icon;
            }
            catch (Throwable throwable) {
                System.err.println(throwable);
            }
        }
        return null;
    }
}

