/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import photoorganizer.Controller;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.FileFormatException;
import photoorganizer.formats.Rational;

public class JFXX
extends AbstractImageInfo {
    static final String FORMAT = "JFXX";
    static final String PICTURE_INFO = "picture info";
    static final String CAMERA_INFO = "camera info";
    static final String DIAG_INFO = "diag info";
    static final String USER = "user";
    static final String END = "end";
    static final String FILE_INFO = "file info";
    static final String TIMEDATE = "TimeDate";
    static final String SHUTTER = "Shutter";
    static final String FNUMBER = "Fnumber";
    static final String CFNUMBER = "FNumber";
    static final String ZOOM = "Zoom";
    static final String RESOLUTION = "Resolution";
    static final String IMAGESIZE = "ImageSize";
    static final String FLASH = "Flash";
    static final String ID = "ID";
    static final String TYPE = "Type";
    final DecimalFormat fnumberformat = new DecimalFormat("F##.##");
    final DecimalFormat zoomformat = new DecimalFormat("x##.##");
    private byte[] image;
    private String make;
    private Hashtable pictureinfo;
    private Hashtable camerainfo;
    private Hashtable diaginfo;
    private Hashtable fileinfo;

    public JFXX(InputStream inputStream, byte[] byArray, int n, String string, String string2) throws FileFormatException {
        super(inputStream, byArray, n, string, string2);
    }

    public String getFormat() {
        return FORMAT;
    }

    public static byte[] getMarkerData() {
        return new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
    }

    public String getMake() {
        if (this.make != null) {
            return this.make;
        }
        return FORMAT;
    }

    public String getModel() {
        return "" + (String)this.camerainfo.get(ID) + " " + (String)this.camerainfo.get(TYPE);
    }

    public String getReport() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Shutter: ");
        stringBuffer.append((String)this.pictureinfo.get(SHUTTER));
        stringBuffer.append(", Aperture: ");
        String string = (String)this.pictureinfo.get(FNUMBER);
        if (string == null) {
            string = (String)this.pictureinfo.get(CFNUMBER);
        }
        stringBuffer.append(string).append(", Flash: ");
        stringBuffer.append("0".equals((String)this.pictureinfo.get(FLASH)) ? "yes" : "no");
        return stringBuffer.toString();
    }

    public String getDataTimeOriginalString() {
        String string = (String)this.pictureinfo.get(TIMEDATE);
        if (string != null) {
            return AbstractImageInfo.dateformat.format(new Date((long)Integer.parseInt(string) * 1000L));
        }
        return null;
    }

    public int getResolutionX() {
        int n;
        String string = (String)this.pictureinfo.get(IMAGESIZE);
        if (string != null && (n = string.indexOf(45)) > 0) {
            try {
                return Integer.parseInt(string.substring(0, n));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getResolutionY() {
        int n;
        String string = (String)this.pictureinfo.get(IMAGESIZE);
        if (string != null && (n = string.indexOf(45)) > 0) {
            try {
                return Integer.parseInt(string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getMetering() {
        return 0;
    }

    public int getExpoProgram() {
        return 0;
    }

    public float getFNumber() {
        try {
            String string = (String)this.pictureinfo.get(FNUMBER);
            if (string == null) {
                string = (String)this.pictureinfo.get(CFNUMBER);
            }
            return this.fnumberformat.parse(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1.0f;
    }

    public Rational getShutter() {
        try {
            return new Rational(Integer.parseInt((String)this.pictureinfo.get(SHUTTER)), 1);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Rational(0, 1);
    }

    public boolean isFlash() {
        if (this.pictureinfo == null) {
            return false;
        }
        String string = (String)this.pictureinfo.get(FLASH);
        if (string != null) {
            return !"0".equals(string);
        }
        return false;
    }

    public float getFocalLength() {
        try {
            return this.zoomformat.parse((String)this.pictureinfo.get(ZOOM)).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0f;
    }

    public String getQuality() {
        return (String)this.pictureinfo.get(RESOLUTION);
    }

    public void saveThumbnailImage(BasicJpeg basicJpeg, OutputStream outputStream) throws IOException {
        if (this.image != null && outputStream != null) {
            outputStream.write(this.image);
            outputStream.flush();
            outputStream.close();
        }
    }

    public Icon getThumbnailIcon(BasicJpeg basicJpeg, Dimension dimension) {
        if (this.image != null) {
            return new ImageIcon(this.image);
        }
        if (Controller.getAdvancedImage() != null) {
            try {
                return Controller.getAdvancedImage().createThumbnailIcon(basicJpeg.getLocationName(), null);
            }
            catch (Throwable throwable) {
                System.err.println(throwable);
            }
        }
        return null;
    }

    public void readInfo() {
        try {
            this.readAPP0X();
            this.readAPP12();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.data = null;
    }

    void readAPP0X() {
        switch (this.data[5]) {
            case 16: {
                this.image = new byte[this.data.length - 6];
                System.arraycopy(this.data, 6, this.image, 0, this.image.length);
            }
        }
    }

    void readAPP12() throws IOException {
        this.data = new byte[4];
        this.is.read(this.data);
        if (this.data[0] == -1 && this.data[1] == -20) {
            int n = this.bs2i(2, 2) - 2;
            this.data = new byte[n];
            BasicJpeg.read(this.is, this.data);
            ParserAPP12 parserAPP12 = new ParserAPP12(0);
            this.make = parserAPP12.next();
            parserAPP12.next();
            this.pictureinfo = new Hashtable();
            this.camerainfo = new Hashtable();
            this.diaginfo = new Hashtable();
            this.fileinfo = new Hashtable();
            Hashtable hashtable = null;
            while (parserAPP12.hasMore()) {
                StringTokenizer stringTokenizer;
                String string = parserAPP12.next();
                if (string.startsWith("[")) {
                    if (string.indexOf(PICTURE_INFO) == 1) {
                        hashtable = this.pictureinfo;
                        continue;
                    }
                    if (string.indexOf(CAMERA_INFO) == 1) {
                        hashtable = this.camerainfo;
                        continue;
                    }
                    if (string.indexOf(DIAG_INFO) == 1) {
                        hashtable = this.diaginfo;
                        continue;
                    }
                    if (string.indexOf(FILE_INFO) == 1) {
                        hashtable = this.fileinfo;
                        continue;
                    }
                    hashtable = null;
                    continue;
                }
                if (hashtable == null || !(stringTokenizer = new StringTokenizer(string, "=")).hasMoreTokens()) continue;
                String string2 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) continue;
                hashtable.put(string2, stringTokenizer.nextToken());
            }
        }
    }

    public Hashtable getPictureInfo() {
        return this.pictureinfo;
    }

    public Hashtable getCameraInfo() {
        return this.camerainfo;
    }

    public Hashtable getDiagInfo() {
        return this.diaginfo;
    }

    public Hashtable getFileInfo() {
        return this.fileinfo;
    }

    class ParserAPP12 {
        int curpos;

        ParserAPP12(int n) {
            this.curpos = n;
        }

        boolean hasMore() {
            return this.curpos < JFXX.this.data.length - 1;
        }

        String next() {
            int n = this.curpos;
            while (this.curpos < JFXX.this.data.length && JFXX.this.data[this.curpos] != 0 && JFXX.this.data[this.curpos] != 10 && JFXX.this.data[this.curpos] != 13) {
                ++this.curpos;
            }
            String string = null;
            try {
                string = new String(JFXX.this.data, n, this.curpos - n, "Default");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            while (this.curpos < JFXX.this.data.length && (JFXX.this.data[this.curpos] == 0 || JFXX.this.data[this.curpos] == 10 || JFXX.this.data[this.curpos] == 13)) {
                ++this.curpos;
            }
            return string;
        }
    }
}

