/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicInputConnector;
import com.sun.media.BasicSinkModule;
import com.sun.media.Connector;
import com.sun.media.InputConnector;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.Prefetchable;
import javax.media.ResourceUnavailableException;
import javax.media.protocol.DataSource;

public class BasicMuxModule
extends BasicSinkModule {
    protected Multiplexer multiplexer;
    protected Format[] inputs;
    protected InputConnector[] ics;
    protected boolean[] endMarkers;
    protected boolean[] resettedMarkers;
    protected boolean prefetching = false;
    protected boolean started = false;
    protected boolean paused = false;
    private boolean closed = false;
    private Object prefetchSync = new Object();
    private Object pauseSync = new Object();
    public static String ConnectorNamePrefix = "input";

    protected BasicMuxModule(Multiplexer m2, Format[] inputs) {
        this.multiplexer = m2;
        if (inputs != null) {
            this.ics = new InputConnector[inputs.length];
            int i2 = 0;
            while (i2 < inputs.length) {
                MyInputConnector ic = new MyInputConnector();
                ic.setSize(1);
                ic.setModule(this);
                this.registerInputConnector(String.valueOf(ConnectorNamePrefix) + i2, ic);
                this.ics[i2] = ic;
                ++i2;
            }
            this.inputs = inputs;
        }
        if (this.multiplexer != null && this.multiplexer instanceof Clock) {
            this.setClock((Clock)((Object)this.multiplexer));
        }
        this.setProtocol(1);
    }

    public boolean isThreaded() {
        return false;
    }

    public boolean doRealize() {
        if (this.multiplexer == null || this.inputs == null) {
            return false;
        }
        try {
            this.multiplexer.open();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            return false;
        }
        this.endMarkers = new boolean[this.ics.length];
        this.resettedMarkers = new boolean[this.ics.length];
        return true;
    }

    public boolean doPrefetch() {
        this.prefetching = true;
        return true;
    }

    public void doFailedPrefetch() {
        this.prefetching = false;
    }

    public void abortPrefetch() {
        this.multiplexer.close();
        this.prefetching = false;
    }

    public void doStart() {
        super.doStart();
        this.resetEndMarkers();
        this.started = true;
        Object object = this.prefetchSync;
        synchronized (object) {
            this.prefetching = false;
            this.resume();
        }
    }

    public void doStop() {
        super.doStop();
        this.started = false;
        this.prefetching = true;
    }

    public void doDealloc() {
        this.multiplexer.close();
    }

    public void doClose() {
        this.multiplexer.close();
        Object object = this.pauseSync;
        synchronized (object) {
            this.closed = true;
            this.pauseSync.notifyAll();
        }
    }

    void pause() {
        this.paused = true;
    }

    void resume() {
        Object object = this.pauseSync;
        synchronized (object) {
            this.paused = false;
            this.pauseSync.notifyAll();
        }
    }

    public void connectorPushed(InputConnector ic) {
        int rc;
        if (this.paused) {
            Object object = this.pauseSync;
            synchronized (object) {
                try {
                    while (this.paused && !this.closed) {
                        this.pauseSync.wait();
                    }
                }
                catch (Exception exception) {}
            }
        }
        Buffer buffer = ic.getValidBuffer();
        int idx = -1;
        if (this.ics[0] == ic) {
            idx = 0;
        } else if (this.ics[1] == ic) {
            idx = 1;
        } else {
            int i2 = 2;
            while (i2 < this.ics.length) {
                if (this.ics[i2] == ic) {
                    idx = i2;
                    break;
                }
                ++i2;
            }
            if (idx == -1) {
                throw new RuntimeException("BasicMuxModule: unmatched input connector!");
            }
        }
        if (this.resetted) {
            if ((buffer.getFlags() & 0x100) != 0 && this.checkResettedMarkers(idx)) {
                this.resetted = false;
                this.doStop();
                if (this.moduleListener != null) {
                    this.moduleListener.resetted(this);
                }
            }
            ic.readReport();
            return;
        }
        if (this.closed) {
            return;
        }
        this.jmd.moduleIn(this, 0, buffer, true);
        if ((buffer.getFlags() & 0x200) != 0 && this.moduleListener != null) {
            this.moduleListener.markedDataArrived(this, buffer);
            buffer.setFlags(buffer.getFlags() & 0xFFFFFDFF);
        }
        do {
            rc = this.multiplexer.process(buffer, idx);
            if (!this.prefetching || this.multiplexer instanceof Prefetchable && !((Prefetchable)((Object)this.multiplexer)).isPrefetched()) continue;
            Object i3 = this.prefetchSync;
            synchronized (i3) {
                if (!this.started && this.prefetching && !this.resetted) {
                    this.pause();
                }
                this.prefetching = false;
            }
            if (this.moduleListener == null) continue;
            this.moduleListener.bufferPrefetched(this);
        } while (!this.resetted && rc == 2);
        if (buffer.isEOM() && this.checkEndMarkers(idx)) {
            this.doStop();
            if (!this.resetted) {
                this.pause();
            }
            if (this.moduleListener != null) {
                this.moduleListener.mediaEnded(this);
            }
        }
        ic.readReport();
        this.jmd.moduleIn(this, 0, buffer, false);
    }

    void resetEndMarkers() {
        boolean[] blArray = this.endMarkers;
        synchronized (blArray) {
            int i2 = 0;
            while (i2 < this.endMarkers.length) {
                this.endMarkers[i2] = false;
                ++i2;
            }
        }
    }

    boolean checkEndMarkers(int idx) {
        boolean[] blArray = this.endMarkers;
        synchronized (blArray) {
            this.endMarkers[idx] = true;
            int i2 = 0;
            while (i2 < this.endMarkers.length) {
                if (!this.endMarkers[i2]) {
                    boolean bl = false;
                    Object var4_6 = null;
                    return bl;
                }
                ++i2;
            }
            boolean bl = true;
            Object var4_7 = null;
            return bl;
        }
    }

    void resetResettedMarkers() {
        boolean[] blArray = this.resettedMarkers;
        synchronized (blArray) {
            int i2 = 0;
            while (i2 < this.resettedMarkers.length) {
                this.resettedMarkers[i2] = false;
                ++i2;
            }
        }
    }

    boolean checkResettedMarkers(int idx) {
        boolean[] blArray = this.resettedMarkers;
        synchronized (blArray) {
            this.resettedMarkers[idx] = true;
            int i2 = 0;
            while (i2 < this.resettedMarkers.length) {
                if (!this.resettedMarkers[i2]) {
                    boolean bl = false;
                    Object var4_6 = null;
                    return bl;
                }
                ++i2;
            }
            boolean bl = true;
            Object var4_7 = null;
            return bl;
        }
    }

    protected void process() {
    }

    public void reset() {
        super.reset();
        this.resetResettedMarkers();
    }

    public void triggerReset() {
        this.multiplexer.reset();
        Object object = this.prefetchSync;
        synchronized (object) {
            this.prefetching = false;
            if (this.resetted) {
                this.resume();
            }
        }
    }

    public DataSource getDataOutput() {
        return this.multiplexer.getDataOutput();
    }

    public Multiplexer getMultiplexer() {
        return this.multiplexer;
    }

    public Object[] getControls() {
        return this.multiplexer.getControls();
    }

    public Object getControl(String s) {
        return this.multiplexer.getControl(s);
    }

    public Format[] listFormats(Connector connector) {
        return new Format[0];
    }

    public void setFormat(Connector connector, Format format) {
    }

    class MyInputConnector
    extends BasicInputConnector {
        public MyInputConnector() {
            BasicMuxModule.this = BasicMuxModule.this;
        }

        public String toString() {
            return String.valueOf(super.toString()) + ": " + this.getFormat();
        }
    }
}

