/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio.device;

import com.sun.media.renderer.audio.device.AudioOutput;
import javax.media.format.AudioFormat;
import javax.media.sound.sampled.AudioSystem;
import javax.media.sound.sampled.DataLine;
import javax.media.sound.sampled.GainControl;
import javax.media.sound.sampled.Line;
import javax.media.sound.sampled.Mixer;
import javax.media.sound.sampled.SampleRateControl;
import javax.media.sound.sampled.SourceDataLine;
import javax.media.sound.sampled.Type;

public class JavaSoundOutput
implements AudioOutput {
    static Mixer mixer = null;
    static Object initSync = new Object();
    protected SourceDataLine dataLine;
    protected GainControl gc;
    protected SampleRateControl rc;
    protected int bufSize;
    protected AudioFormat format;
    private int frameSize;
    static /* synthetic */ Class class$javax$media$sound$sampled$SourceDataLine;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean initialize(AudioFormat format, int bufSize) {
        Object object = initSync;
        synchronized (object) {
            javax.media.sound.sampled.AudioFormat afmt = JavaSoundOutput.convertFormat(format);
            this.frameSize = format.getSampleSizeInBits() * format.getChannels() / 8;
            if (this.frameSize == 0) {
                this.frameSize = 1;
            }
            DataLine.Info info = new DataLine.Info(class$javax$media$sound$sampled$SourceDataLine != null ? class$javax$media$sound$sampled$SourceDataLine : (class$javax$media$sound$sampled$SourceDataLine = JavaSoundOutput.class$("javax.media.sound.sampled.SourceDataLine")), null, null, new Class[0], afmt, bufSize / this.frameSize);
            try {
                if (!AudioSystem.isSupportedLine((Line.Info)info)) {
                    System.err.println("DataLine not supported: " + format);
                    return false;
                }
                this.dataLine = (SourceDataLine)AudioSystem.getLine((Line.Info)info);
                this.dataLine.open(afmt, bufSize / this.frameSize);
            }
            catch (Exception e2) {
                System.err.println("Cannot open audio device: " + e2);
                return false;
            }
            this.format = format;
            this.bufSize = bufSize;
            if (this.dataLine == null) {
                System.out.println("JavaSound unsupported format: " + format);
                return false;
            }
            try {
                this.gc = (GainControl)this.dataLine.getControl(Class.forName("javax.media.sound.sampled.GainControl"));
            }
            catch (Exception exception) {
                System.err.println("JavaSound: No gain control");
            }
            try {
                this.rc = (SampleRateControl)this.dataLine.getControl(Class.forName("javax.media.sound.sampled.SampleRateControl"));
                return true;
            }
            catch (Exception exception) {
                System.err.println("JavaSound: No rate control");
            }
            return true;
        }
    }

    public void dispose() {
        this.dataLine.close();
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public void pause() {
        if (this.dataLine != null) {
            this.dataLine.stop();
        }
    }

    public void resume() {
        if (this.dataLine != null) {
            this.dataLine.start();
        }
    }

    public void drain() {
        this.dataLine.drain();
    }

    public void flush() {
        this.dataLine.flush();
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public long getMediaNanoseconds() {
        if (this.dataLine == null || this.format == null) {
            return 0L;
        }
        return (long)((double)(this.dataLine.getPosition() * 1000L) / this.format.getSampleRate() * 1000000.0);
    }

    public void setGain(double g2) {
        if (this.gc != null) {
            this.gc.setGain((float)g2);
        }
    }

    public double getGain() {
        return this.gc != null ? this.gc.getGain() : 0.0f;
    }

    public void setMute(boolean m2) {
        if (this.gc != null) {
            this.gc.setMute(m2);
        }
    }

    public boolean getMute() {
        return this.gc != null ? this.gc.getMute() : false;
    }

    public float setRate(float r2) {
        if (this.rc == null) {
            return 1.0f;
        }
        this.rc.setSampleRate((float)((double)r2 * this.format.getSampleRate()));
        return r2;
    }

    public float getRate() {
        if (this.rc == null) {
            return 1.0f;
        }
        return (float)((double)this.rc.getSampleRate() / this.format.getSampleRate());
    }

    public int bufferAvailable() {
        return this.dataLine.availableWrite() * this.frameSize;
    }

    public int write(byte[] data, int off, int len) {
        return this.frameSize * this.dataLine.write(data, off, len / this.frameSize);
    }

    public static boolean isOpen() {
        Mixer mixer = AudioSystem.getMixer(null);
        Line[] lines = mixer.getSourceLines();
        return lines != null && lines.length > 0;
    }

    public static AudioFormat convertFormat(javax.media.sound.sampled.AudioFormat fmt) {
        Type type = fmt.getEncoding();
        String encoding = type == javax.media.sound.sampled.AudioFormat.PCM_SIGNED || type == javax.media.sound.sampled.AudioFormat.PCM_UNSIGNED ? "LINEAR" : (type == javax.media.sound.sampled.AudioFormat.ALAW ? "alaw" : (type == javax.media.sound.sampled.AudioFormat.ULAW ? "ULAW" : null));
        return new AudioFormat(encoding, fmt.getSampleRate(), fmt.getSampleSizeInBits(), fmt.getChannels(), fmt.isBigEndian() ? 1 : 0, type == javax.media.sound.sampled.AudioFormat.PCM_SIGNED ? 1 : 0);
    }

    public static javax.media.sound.sampled.AudioFormat convertFormat(AudioFormat fmt) {
        return new javax.media.sound.sampled.AudioFormat((float)fmt.getSampleRate(), fmt.getSampleSizeInBits(), fmt.getChannels(), fmt.getSigned() == 1, fmt.getEndian() == 1);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

