/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketSource;
import com.sun.media.rtp.util.UDPPacket;
import java.io.IOException;
import java.util.Vector;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import javax.media.rtp.RTPPushDataSource;

public class RTPPacketReceiver
implements PacketSource,
SourceTransferHandler {
    RTPPushDataSource rtpsource;
    Vector dataqueue;

    public RTPPacketReceiver(RTPPushDataSource rtpsource) {
        this.rtpsource = rtpsource;
        PushSourceStream output = rtpsource.getOutputStream();
        output.setTransferHandler(this);
        this.dataqueue = new Vector();
    }

    public void transferData(PushSourceStream sourcestream) {
        int size = sourcestream.getMinimumTransferSize();
        byte[] buffer = new byte[size];
        try {
            sourcestream.read(buffer, 0, size);
        }
        catch (IOException iOException) {}
        this.AddToQueue(buffer);
    }

    private synchronized void AddToQueue(Object node) {
        this.dataqueue.addElement(node);
        this.notifyAll();
    }

    private synchronized Object RemoveFromQueue() {
        try {
            while (this.dataqueue.size() == 0) {
                this.wait();
            }
        }
        catch (InterruptedException e2) {
            System.err.println(" RTPEventthread " + e2);
            return null;
        }
        Object data = this.dataqueue.elementAt(0);
        this.dataqueue.removeElementAt(0);
        return data;
    }

    public Packet receiveFrom() throws IOException {
        byte[] packet = (byte[])this.RemoveFromQueue();
        if (packet == null) {
            throw new IOException();
        }
        UDPPacket p2 = new UDPPacket();
        p2.receiptTime = System.currentTimeMillis();
        p2.data = packet;
        p2.offset = 0;
        p2.length = packet.length;
        return p2;
    }

    public void closeSource() {
    }

    public String sourceString() {
        String s = "RTPPacketReceiver for " + this.rtpsource;
        return s;
    }
}

