/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.BasicComp;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ButtonComp
extends BasicComp
implements MouseListener {
    Image[] imageNormal = new Image[2];
    Image[] imageActive = new Image[2];
    Image[] imageDown = new Image[2];
    Image[] imageDisabled = new Image[2];
    static final int NORMAL = 1;
    static final int ACTIVE = 2;
    static final int DOWN = 4;
    static final int DISABLED = 8;
    int width;
    int height;
    boolean state = false;
    boolean mouseIn = false;
    boolean mouseDown = false;
    boolean mouseUp = false;
    boolean mouseClick = false;
    int visualState = 1;
    private PopupMenu menuPopup;
    private ContPressThread threadContPress;
    private boolean boolContPress = false;

    public ButtonComp(String label, String imgNormal0, String imgActive0, String imgDown0, String imgDisabled0, String imgNormal1, String imgActive1, String imgDown1, String imgDisabled1) {
        super(label);
        this.imageNormal[0] = BasicComp.fetchImage(imgNormal0);
        this.imageNormal[1] = BasicComp.fetchImage(imgNormal1);
        this.imageActive[0] = BasicComp.fetchImage(imgActive0);
        this.imageActive[1] = BasicComp.fetchImage(imgActive1);
        this.imageDown[0] = BasicComp.fetchImage(imgDown0);
        this.imageDown[1] = BasicComp.fetchImage(imgDown1);
        this.imageDisabled[0] = BasicComp.fetchImage(imgDisabled0);
        this.imageDisabled[1] = BasicComp.fetchImage(imgDisabled1);
        this.width = this.imageNormal[0].getWidth(this);
        this.height = this.imageNormal[0].getHeight(this);
        this.visualState = 1;
        this.setSize(this.width, this.height);
        this.setVisible(true);
        this.addMouseListener(this);
    }

    public void mouseActivity() {
        if (this.isEnabled()) {
            if (this.mouseIn) {
                if (this.mouseDown) {
                    this.visualState = 4;
                    if (this.mouseUp) {
                        this.action();
                        this.visualState = 2;
                    }
                } else {
                    this.visualState = 2;
                }
            } else {
                this.visualState = 1;
            }
        } else {
            this.visualState = 8;
        }
        this.repaint();
    }

    public void action() {
        this.state = !this.state;
        this.informListener();
    }

    public void paint(Graphics g2) {
        int index = this.state ? 1 : 0;
        Image image = null;
        switch (this.visualState) {
            case 1: {
                image = this.imageNormal[index];
                break;
            }
            case 2: {
                image = this.imageActive[index];
                break;
            }
            case 4: {
                image = this.imageDown[index];
                break;
            }
            case 8: {
                image = this.imageDisabled[index];
                break;
            }
        }
        if (image != null) {
            g2.drawImage(image, 0, 0, this);
        }
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.visualState = !value ? 8 : (this.mouseIn ? (this.mouseDown ? 4 : 2) : 1);
        this.repaint();
    }

    public boolean getValue() {
        return this.state;
    }

    public void setValue(boolean newState) {
        if (this.state != newState) {
            this.state = newState;
            this.repaint();
        }
    }

    public void setPopupMenu(PopupMenu menuPopup) {
        this.menuPopup = menuPopup;
        this.add(menuPopup);
    }

    public void setContMousePress(boolean boolSet) {
        this.boolContPress = boolSet;
    }

    public void mouseEntered(MouseEvent e2) {
        this.mouseIn = true;
        this.mouseActivity();
    }

    public void mouseExited(MouseEvent e2) {
        this.mouseIn = false;
        this.mouseActivity();
        if (this.threadContPress != null) {
            this.threadContPress.stopNormaly();
            this.threadContPress = null;
        }
    }

    public void mousePressed(MouseEvent e2) {
        int modifier = e2.getModifiers();
        if ((modifier & 8) == 0 && (modifier & 4) == 0) {
            this.mouseDown = true;
            this.mouseUp = false;
            this.mouseActivity();
            if (this.boolContPress) {
                if (this.threadContPress != null) {
                    this.threadContPress.stopNormaly();
                }
                this.threadContPress = new ContPressThread(this);
                this.threadContPress.start();
            }
        }
    }

    public void mouseReleased(MouseEvent e2) {
        int modifier = e2.getModifiers();
        if ((modifier & 8) == 0 && (modifier & 4) == 0) {
            this.mouseUp = true;
            this.mouseActivity();
            this.mouseUp = false;
            this.mouseDown = false;
            if (this.threadContPress != null) {
                this.threadContPress.stopNormaly();
                this.threadContPress = null;
            }
        }
    }

    public void mouseClicked(MouseEvent e2) {
        int modifier = e2.getModifiers();
        if ((modifier & 8) == 0 && (modifier & 4) == 0) {
            this.mouseClick = true;
            this.mouseActivity();
            this.mouseClick = false;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    protected void processMouseEvent(MouseEvent event) {
        super.processMouseEvent(event);
        if (event.isPopupTrigger() && this.menuPopup != null) {
            Dimension dim = this.getSize();
            this.menuPopup.show(this, 0, dim.height);
        }
    }

    class ContPressThread
    extends Thread {
        private ButtonComp button;
        private boolean boolContinueRun = true;
        private boolean boolIgnoreFirst = true;

        public ContPressThread(ButtonComp button) {
            ButtonComp.this = ButtonComp.this;
            this.button = button;
        }

        public void stopNormaly() {
            this.boolContinueRun = false;
        }

        public void run() {
            this.boolIgnoreFirst = true;
            while (this.boolContinueRun) {
                try {
                    Thread.sleep(250L);
                }
                catch (Exception exception) {}
                if (this.button != null && !this.boolIgnoreFirst) {
                    this.button.informListener();
                }
                this.boolIgnoreFirst = false;
            }
        }
    }
}

