/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.controls.BooleanControl;
import com.sun.media.controls.BooleanControlAdapter;
import com.sun.media.controls.NumericControl;
import com.sun.media.controls.PlaybackControl;
import com.sun.media.controls.ProgressControl;
import com.sun.media.controls.SliderRegionControl;
import com.sun.media.controls.StringControl;
import com.sun.media.controls.VideoSizingControl;
import com.sun.media.ui.AtomicComponent;
import com.sun.media.ui.BiFloatButton;
import com.sun.media.ui.BooleanComponent;
import com.sun.media.ui.BufferedPanel;
import com.sun.media.ui.GainControlComponent;
import com.sun.media.ui.PlayButton;
import com.sun.media.ui.ProgressSlider;
import com.sun.media.ui.PropertySheet;
import com.sun.media.ui.VolumeDisplay;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PopupMenu;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.media.Control;
import javax.media.GainControl;
import javax.media.Player;

public class DefaultControlPanel
extends BufferedPanel {
    static final Color BackgroundColor = new Color(190, 190, 190);
    PlaybackControl pc;
    int width = 320;
    int height = 20;
    int minimumWidth;
    int minimumHeight;
    Player player;
    Frame parentFrame;
    WindowListener wl;
    private boolean firstTime = true;
    AtomicComponent playButton;
    ProgressSlider progressSlider;
    GainControlComponent audioControls;
    VolumeDisplay volumeDisplay;
    AtomicComponent propsButton;
    PropertySheet propsSheet;
    PopupMenu rateMenu;
    BooleanControl playControl;
    NumericControl seekControl;
    BooleanControl propsControl;
    ProgressControl progressControl;
    GainControl gainControl;
    VideoSizingControl videoSizingControl;
    SliderRegionControl regionControl;
    String urlName;

    public DefaultControlPanel(Player player) {
        this.player = player;
        this.getPlayerControls();
        this.setLayout(new FlowLayout(1, 1, 1));
        this.minimumWidth = 4;
        this.minimumHeight = 4;
        this.setBackground(BackgroundColor);
        this.playButton = new PlayButton(this);
        if (this.playControl != null) {
            ((BooleanComponent)this.playButton).setControl(this.playControl);
        }
        this.propsButton = new BiFloatButton("info.gif", "info-active.gif", "info-pressed.gif", "info-disabled.gif", "info.gif", "info-active.gif", "info-pressed.gif", "info-disabled.gif", "Properties sheet");
        this.propsControl = new PropsControl();
        this.propsButton.setControl(this.propsControl);
        this.progressSlider = new ProgressSlider("Media position");
        if (this.seekControl != null) {
            this.progressSlider.setControl(this.seekControl);
        }
        if (this.regionControl != null) {
            this.progressSlider.setDisplayControl(this.regionControl);
        }
        this.add(this.playButton);
        this.minimumWidth += this.playButton.getPreferredSize().width;
        if (this.seekControl != null) {
            this.add(this.progressSlider);
        }
        if (this.gainControl != null) {
            this.audioControls = new GainControlComponent(this.gainControl);
            this.add(this.audioControls);
            this.minimumWidth += this.audioControls.getPreferredSize().width;
        }
        if (this.progressControl != null) {
            this.add(this.propsButton);
            this.minimumWidth += this.propsButton.getPreferredSize().width;
        }
        this.width = this.minimumWidth;
        this.height = this.playButton.getPreferredSize().width;
        this.validate();
        this.setSize(this.width, this.height);
        this.setVisible(true);
        this.addComponentListener(new 1());
        this.setBackgroundTile(AtomicComponent.fetchImage("texture1.gif"));
    }

    public synchronized void minicleanUp() {
        this.firstTime = true;
        if (this.volumeDisplay != null) {
            this.volumeDisplay.dispose();
            this.volumeDisplay = null;
        }
    }

    public synchronized void cleanUp() {
        if (this.propsSheet != null) {
            this.propsSheet.dispose();
            this.propsSheet = null;
        }
        if (this.volumeDisplay != null) {
            this.volumeDisplay.dispose();
            this.volumeDisplay = null;
        }
        if (this.rateMenu != null && this.playButton != null) {
            this.playButton.remove(this.rateMenu);
            this.rateMenu = null;
        }
        if (this.progressSlider != null) {
            this.progressSlider.dispose();
            this.progressSlider = null;
        }
        if (this.audioControls != null) {
            this.remove(this.audioControls);
            this.audioControls = null;
        }
        this.player = null;
        this.playControl = null;
        this.seekControl = null;
        this.propsControl = null;
        this.progressControl = null;
        this.gainControl = null;
        this.videoSizingControl = null;
        this.regionControl = null;
        if (this.parentFrame != null && this.wl != null) {
            this.parentFrame.removeWindowListener(this.wl);
            this.parentFrame = null;
            this.wl = null;
        }
    }

    public synchronized void dispose() {
        this.cleanUp();
    }

    private void getPlayerControls() {
        if (this.player == null) {
            return;
        }
        this.gainControl = this.player.getGainControl();
        Control[] controls = this.player.getControls();
        int i2 = 0;
        while (i2 < controls.length) {
            StringControl sc;
            Control ctl = controls[i2];
            if (ctl instanceof PlaybackControl) {
                PlaybackControl pbc = (PlaybackControl)ctl;
                this.playControl = pbc.getPlay();
                this.seekControl = pbc.getSeek();
            }
            if (ctl instanceof GainControl) {
                this.gainControl = (GainControl)ctl;
            }
            if (ctl instanceof VideoSizingControl) {
                this.videoSizingControl = (VideoSizingControl)ctl;
            }
            if (ctl instanceof ProgressControl) {
                this.progressControl = (ProgressControl)ctl;
            }
            if (ctl instanceof SliderRegionControl) {
                this.regionControl = (SliderRegionControl)ctl;
            }
            if (ctl instanceof StringControl && (sc = (StringControl)ctl).getValue().indexOf("URL=") == 0) {
                this.urlName = sc.getValue();
                this.urlName = this.urlName.substring(4);
            }
            ++i2;
        }
    }

    public void paint(Graphics g2) {
        if (this.firstTime) {
            this.findFrame();
        }
        super.paint(g2);
    }

    protected synchronized void findFrame() {
        block5: {
            if (!this.firstTime) break block5;
            this.firstTime = false;
            Container c2 = this.getParent();
            while (!(c2 instanceof Frame) && c2 != null) {
                c2 = c2.getParent();
            }
            if (c2 instanceof Frame) {
                this.parentFrame = (Frame)c2;
                this.wl = new 2();
                ((Frame)c2).addWindowListener(this.wl);
                if (this.gainControl != null && this.audioControls != null && this.volumeDisplay == null) {
                    try {
                        this.volumeDisplay = new VolumeDisplay(this.gainControl, this.parentFrame);
                        ((Component)this.volumeDisplay).setVisible(false);
                        this.volumeDisplay.addNotify();
                        this.audioControls.setVolumeDisplay(this.volumeDisplay);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.minimumWidth + 30, this.height);
    }

    public void reshape(int x, int y, int w, int h2) {
        if (w < this.minimumWidth + 30) {
            w = this.minimumWidth + 30;
        }
        super.reshape(x, y, w, h2);
        if (this.progressSlider != null) {
            this.progressSlider.setSize(w - this.minimumWidth, h2);
        }
        this.width = w;
        this.invalidate();
        this.validate();
    }

    public void removeNotify() {
        super.removeNotify();
    }

    private final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent ce) {
            DefaultControlPanel.this.width = DefaultControlPanel.this.getSize().width;
            if (DefaultControlPanel.this.progressSlider != null) {
                DefaultControlPanel.this.progressSlider.setSize(DefaultControlPanel.this.width - DefaultControlPanel.this.minimumWidth, DefaultControlPanel.this.height);
                DefaultControlPanel.this.progressSlider.invalidate();
            }
            DefaultControlPanel.this.invalidate();
            DefaultControlPanel.this.validate();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent we) {
            DefaultControlPanel.this.minicleanUp();
        }

        /* synthetic */ 2() {
        }
    }

    class PropsControl
    extends BooleanControlAdapter {
        boolean value;

        public PropsControl() {
            DefaultControlPanel.this = DefaultControlPanel.this;
        }

        public boolean setValue(boolean value) {
            if (DefaultControlPanel.this.propsSheet == null) {
                try {
                    DefaultControlPanel.this.propsSheet = new PropertySheet(DefaultControlPanel.this.parentFrame, DefaultControlPanel.this.player, DefaultControlPanel.this.progressControl, DefaultControlPanel.this.videoSizingControl, DefaultControlPanel.this.urlName);
                }
                catch (Exception exception) {
                    DefaultControlPanel.this.propsSheet = null;
                }
            }
            if (DefaultControlPanel.this.propsSheet != null) {
                DefaultControlPanel.this.propsSheet.showAt(0, 0);
            }
            this.value = false;
            return this.value;
        }

        public boolean getValue() {
            return this.value;
        }
    }
}

