/*
 * Decompiled with CFR 0.152.
 */
package rtp;

import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.media.rtp.GlobalTransmissionStats;
import javax.media.rtp.SessionManager;

public class OverallTransStatsWindow
extends Frame
implements Runnable {
    SessionManager mymgr;
    Thread thread;
    TextField rtpsentf;
    TextField bytessentf;
    TextField rtcp_sentf;
    TextField localcolltf;
    TextField remotecolltf;
    TextField transfailedtf;
    Checkbox alwaysOnTop;
    GridBagLayout gridbag;
    GridBagConstraints c;

    public OverallTransStatsWindow(SessionManager mgr) {
        super("Overall RTP Transmission Statistics");
        ((Component)this).setSize(250, 500);
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.c.fill = 2;
        this.c.anchor = 18;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.setLayout(this.gridbag);
        this.show();
        this.mymgr = mgr;
        Label rtpsent = new Label("Total RTP Packets Sent");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(rtpsent, this.c);
        this.add(rtpsent);
        this.rtpsentf = new TextField(10);
        this.rtpsentf.setEditable(false);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.rtpsentf, this.c);
        this.add(this.rtpsentf);
        Label bytessent = new Label("Total Bytes Sent");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(bytessent, this.c);
        this.add(bytessent);
        this.bytessentf = new TextField(10);
        this.bytessentf.setEditable(false);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.bytessentf, this.c);
        this.add(this.bytessentf);
        Label rtcp_sent = new Label("RTCP Packets Sent");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(rtcp_sent, this.c);
        this.add(rtcp_sent);
        this.rtcp_sentf = new TextField(10);
        this.rtcp_sentf.setEditable(false);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.rtcp_sentf, this.c);
        this.add(this.rtcp_sentf);
        Label localcoll = new Label("Local Collisions");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(localcoll, this.c);
        this.add(localcoll);
        this.localcolltf = new TextField(10);
        this.localcolltf.setEditable(false);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.localcolltf, this.c);
        this.add(this.localcolltf);
        Label remotecoll = new Label("Remote Collisions");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(remotecoll, this.c);
        this.add(remotecoll);
        this.remotecolltf = new TextField(10);
        this.remotecolltf.setEditable(false);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.remotecolltf, this.c);
        this.add(this.remotecolltf);
        Label ftrans = new Label("Failed Transmissions");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(ftrans, this.c);
        this.add(ftrans);
        this.transfailedtf = new TextField(10);
        this.transfailedtf.setEditable(false);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.transfailedtf, this.c);
        this.add(this.transfailedtf);
        this.alwaysOnTop = new Checkbox("Always on Top");
        this.alwaysOnTop.setState(true);
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(this.alwaysOnTop, this.c);
        this.add(this.alwaysOnTop);
        this.show();
        this.addWindowListener(new 1());
        this.thread = new Thread((Runnable)this, "OverallStatsThread");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void close() {
        this.thread.stop();
        this.dispose();
    }

    public void run() {
        while (true) {
            GlobalTransmissionStats stats = this.mymgr.getGlobalTransmissionStats();
            ((TextComponent)this.rtpsentf).setText(new Integer(stats.getRTPSent()).toString());
            ((TextComponent)this.bytessentf).setText(new Integer(stats.getBytesSent()).toString());
            ((TextComponent)this.rtcp_sentf).setText(new Integer(stats.getRTCPSent()).toString());
            ((TextComponent)this.localcolltf).setText(new Integer(stats.getLocalColls()).toString());
            ((TextComponent)this.remotecolltf).setText(new Integer(stats.getRemoteColls()).toString());
            ((TextComponent)this.transfailedtf).setText(new Integer(stats.getTransmitFailed()).toString());
            if (this.isShowing() && this.alwaysOnTop.getState()) {
                this.show();
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e2) {
            OverallTransStatsWindow.this.close();
        }

        /* synthetic */ 1() {
        }
    }
}

