/*
 * Decompiled with CFR 0.152.
 */
package rtp;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.RemoteParticipant;
import javax.media.rtp.SessionListener;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.ActiveReceiveStreamEvent;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.InactiveReceiveStreamEvent;
import javax.media.rtp.event.NewParticipantEvent;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.ReceiverReportEvent;
import javax.media.rtp.event.RemoteEvent;
import javax.media.rtp.event.SenderReportEvent;
import javax.media.rtp.event.SessionEvent;
import javax.media.rtp.event.TimeoutEvent;
import rtp.OverallStatsWindow;
import rtp.RTPParticipantWindow;

public class ParticipantListWindow
extends Frame
implements SessionListener,
ReceiveStreamListener,
RemoteListener,
ActionListener {
    Vector remotelist;
    Vector locallist;
    Vector passivelist;
    Vector activelist;
    List remotelistgui;
    List locallistgui;
    List passivelistgui;
    List activelistgui;
    Button statsbutton;
    private static final int ADD = 1;
    private static final int DELETE = 2;
    private static final int GRAY = 3;
    private static final int UNGRAY = 4;
    SessionManager mgr;
    Vector children;
    GridBagLayout gridbag;
    GridBagConstraints c;
    OverallStatsWindow stats;

    public ParticipantListWindow(SessionManager mgr) {
        super("Participant List");
        ((Component)this).setFont(new Font("Helvetica", 1, 12));
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.c.fill = 2;
        this.c.anchor = 18;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.setLayout(this.gridbag);
        this.mgr = mgr;
        this.children = new Vector();
        this.remotelistgui = this.CreateList("Remote", 5);
        this.locallistgui = this.CreateList("Local", 5);
        this.passivelistgui = this.CreateList("Passive", 5);
        this.activelistgui = this.CreateList("Active", 5);
        this.remotelist = this.mgr.getRemoteParticipants();
        LocalParticipant lpart = this.mgr.getLocalParticipant();
        this.locallist = new Vector(1);
        this.locallist.addElement(lpart);
        this.passivelist = this.mgr.getPassiveParticipants();
        this.activelist = this.mgr.getActiveParticipants();
        this.AddToList(this.remotelistgui, this.remotelist);
        this.AddToList(this.locallistgui, this.locallist);
        this.AddToList(this.passivelistgui, this.passivelist);
        this.AddToList(this.activelistgui, this.activelist);
        ((Component)this).setSize(500, 400);
        this.statsbutton = new Button("Statistics");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(this.statsbutton, this.c);
        this.add(this.statsbutton);
        this.statsbutton.addActionListener(this);
        this.show();
        this.addWindowListener(new 1());
        mgr.addSessionListener(this);
        mgr.addReceiveStreamListener(this);
        mgr.addRemoteListener(this);
    }

    public void Show() {
        this.show();
    }

    private List CreateList(String type, int numentry) {
        Label label = new Label(type);
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(label, this.c);
        this.add(label);
        List list = new List(numentry);
        list.setBackground(Color.white);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(list, this.c);
        this.add(list);
        list.addActionListener(this);
        return list;
    }

    private void AddToList(List list, Vector vlist) {
        if (list == null || vlist == null) {
            return;
        }
        int i2 = 0;
        while (i2 < vlist.size()) {
            Participant part = (Participant)vlist.elementAt(i2);
            if (part != null) {
                list.addItem(part.getCNAME());
            }
            ++i2;
        }
    }

    public void close() {
        int i2 = 0;
        while (i2 < this.children.size()) {
            ((RTPParticipantWindow)this.children.elementAt(i2)).close();
            ++i2;
        }
        if (this.stats != null) {
            this.stats.close();
        }
        this.dispose();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source instanceof List) {
            List guilist = (List)event.getSource();
            int i2 = guilist.getSelectedIndex();
            Vector list = this.VectorofGUI(guilist);
            try {
                Participant chosenpart = (Participant)list.elementAt(i2);
                RTPParticipantWindow child = new RTPParticipantWindow(this.mgr, chosenpart);
                this.children.addElement(child);
            }
            catch (NullPointerException e2) {
                System.err.println("Null PointerException ");
                e2.printStackTrace();
                return;
            }
        }
        if (source instanceof Button) {
            this.stats = new OverallStatsWindow(this.mgr);
        }
    }

    private Vector VectorofGUI(List gui) {
        if (gui == this.remotelistgui) {
            return this.remotelist;
        }
        if (gui == this.locallistgui) {
            return this.locallist;
        }
        if (gui == this.passivelistgui) {
            return this.passivelist;
        }
        if (gui == this.activelistgui) {
            return this.activelist;
        }
        return null;
    }

    public void update(SessionEvent event) {
        Participant part = null;
        Object stream = null;
        if (event instanceof NewParticipantEvent) {
            part = ((NewParticipantEvent)event).getParticipant();
            if (part == null) {
                return;
            }
            if (part instanceof LocalParticipant) {
                this.updateplist(this.locallistgui, 1, part);
            }
            if (part instanceof RemoteParticipant) {
                this.updateplist(this.remotelistgui, 1, part);
            }
            if (part.getStreams().size() == 0) {
                this.updateplist(this.passivelistgui, 1, part);
            }
            if (part.getStreams().size() > 0) {
                this.updateplist(this.activelistgui, 1, part);
            }
            return;
        }
    }

    public void update(RemoteEvent event) {
        Participant part = null;
        if (event instanceof ReceiverReportEvent && (part = ((ReceiverReportEvent)event).getReport().getParticipant()) != null && part.getStreams().size() == 0) {
            this.updateplist(this.activelistgui, 2, part);
            this.updateplist(this.passivelistgui, 1, part);
        }
        if (event instanceof SenderReportEvent && (part = ((SenderReportEvent)event).getReport().getParticipant()) != null && part.getStreams().size() > 0) {
            this.updateplist(this.passivelistgui, 2, part);
            this.updateplist(this.activelistgui, 1, part);
        }
    }

    public void update(ReceiveStreamEvent event) {
        Participant part = null;
        ReceiveStream stream = null;
        if (event instanceof TimeoutEvent || event instanceof ByeEvent) {
            if (event instanceof TimeoutEvent && ((TimeoutEvent)event).participantLeaving()) {
                part = ((TimeoutEvent)event).getParticipant();
            }
            if (event instanceof ByeEvent && ((ByeEvent)event).participantLeaving()) {
                part = ((ByeEvent)event).getParticipant();
            }
            if (part == null) {
                return;
            }
            if (part instanceof LocalParticipant) {
                this.updateplist(this.locallistgui, 2, part);
            }
            if (part instanceof RemoteParticipant) {
                this.updateplist(this.remotelistgui, 2, part);
            }
            this.updateplist(this.passivelistgui, 2, part);
            this.updateplist(this.activelistgui, 2, part);
        }
        if (event instanceof NewReceiveStreamEvent) {
            stream = ((NewReceiveStreamEvent)event).getReceiveStream();
            part = stream.getParticipant();
            if (part == null) {
                return;
            }
            this.updateplist(this.activelistgui, 1, part);
            this.updateplist(this.passivelistgui, 2, part);
            this.updateplist(this.activelistgui, 1, part);
        }
        if (event instanceof InactiveReceiveStreamEvent) {
            part = ((InactiveReceiveStreamEvent)event).getParticipant();
            if (part == null) {
                return;
            }
            this.updateplist(this.passivelistgui, 3, part);
            this.updateplist(this.activelistgui, 3, part);
            this.updateplist(this.remotelistgui, 3, part);
        }
        if (event instanceof ActiveReceiveStreamEvent) {
            part = ((ActiveReceiveStreamEvent)event).getParticipant();
            if (part == null) {
                return;
            }
            this.updateplist(this.passivelistgui, 4, part);
            this.updateplist(this.activelistgui, 4, part);
            this.updateplist(this.remotelistgui, 4, part);
        }
    }

    private void updateplist(List plistgui, int mode, Participant part) {
        Vector plist = null;
        if (plistgui == null || part == null) {
            return;
        }
        block2 : switch (mode) {
            case 1: {
                int i2 = 0;
                while (i2 < plistgui.getItemCount()) {
                    if (plistgui.getItem(i2).equals(part.getCNAME())) {
                        return;
                    }
                    String entry = plistgui.getItem(i2);
                    try {
                        String cname = entry.substring(0, entry.lastIndexOf("INACTIVE"));
                        if (cname.equals(part.getCNAME())) {
                            plistgui.delItem(i2);
                        }
                    }
                    catch (Exception exception) {}
                    ++i2;
                }
                plistgui.addItem(part.getCNAME());
                plist = this.VectorofGUI(plistgui);
                if (plist != null) {
                    plist.addElement(part);
                }
                if (!this.isShowing()) break;
                this.show();
                break;
            }
            case 2: {
                plist = this.VectorofGUI(plistgui);
                int i3 = 0;
                while (i3 < plistgui.getItemCount()) {
                    if (plistgui.getItem(i3).equals(part.getCNAME())) {
                        plistgui.delItem(i3);
                        if (this.isShowing()) {
                            this.show();
                        }
                        if (plist == null) break block2;
                        plist.removeElement(part);
                        break block2;
                    }
                    try {
                        String entry = plistgui.getItem(i3);
                        String cname = entry.substring(0, entry.lastIndexOf("INACTIVE"));
                        if (cname.equals(part.getCNAME())) {
                            plistgui.delItem(i3);
                            if (this.isShowing()) {
                                this.show();
                            }
                        }
                        if (plist == null) break block2;
                        plist.removeElement(part);
                        break block2;
                    }
                    catch (Exception exception) {
                        ++i3;
                    }
                }
                break;
            }
            case 3: {
                plist = this.VectorofGUI(plistgui);
                int i4 = 0;
                while (i4 < plistgui.getItemCount()) {
                    if (plistgui.getItem(i4).equals(part.getCNAME())) {
                        String s = String.valueOf(plistgui.getItem(i4)) + "INACTIVE";
                        plistgui.replaceItem(s, i4);
                    }
                    ++i4;
                }
                break;
            }
            case 4: {
                plist = this.VectorofGUI(plistgui);
                boolean found = false;
                int i5 = 0;
                while (i5 < plist.size()) {
                    Participant partc = (Participant)plist.elementAt(i5);
                    if (partc.getCNAME().equals(part.getCNAME())) {
                        found = true;
                        break;
                    }
                    ++i5;
                }
                if (!found) break;
                String s = String.valueOf(part.getCNAME()) + "INACTIVE";
                int j2 = 0;
                while (j2 < plistgui.getItemCount()) {
                    if (plistgui.getItem(j2).equals(s)) {
                        plistgui.replaceItem(part.getCNAME(), j2);
                        break block2;
                    }
                    ++j2;
                }
                break;
            }
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e2) {
            int i2 = 0;
            while (i2 < ParticipantListWindow.this.children.size()) {
                ((RTPParticipantWindow)ParticipantListWindow.this.children.elementAt(i2)).close();
                ++i2;
            }
            if (ParticipantListWindow.this.stats != null) {
                ParticipantListWindow.this.stats.close();
            }
            ParticipantListWindow.this.dispose();
        }

        /* synthetic */ 1() {
        }
    }
}

