/*
 * Decompiled with CFR 0.152.
 */
package netbios;

import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Random;
import netbios.InetAddressUtil;
import netbios.NBEntry;

public class NetBIOS {
    static final int NETBIOS_NS_PORT = 137;
    static final int NS_MAX_PACKET_LENGTH = 576;
    static final int RETRY_NB = 1;
    static final Random r = new Random();
    InetAddress ipaddress;
    byte[] data;
    NBEntry[] results;

    public NetBIOS(InetAddress inetAddress) {
        this.ipaddress = inetAddress;
        this.data = NetBIOS.getNBTBytes(inetAddress);
        this.results = NetBIOS.parseEntry(this.data);
    }

    public InetAddress getIPAddress() {
        return this.ipaddress;
    }

    public String getUserName() {
        String string = this.getHostName();
        String string2 = "";
        if (this.results != null) {
            int n2 = 0;
            while (n2 < this.results.length) {
                if (this.results[n2].type.equals("20")) {
                    string = this.results[n2].name;
                }
                ++n2;
            }
            if (string != null) {
                int n3 = 0;
                while (n3 < this.results.length) {
                    if (this.results[n3].type.equals("03") && !this.results[n3].name.equals(string)) {
                        string2 = this.results[n3].name;
                    }
                    ++n3;
                }
            }
        }
        return string2;
    }

    public String getHostName() {
        String string = null;
        if (this.results != null) {
            int n2 = 0;
            while (n2 < this.results.length) {
                if (this.results[n2].type.equals("20")) {
                    string = this.results[n2].name;
                }
                ++n2;
            }
        }
        return string;
    }

    public String getMACAddress() {
        int n2;
        String string = "";
        try {
            n2 = NetBIOS.binaryToInt(this.data, 56);
        }
        catch (Exception exception) {
            n2 = 0;
        }
        int n3 = n2 * 18 + 57;
        int n4 = 0;
        while (n4 < 6) {
            string = string + NetBIOS.binaryToHex(this.data, n3 + n4) + "-";
            ++n4;
        }
        return string.substring(0, string.length() - 1).toUpperCase();
    }

    public static InetAddress resolveHost(String string) {
        return NetBIOS.genAddress(string, (byte)32);
    }

    public static InetAddress resolveUser(String string) {
        return NetBIOS.genAddress(string, (byte)3);
    }

    public static String getHostName(InetAddress inetAddress) {
        NBEntry[] nBEntryArray = NetBIOS.getNBTStatus(inetAddress);
        String string = null;
        if (nBEntryArray != null) {
            int n2 = 0;
            while (n2 < nBEntryArray.length) {
                if (nBEntryArray[n2].type.equals("20")) {
                    string = nBEntryArray[n2].name;
                }
                ++n2;
            }
        }
        return string;
    }

    public static String getMACAddress(InetAddress inetAddress) {
        String string = "";
        byte[] byArray = NetBIOS.getNBTBytes(inetAddress);
        int n2 = NetBIOS.binaryToInt(byArray, 56);
        int n3 = n2 * 18 + 57;
        int n4 = 0;
        while (n4 < 6) {
            string = string + NetBIOS.binaryToHex(byArray, n3 + n4) + "-";
            ++n4;
        }
        return string.substring(0, string.length() - 1).toUpperCase();
    }

    public static String getUserName(InetAddress inetAddress) {
        NBEntry[] nBEntryArray = NetBIOS.getNBTStatus(inetAddress);
        String string = NetBIOS.getHostName(inetAddress);
        String string2 = "";
        if (nBEntryArray != null) {
            int n2 = 0;
            while (n2 < nBEntryArray.length) {
                if (nBEntryArray[n2].type.equals("20")) {
                    string = nBEntryArray[n2].name;
                }
                ++n2;
            }
            if (string != null) {
                int n3 = 0;
                while (n3 < nBEntryArray.length) {
                    if (nBEntryArray[n3].type.equals("03") && !nBEntryArray[n3].name.equals(string)) {
                        string2 = nBEntryArray[n3].name;
                    }
                    ++n3;
                }
            }
        }
        return string2;
    }

    public static NBEntry[] getNBTStatus(InetAddress inetAddress) {
        if (inetAddress != null) {
            byte[] byArray = new byte[2];
            r.nextBytes(byArray);
            byte[] byArray2 = new byte[50];
            byArray2[0] = byArray[0];
            byArray2[1] = byArray[1];
            byArray2[2] = 1;
            byArray2[3] = 0;
            byArray2[5] = 1;
            NetBIOS.compressName("*", (byte)0, (byte)0, byArray2, 12);
            byArray2[47] = 33;
            byArray2[49] = 1;
            try {
                byte[] byArray3 = NetBIOS.getResponse(inetAddress, byArray2);
                if (NetBIOS.verifyResponse(byArray3, byArray2)) {
                    return NetBIOS.parseEntry(byArray3);
                }
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private static byte[] getNBTBytes(InetAddress inetAddress) {
        if (inetAddress != null) {
            byte[] byArray = new byte[2];
            r.nextBytes(byArray);
            byte[] byArray2 = new byte[50];
            byArray2[0] = byArray[0];
            byArray2[1] = byArray[1];
            byArray2[2] = 1;
            byArray2[3] = 0;
            byArray2[5] = 1;
            NetBIOS.compressName("*", (byte)0, (byte)0, byArray2, 12);
            byArray2[47] = 33;
            byArray2[49] = 1;
            try {
                byte[] byArray3 = NetBIOS.getResponse(inetAddress, byArray2);
                if (NetBIOS.verifyResponse(byArray3, byArray2)) {
                    return byArray3;
                }
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private static NBEntry[] parseEntry(byte[] byArray) {
        try {
            int n2 = NetBIOS.binaryToInt(byArray, 56);
            NBEntry[] nBEntryArray = new NBEntry[n2];
            int n3 = 0;
            while (n3 < n2) {
                nBEntryArray[n3] = new NBEntry();
                nBEntryArray[n3].name = NetBIOS.binaryToString(byArray, 57 + n3 * 18, 15);
                int n4 = nBEntryArray[n3].name.indexOf(" ");
                nBEntryArray[n3].name = nBEntryArray[n3].name.substring(0, n4);
                nBEntryArray[n3].type = NetBIOS.binaryToHex(byArray, 72 + n3 * 18);
                ++n3;
            }
            return nBEntryArray;
        }
        catch (Exception exception) {
            return new NBEntry[0];
        }
    }

    private static InetAddress genAddress(String string, byte by2) {
        byte[] byArray = new byte[2];
        r.nextBytes(byArray);
        byte[] byArray2 = new byte[50];
        byArray2[0] = byArray[0];
        byArray2[1] = byArray[1];
        byArray2[2] = 1;
        byArray2[3] = 16;
        byArray2[5] = 1;
        NetBIOS.compressName(string, by2, (byte)32, byArray2, 12);
        byArray2[47] = 32;
        byArray2[49] = 1;
        try {
            byte[] byArray3 = NetBIOS.getResponse(InetAddressUtil.getLocalBroadcast(), byArray2);
            if (NetBIOS.verifyResponse(byArray3, byArray2)) {
                return InetAddressUtil.byteToInetAddress(byArray3, 58);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean verifyResponse(byte[] byArray, byte[] byArray2) {
        return byArray[0] == byArray2[0] && byArray[1] == byArray2[1] && byArray[45] == 0 && byArray[47] == byArray2[47] && byArray[49] == byArray2[49];
    }

    private static byte[] getResponse(InetAddress inetAddress, byte[] byArray) {
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, 137);
        byte[] byArray2 = new byte[576];
        DatagramPacket datagramPacket2 = new DatagramPacket(byArray2, byArray2.length);
        try {
            DatagramSocket datagramSocket = new DatagramSocket();
            datagramSocket.setSoTimeout(100);
            int n2 = 0;
            while (true) {
                datagramSocket.send(datagramPacket);
                try {
                    datagramSocket.receive(datagramPacket2);
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (n2 == 1) {
                        return null;
                    }
                    ++n2;
                    continue;
                }
                break;
            }
            return byArray2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void compressName(String string, byte by2, byte by3, byte[] byArray, int n2) {
        char c2;
        byArray[n2] = 32;
        ++n2;
        int n3 = 0;
        while (n3 < 15) {
            c2 = n3 < string.length() ? Character.toUpperCase(string.charAt(n3)) : (char)by3;
            byArray[n2] = (byte)((c2 >> 4 & 0xF) + 65);
            byArray[++n2] = (byte)((c2 & 0xF) + 65);
            ++n2;
            ++n3;
        }
        c2 = (char)by2;
        byArray[n2] = (byte)((c2 >> 4 & 0xF) + 65);
        byArray[++n2] = (byte)((c2 & 0xF) + 65);
        byArray[++n2] = 0;
    }

    private static String binaryToHex(byte[] byArray, int n2) {
        try {
            String string = Integer.toHexString(byArray[n2]);
            if (string.length() == 8) {
                string = string.substring(6, 8);
            } else if (string.length() == 1) {
                string = "0" + string;
            }
            return string;
        }
        catch (Exception exception) {
            return "0x00";
        }
    }

    private static int binaryToInt(byte[] byArray, int n2) {
        return Integer.decode("0x" + NetBIOS.binaryToHex(byArray, n2));
    }

    private static String binaryToString(byte[] byArray, int n2, int n3) {
        String string = "";
        int n4 = n2;
        while (n4 < n2 + n3) {
            char c2 = (char)NetBIOS.binaryToInt(byArray, n4);
            string = string + c2;
            ++n4;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println(NetBIOS.resolveHost("DECC"));
    }
}

