#include <stdio.h>
#define VERSION "convdir version 11.1 (c) GPL2 may. 1999 HNM Dijkema"

int segment(FILE *in,FILE *outh,FILE *outc,char *dir);
int dash(char *line);
int isReturn(char c);
int emptyline(char *line);
int function(char *line);
int space(char c);
#define filledline(l)  !emptyline(l)
#define strincmp(s1,s2,l)		strncasecmp(s1,s2,l)

static char SEGMENT[102400];
static char line[1024];
static int  lineno=0,SEGPOS;

char *FGETS(char *line,int len,FILE *f);

int main(int argc,char *argv[])
{
FILE *in,*outh,*outc;
char *dir=argv[1],*dirinfo=argv[4];
char DIR[100];
int i;

  if (argc!=5) {
    fprintf(stderr,"usage: convdir <directory> <unedifact dir in> <TAG begin pos (K=0,1,...)> <directory info>\n\n"); 
    exit(1);
  }

  in=fopen(argv[2],"rt");
  if (in==NULL) {
    fprintf(stderr,"Can't open %s for reading\n",argv[2]);
    exit(1);
  }
  sprintf(line,"%s.h",argv[1]);
  outh=fopen(line,"wt");
  if (outh==NULL) {
    fprintf(stderr,"Can't open %s.h include file for writing\n",argv[1]); 
    exit(1);
  }
  sprintf(line,"%s.c",argv[1]);
  outc=fopen(line,"wt");
  if (outc==NULL) {
    fprintf(stderr,"Can't open %s.c (include) file for writing\n",argv[1]); 
    exit(1);
  }

  SEGPOS=atoi(argv[3]);
  strcpy(DIR,dir);
  for(i=0;DIR[i]!='\0';i++) { if (DIR[i]=='.') { DIR[i]='_'; } }

  printf("directory %s - generating: %s.h, segpos = %d\n",dir,dir,SEGPOS);

  fprintf(outh,"/* directory   : %s */\n",dir);
  fprintf(outh,"/* generated by: %s */\n",VERSION);
  fprintf(outh,"#ifndef __%s_H\n",DIR);
  fprintf(outh,"#define __%s_H\n",DIR);

  fprintf(outc,"#include <%s.h>\n",dir);
  fprintf(outc,"char *info%s(void) { return \"%s\"; }\n",DIR,dirinfo); 
  fprintf(outc,"int dir%s(int TAG,char *tag,FILE *F,\n",DIR);
  fprintf(outc,"        char plus,char colon,char seg_end,char lit,\n");
  fprintf(outc,"        int uc,int at,int atm)\n"); 
  fprintf(outc,"{\n"); 
  fprintf(outc,"  switch(TAG) {\n"); 

  while(FGETS(line,1023,in)!=NULL && !dash(line));
  if (dash(line)) {
    while(segment(in,outh,outc,DIR));
  }

  fprintf(outh,"#endif\n");

  fprintf(outc,"   default: return 0;\n");
  fprintf(outc,"  }\n}\n\n");

  fclose(in);
  fclose(outh);
  fclose(outc);
return 0;
}


int segment(FILE *in,FILE *outh,FILE *outc,char *dir)
{
char TAG[4],DEF[1023],sep,type;
int  ingroup,len,i,k,ln;


  if (FGETS(line,1023,in)==NULL) { return 0; }
  while (emptyline(line)) { 
    if (FGETS(line,1023,in)==NULL) { return 0; } /* there should be a tag now! */
  }

  /*for(k=0;line[k]!='\n' && (line[k]<'A' || line[k]>'Z');k++);*/
  k=SEGPOS;
  /*printf("%s",&line[k]);*/
  TAG[0]=line[k];TAG[1]=line[k+1];TAG[2]=line[k+2];TAG[3]='\0';

  /* Skip the function:/note: part */

  while (!function(line)) {
    if (FGETS(line,1023,in)==NULL) { return 0; }
  }
  while (filledline(line)) {
    if (FGETS(line,1023,in)==NULL) { return 0; }
  }
  while(emptyline(line)) {
    if (FGETS(line,1023,in)==NULL) { return 0; }
  }

  /* now we should be just at the first field or group */

  sprintf(SEGMENT,"%s+",TAG);

  ingroup=0;

  while(!dash(line)) {
    DEF[0]='\0';

    while(space(line[k]) && space(line[k+1]) && !emptyline(line) && !dash(line)) {
      if (FGETS(line,1023,in)==NULL) { return 0; }  
    }
    if (emptyline(line) || dash(line)) {
      ingroup=0;
    }
    else {
      /*printf("%s",line);*/
      if (ingroup) {
        sep=':';
      }
      else {
        sep='+';
      }
      if ((line[k]>='A' && line[k]<='Z') || (line[k+1]>='A' && line[k+1]<='Z')) { 
        ingroup=1;
        if (FGETS(line,1023,in)==NULL) { return 0; }  
				/* now at first segment after group */
	while(emptyline(line) || (space(line[k]) && space(line[k+1]))) {
          if (FGETS(line,1023,in)==NULL) { return 0; }  
	}
      }

      ln=strlen(line);

      for(i=ln-1;line[i]<'0' || line[i]>'9';i--);
      for(;line[i]>='0' && line[i]<='9';i--);
      len=atoi(&line[i+1]);
      for(;line[i]=='.' || line[i]=='a' || line[i]=='n';i--);
      type=toupper(line[i+1]);
      if (type!='A' && type!='N') {
	printf("Unknown type at line %d\n",lineno);
      }

      sprintf(DEF,"%c%c%d",sep,type,len);
      strcat(SEGMENT,DEF); 
    }

    if (FGETS(line,1023,in)==NULL) { return 0; }  
  }
  strcat(SEGMENT,"'"); 

  fprintf(outh,"#define TAG_%s_%s \\\n",dir,TAG);
  for(i=0;strlen(&SEGMENT[i])>=60;i+=60) {char c;
    c=SEGMENT[i+60];
    SEGMENT[i+60]='\0';
    fprintf(outh,"        \"%s\" \\\n",&SEGMENT[i]);
    SEGMENT[i+60]=c;
  }
  fprintf(outh,"        \"%s\" \n",&SEGMENT[i]);

  {int T;
    T=(TAG[0]-'A')+((((TAG[2]-'A')<<5)+TAG[1]-'A')<<5);
    fprintf(outc,"    case %5d: tag[2]=read_tag(TAG_%s_%s,F,plus,colon,seg_end,\n"
		 "                         lit,uc,at,atm);\n"
		 "                tag[0]=0;tag[1]=0;\n"
		 "                return 1;\n",
		 T,dir,TAG
            );
   }

return 1;
}

char *FGETS(char *line,int len,FILE *f)
{
char *a;
  a=fgets(line,len,f);
  if (a!=NULL) lineno+=1;
return a;
}

int dash(char *line)
{
return line[0]=='' || (line[0]=='-' && line[1]=='-');
}

int isReturn(char c)
{
return c=='\n' || c==26;  /* Ctrl Z */
}

int emptyline(char *line)
{
  while(line[0]!='\0' && 
	(line[0]==' ' || line[0]=='\n' || line[0]=='\t') || line[0]==26) {
   line+=1; 
  }
return line[0]=='\0';
}

int function(char *line)
{
   while(line[0]==' ') { line++; }
return strincmp(line,"function:",9)==0; 
}

int space(char c)
{
return c==' ' || c=='\t';
}
