/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import stec.iws.ArchiveIOHandler;
import stec.iws.FileIOHandler;
import stec.iws.IOHandler;
import stec.iws.IOManager;
import stec.iws.iws;
import stec.lang.DString;

public class Utils {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";

    private static final String concat(String string, String string2, char c) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.endsWith("/") || string.endsWith("\\")) {
            if (string2.startsWith("/") || string2.startsWith("\\")) {
                stringBuffer.append(string2.substring(1));
            } else {
                stringBuffer.append(string2);
            }
        } else if (string2.startsWith("/") || string2.startsWith("\\")) {
            stringBuffer.append(string2);
        } else {
            stringBuffer.append(c);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static final Hashtable concatParameters(Hashtable hashtable, Hashtable hashtable2) {
        Hashtable hashtable3 = (Hashtable)hashtable.clone();
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String[] stringArray;
            String string = (String)enumeration.nextElement();
            String[] stringArray2 = (String[])hashtable2.get(string);
            if (hashtable3.containsKey(string)) {
                String[] stringArray3 = (String[])hashtable3.get(string);
                stringArray = new String[stringArray3.length + stringArray2.length];
                System.arraycopy(stringArray3, 0, stringArray, 0, stringArray3.length);
                System.arraycopy(stringArray2, 0, stringArray, stringArray3.length, stringArray2.length);
            } else {
                stringArray = stringArray2;
            }
            hashtable3.put(string, stringArray);
        }
        return hashtable3;
    }

    public static final String concatPaths(String string, String string2) {
        return Utils.concat(string, string2, File.separatorChar);
    }

    public static final String concatURIs(String string, String string2) {
        return Utils.concat(string, string2, '/');
    }

    public static final Hashtable decodeParameters(String string) {
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        int n = DString.dcount(string, "&");
        int n2 = 0;
        while (n2 < n) {
            String string2 = DString.extract(string, "&", n2);
            int n3 = string2.indexOf(61);
            if (n3 != -1) {
                String[] stringArray;
                String string3 = string2.substring(0, n3);
                string2 = string2.substring(n3 + 1);
                if (hashtable.containsKey(string3)) {
                    String[] stringArray2 = (String[])hashtable.get(string3);
                    stringArray = new String[stringArray2.length + 1];
                    System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                    stringArray[stringArray2.length] = string2;
                } else {
                    stringArray = new String[]{string2};
                }
                hashtable.put(string3, stringArray);
            }
            ++n2;
        }
        return hashtable;
    }

    public static final String decodeURL(String string) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        stringBuffer.ensureCapacity(string.length());
        while (n < string.length()) {
            char c;
            int n2 = n;
            while (n2 < string.length()) {
                c = string.charAt(n2);
                if (c == '+' || c == '%') break;
                ++n2;
            }
            if (n2 > n) {
                stringBuffer.append(string.substring(n, n2));
                n = n2;
            }
            if (n >= string.length()) break;
            c = string.charAt(n);
            if (c == '+') {
                stringBuffer.append(' ');
                ++n;
                continue;
            }
            if (c != '%') continue;
            try {
                stringBuffer.append((char)Integer.parseInt(string.substring(n + 1, n + 3), 16));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid hexadecimal value: " + string.substring(n + 1, n + 3));
            }
            n += 3;
        }
        return stringBuffer.toString();
    }

    public static final String encodeCookie(Cookie cookie) {
        StringBuffer stringBuffer = new StringBuffer(cookie.getName());
        stringBuffer.append('=');
        stringBuffer.append(cookie.getValue());
        if (cookie.getMaxAge() >= 0) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE, dd-MMM-yyyy kk:mm:ss zz", Locale.US);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            stringBuffer.append("; expires=");
            stringBuffer.append(simpleDateFormat.format(new Date(System.currentTimeMillis() + (long)cookie.getMaxAge() * 1000L)));
        }
        if (cookie.getDomain() != null) {
            stringBuffer.append("; domain=");
            stringBuffer.append(cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            stringBuffer.append("; path=");
            stringBuffer.append(cookie.getPath());
        }
        if (cookie.getSecure()) {
            stringBuffer.append("; secure");
        }
        return stringBuffer.toString();
    }

    public static final String encodeParameters(Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append(string2);
            stringBuffer.append('&');
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static final String encodeURL(String string) {
        if (string == null) {
            return null;
        }
        return URLEncoder.encode(string);
    }

    public static Cookie extractCookie(Vector vector, String string) {
        if (vector == null) {
            return null;
        }
        int n = 0;
        while (n < vector.size()) {
            Cookie cookie = (Cookie)vector.elementAt(n);
            if (string.equals(cookie.getName())) {
                return cookie;
            }
            ++n;
        }
        return null;
    }

    public static Cookie extractCookie(Cookie[] cookieArray, String string) {
        if (cookieArray == null) {
            return null;
        }
        int n = 0;
        while (n < cookieArray.length) {
            if (string.equalsIgnoreCase(cookieArray[n].getName())) {
                return cookieArray[n];
            }
            ++n;
        }
        return null;
    }

    public static String getArgs(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getQueryString();
        if (string == null) {
            return httpServletRequest.getPathTranslated();
        }
        int n = string.indexOf(61);
        if (n == -1) {
            StringBuffer stringBuffer = new StringBuffer(httpServletRequest.getPathTranslated());
            stringBuffer.append('+');
            stringBuffer.append(string);
            return Utils.decodeURL(stringBuffer.toString());
        }
        String string2 = string.substring(0, n);
        if ((n = string2.lastIndexOf(38)) == -1) {
            return httpServletRequest.getPathTranslated();
        }
        StringBuffer stringBuffer = new StringBuffer(httpServletRequest.getPathTranslated());
        stringBuffer.append('+');
        stringBuffer.append(string.substring(0, n));
        return Utils.decodeURL(stringBuffer.toString());
    }

    protected static final String getCanonicalPath(String string) throws IOException {
        String string2;
        if (Utils.isAbsolute(string)) {
            string2 = string;
        } else {
            String string3 = Utils.parseDrive(string);
            if (string3.length() == 0) {
                string3 = ".";
            }
            string2 = Utils.parsePath(string);
            File file = new File(string3);
            String string4 = file.getCanonicalPath();
            string2 = Utils.concat(string4, string2, File.separatorChar);
        }
        if (File.separatorChar == '\\' && string2.length() > 1 && Character.isLetter(string2.charAt(0)) && string2.charAt(1) == ':') {
            string2 = String.valueOf(Character.toUpperCase(string2.charAt(0))) + string2.substring(1);
        }
        return Utils.normalizePath(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getItem(File file) throws IOException {
        String string;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            string = Utils.getItem(bufferedInputStream);
            Object var4_3 = null;
            if (bufferedInputStream == null) return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (bufferedInputStream == null) throw throwable;
            ((FilterInputStream)bufferedInputStream).close();
            throw throwable;
        }
        ((FilterInputStream)bufferedInputStream).close();
        return string;
    }

    public static String getItem(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStream.read(byArray)) != -1) {
            stringBuffer.append(new String(byArray, 0, n));
        }
        return stringBuffer.toString();
    }

    public static String getItem(String string) throws IOException {
        return Utils.getItem(IOManager.getHandler(iws.basedir, string));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getItem(IOHandler iOHandler) throws IOException {
        String string;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(iOHandler.getInputStream());
            string = Utils.getItem(bufferedInputStream);
            Object var4_3 = null;
            if (bufferedInputStream == null) return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (bufferedInputStream == null) throw throwable;
            ((FilterInputStream)bufferedInputStream).close();
            throw throwable;
        }
        ((FilterInputStream)bufferedInputStream).close();
        return string;
    }

    public static String getParameters(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getQueryString();
        if (string == null) {
            return null;
        }
        int n = string.indexOf(61);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        if ((n = string2.lastIndexOf(38)) == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static IOHandler getRootHandler(String string) throws IOException {
        String string2;
        Object object = iws.hosts.get(string.toLowerCase());
        if (object == null && (object = iws.hosts.get("*")) == null) {
            object = "./wwwroot";
        }
        IOHandler iOHandler = Utils.isAbsolute(string2 = (String)object) ? (iws.inArchive ? new ArchiveIOHandler(string2) : new FileIOHandler(string2)) : IOManager.getHandler(iws.basedir, string2);
        return iOHandler;
    }

    protected static final boolean isAbsolute(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (string.charAt(0) == '/' || string.charAt(0) == '\\') {
            return true;
        }
        return File.separatorChar == '\\' && string.length() > 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':' && (string.charAt(2) == '/' || string.charAt(2) == '\\');
    }

    public static Hashtable load(String string) throws IOException {
        return Utils.load(string, false);
    }

    /*
     * Unable to fully structure code
     */
    protected static Hashtable load(String var0, boolean var1_1) throws IOException {
        var2_2 = IOManager.getHandler(iws.basedir, var0);
        if (!var2_2.exists()) {
            throw new FileNotFoundException("File was not found: " + var0);
        }
        var3_3 = null;
        try {
            block8: {
                block7: {
                    var3_3 = new BufferedInputStream(var2_2.getInputStream());
                    var7_4 = new Properties();
                    var7_4.load(var3_3);
                    var8_5 = new Hashtable<String, String>();
                    var11_6 = var7_4.keys();
                    if (var0 != "./config/aliases.ini" && var0 != "./config/resources.ini") break block7;
                    while (var11_6.hasMoreElements()) {
                        var9_7 = (String)var11_6.nextElement();
                        var10_10 = (String)var7_4.get(var9_7);
                        var8_5.put(var9_7.replace('\\', '/'), var10_10);
                    }
                    break block8;
                }
                if (var0 != "./config/hosts.ini" || var1_1) ** GOTO lbl32
                while (var11_6.hasMoreElements()) {
                    var9_8 = (String)var11_6.nextElement();
                    var10_11 = (String)var7_4.get(var9_8);
                    var8_5.put(var9_8.toLowerCase(), var10_11);
                }
                break block8;
lbl-1000:
                // 1 sources

                {
                    var9_9 = (String)var11_6.nextElement();
                    var10_12 = (String)var7_4.get(var9_9);
                    var8_5.put(var9_9, var10_12);
lbl32:
                    // 2 sources

                    ** while (var11_6.hasMoreElements())
                }
            }
            var4_13 = var8_5;
            var6_14 = null;
            ** if (var3_3 == null) goto lbl39
        }
        catch (Throwable var5_16) {
            block9: {
                var6_15 = null;
                if (var3_3 == null) break block9;
                var3_3.close();
            }
            throw var5_16;
        }
lbl-1000:
        // 1 sources

        {
            var3_3.close();
        }
lbl39:
        // 2 sources

        return var4_13;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static String[] loadEnv() throws Exception {
        Object[] objectArray;
        String string = System.getProperty("env");
        if (string == null) {
            return new String[0];
        }
        IOHandler iOHandler = IOManager.getHandler(iws.basedir, string);
        if (!iOHandler.exists()) {
            return new String[0];
        }
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new InputStreamReader(iOHandler.getInputStream()));
            Vector<String> vector = new Vector<String>();
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf(61);
                if (n <= 0) continue;
                vector.addElement(string2);
            }
            Object[] objectArray2 = new String[vector.size()];
            vector.copyInto(objectArray2);
            objectArray = objectArray2;
            Object var5_8 = null;
            if (bufferedReader == null) return objectArray;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return objectArray;
    }

    public static final Hashtable mergeParameters(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String[] stringArray;
            String string = (String)enumeration.nextElement();
            String[] stringArray2 = (String[])hashtable2.get(string);
            if (hashtable.containsKey(string)) {
                String[] stringArray3 = (String[])hashtable.get(string);
                stringArray = new String[stringArray3.length + stringArray2.length];
                System.arraycopy(stringArray3, 0, stringArray, 0, stringArray3.length);
                System.arraycopy(stringArray2, 0, stringArray, stringArray3.length, stringArray2.length);
            } else {
                stringArray = stringArray2;
            }
            hashtable.put(string, stringArray);
        }
        return hashtable;
    }

    protected static String normalizePath(String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        if (File.separatorChar == '\\') {
            stringBuffer.append(Utils.parseDrive(string));
            string2 = Utils.parsePath(string);
        } else {
            string2 = string;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        if (string2.length() > 0) {
            int n;
            String string3;
            String string4;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "/\\");
            if (string2.charAt(0) != '/' && string2.charAt(0) != '\\' && stringTokenizer.hasMoreTokens() && !(string4 = stringTokenizer.nextToken()).equals(".")) {
                if (string4.equals("..")) {
                    string3 = stringBuffer2.toString();
                    n = string3.lastIndexOf(File.separatorChar);
                    if (n == -1) {
                        n = 0;
                    }
                    stringBuffer2.setLength(n);
                } else {
                    stringBuffer2.append(string4);
                }
            }
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                if (string4.equals(".")) continue;
                if (string4.equals("..")) {
                    string3 = stringBuffer2.toString();
                    n = string3.lastIndexOf(File.separatorChar);
                    if (n == -1) {
                        n = 0;
                    }
                    stringBuffer2.setLength(n);
                    continue;
                }
                stringBuffer2.append(File.separatorChar);
                stringBuffer2.append(string4);
            }
        }
        if (stringBuffer2.length() == 0) {
            stringBuffer.append(File.separatorChar);
        } else {
            stringBuffer.append(stringBuffer2.toString());
        }
        return stringBuffer.toString();
    }

    protected static String normalizeURI(String string) {
        int n;
        String string2;
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() == 0) {
            return "/";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/\\");
        if (string.charAt(0) != '/' && string.charAt(0) != '\\' && stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equals(".")) {
            if (string3.equals("..")) {
                string2 = stringBuffer.toString();
                n = string2.lastIndexOf(47);
                if (n == -1) {
                    n = 0;
                }
                stringBuffer.setLength(n);
            } else {
                stringBuffer.append(string3);
            }
        }
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string3.equals(".")) continue;
            if (string3.equals("..")) {
                string2 = stringBuffer.toString();
                n = string2.lastIndexOf(47);
                if (n == -1) {
                    n = 0;
                }
                stringBuffer.setLength(n);
                continue;
            }
            stringBuffer.append('/');
            stringBuffer.append(string3);
        }
        if (stringBuffer.length() == 0) {
            return "/";
        }
        return stringBuffer.toString();
    }

    public static final String parseCharacterEncoding(String string) {
        if (string == null) {
            return "ISO-8859-1";
        }
        int n = string.indexOf("charset=");
        if (n == -1) {
            return "ISO-8859-1";
        }
        String string2 = string.substring(n + 8);
        if ((n = string2.indexOf(59)) == -1) {
            return string2;
        }
        return string2.substring(0, n);
    }

    public static final Cookie[] parseCookieHeader(String string) {
        Vector<Cookie> vector = new Vector<Cookie>();
        if (string != null) {
            int n = DString.dcount(string, "; ");
            int n2 = 0;
            while (n2 < n) {
                String string2;
                String string3;
                String string4 = DString.extract(string, "; ", n2);
                int n3 = string4.indexOf(61);
                if (n3 == -1) {
                    string3 = string4;
                    string2 = "";
                } else {
                    string3 = string4.substring(0, n3);
                    string2 = string4.substring(n3 + 1);
                }
                vector.addElement(new Cookie(string3, string2));
                ++n2;
            }
        }
        Object[] objectArray = new Cookie[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected static long parseDate(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        try {
            Date date = simpleDateFormat.parse(string);
            return date.getTime();
        }
        catch (Exception exception) {
            simpleDateFormat = new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz");
            try {
                Date date = simpleDateFormat.parse(string);
                return date.getTime();
            }
            catch (Exception exception2) {
                simpleDateFormat = new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy");
                try {
                    Date date = simpleDateFormat.parse(string);
                    return date.getTime();
                }
                catch (Exception exception3) {
                    throw new IllegalArgumentException(string);
                }
            }
        }
    }

    protected static final String parseDrive(String string) {
        if (File.separatorChar == '\\' && string.length() > 1 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':') {
            return string.substring(0, 2);
        }
        return "";
    }

    protected static final String parsePath(String string) {
        if (File.separatorChar == '\\' && string.length() > 1 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':') {
            return string.substring(2);
        }
        return string;
    }

    public static int readLine(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        int n3 = n + n2;
        if (n3 > byArray.length) {
            n3 = byArray.length;
        }
        int n4 = 0;
        int n5 = n;
        while (n5 < n3) {
            int n6 = inputStream.read();
            if (n6 == -1) break;
            ++n4;
            byArray[n5] = (byte)n6;
            if (n6 == 10) break;
            ++n5;
        }
        if (n4 > 0) {
            return n4;
        }
        return -1;
    }

    protected static String translateAliases(String string, String string2) throws IOException {
        String string3 = string2;
        while (true) {
            String string4;
            Object v;
            if ((v = iws.aliases.get(string3)) != null && (string4 = (String)v).startsWith("file:")) {
                String string5 = DString.change(string4.substring("file:".length()), "$wwwroot", Utils.getRootHandler(string).getCanonicalPath());
                String string6 = string2.substring(string3.length());
                return Utils.concat(string5, string6, File.separatorChar);
            }
            if (string3.endsWith("/")) {
                string3 = string3.substring(0, string3.length() - 1);
                continue;
            }
            int n = string3.lastIndexOf(47);
            if (n == -1) {
                return null;
            }
            string3 = string3.substring(0, n + 1);
        }
    }

    protected static String translatePath(String string, String string2) throws IOException {
        IOHandler iOHandler;
        IOHandler iOHandler2 = null;
        String string3 = Utils.normalizeURI(string2);
        String string4 = Utils.translateAliases(string, string3);
        if (string4 != null) {
            if (Utils.isAbsolute(string4)) {
                string4 = Utils.normalizeURI(string4);
                return Utils.getCanonicalPath(string4);
            }
            string3 = string4;
        }
        iOHandler2 = (iOHandler = Utils.getRootHandler(string)) instanceof ArchiveIOHandler ? new ArchiveIOHandler(iOHandler, string3) : new FileIOHandler(iOHandler, string3);
        return iOHandler2.getCanonicalPath();
    }
}

