package org.phoenix.util;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

public class TableSorter extends AbstractTableModel implements TableModelListener {
	protected TableModel model;
	Vector data = new Vector();
	boolean sorted = false;
	int column = -1;
	boolean descending = false;	
	public TableSorter(TableModel model) {
		this.model = model;
		model.addTableModelListener(this);
	}
	public void setSortColumn(int col, boolean down) {
		sorted = true;
		column = col;
		descending = down;
		Vector oldData = data;
		data = new Vector();
		if (model.getRowCount() > 0) {
			for (int i = 0; i < model.getRowCount(); i++) {
				if (oldData != null && oldData.size() == model.getRowCount()) {
					TableElement old = (TableElement) oldData.elementAt(i);
					data.addElement(new TableElement(old.getIndex(), model.getValueAt(old.getIndex(), col)));
				} else {
					data.addElement(new TableElement(i, model.getValueAt(i, col)));
				}
			}
			Collections.sort(data);
			if (!down) {
				Collections.reverse(data);
			}
		}
	}
	public String getColumnName(int i) {
		return model.getColumnName(i);
	}
	public int getSortedColumn() {
		int flag = -1;
		if (sorted) {
			flag = column;
		}
		return flag; 
	}
	public boolean isDescending() {
		if (sorted) {
			return descending;
		}
		return false;
	}
	public int getColumnCount() {
		return model.getColumnCount();
	}
	public int getRowCount() {
		if (data.size() != model.getRowCount()) {
			if (column != -1) {
				setSortColumn(getSortedColumn(), isDescending());
			} else {
				return model.getRowCount();
			}
		}
		return model.getRowCount();
	}
	public Object getValueAt(int row, int col) {
		if (!sorted) {
			return model.getValueAt(row, col);
		}
		TableElement temp = (TableElement) data.elementAt(row);
		return model.getValueAt(temp.getIndex(), col);
	}
	public void addSorterListener(JTable table) {
		final JTable viewTable = table;
		MouseAdapter mouseListener = new MouseAdapter() {
			public void mouseClicked(MouseEvent e) {
				int viewColumn = viewTable.getColumnModel().getColumnIndexAtX(e.getX());
				int column = viewTable.convertColumnIndexToModel(viewColumn);
				if (getSortedColumn() == column) {
					setSortColumn(column, !isDescending());
				} else {
					setSortColumn(column, true);
				}
			}
		};
		JTableHeader th = table.getTableHeader(); 
		th.addMouseListener(mouseListener);
	}
	public void tableChanged(TableModelEvent e) {
		fireTableChanged(e);
	}
}