/* ----------------------------------------------------------------------- *
 *                                                                         *
 *    (C) Copyright 1996 by:  aiNet                                        *
 *										Trubarjeva 42, SI-3000 Celje                 *
 *										Europe, Slovenia                             *
 *     All Rights Reserved                                                 *
 *                                                                         *
 *     Subject: C code for single vector prediction.                       *
 *     File:    T1Static - The XOR problem created by XOR.CSV file         *
 *                                                                         *
 * ----------------------------------------------------------------------- */

/*--------------------------------------------------------------------------
	Here it will be shown how we can colve the XOR problem using
	aiNet C functions

	The XOR problem:
	================
		Number of model vectors: 4
			 Number of variables: 3
	 Number of input variables: 3
		 Any discrete variables: NONE

		Model vectors:  Inp,Inp,Out
				  row 1:  1,  1,  0
				  row 2:  1,  0,  1
				  row 3:  0,  1,  1
				  row 4:  0,  0,  0

	Test vectors (vectors which will be used in prediction) together with
	penalty coefficient and penalty method.

		 Prediction vectors:  Inp  Inp  Out
						  prd 1:  0.9  0.1  ??
						  prd 2:  0.1  0.9  ??
						  prd 3:  0.2  0.2  ??
						  prd 4:  0.7  0.7  ??

		 Penalty coeffcient: 0.3
		 Penalty methods: STATIC

	NOTE: Selected penalty coefficients are in no case optimal.
			They were selected randomly, to perform a few tests.
			The test results were compared with the results calculated by
			the main aiNet 1.14 application.

	--------------------------------------------------------------------------
	Results (rounded at fourth decimal):
	--------------------------------------------------------------------------

		 Penalty cefficient: 0.3
		 Penalty method:     STATIC
												  (RESULT)
		 Prediction vectors:  Inp  Inp  (  Out )
						  prd 1:  0.9  0.1  (1.0000)
						  prd 2:  0.1  0.9  (1.0000)
						  prd 3:  0.2  0.2  (0.0007)
						  prd 4:  0.7  0.7  (0.0096)

	-------------------------------------------------------------------------*/

/*
 * This file assumes that ainetxx.dll will be statically binded to exe,
 * which means that AI_STATIC_DLL_BINDING flag must be defined and
 * ainetxx.lib must be included in the linking process.
 *
 * IMPORTANT NOTE for ainet32.dll:
 * It has been reported that only Borland C++ V5.0 compiler
 * can bind ainet32.lib correctly. If you use any other compiler, you
 * should load ainet32.dll at run time; which means this example will
 * not work until you modify it. See T2RunTim.C and T3RunTim.C to find out
 * how run time binding is archived.
 */

#if !defined(__BORLANDC__)
#error Only Borland C++ v5.0 will compile this correctly.
#endif

#define AI_STATIC_DLL_BINDING
#include "ainetdll.h"

#include <stdio.h>
#include <stdlib.h>

void main()
{
	/*
	 * Here we present the simplest way to create the model. It will
	 * be read from a CSV file which was created by aiNet application.
	 */

	int i;
	int version;
	aiModel* model = NULL;
	float predict[4][3] = { { 0.9,0.1, 999 },   /* vectors to be predicted */
									{ 0.1,0.9, 999 },
									{ 0.2,0.2, 999 },
									{ 0.7,0.7, 999 } };

	/*
	 * Title
	 */

	version = aiGetVersion();
	printf( "\naiNetDLL version %i.%i! (C) Copyright by aiNet, 1996",
			  version/100, version%100 );
	printf( "\n---------------------------------------------------\n" );

	/*
	 * Register DLL
	 */

	aiRegistration( "Your registration name", "Your code" );

	/*
	 * Setup the model - read the csv file.
	 */

	model = aiCreateModelFromCSVFile( "xor.csv" );
	if(!model) {
		printf( "\nError: Something went wrong during model creation!" );
		exit(EXIT_FAILURE);
	}

	/*
	 * Output the model
	 */

	printf( "\n             Model name: aiNet DLL test 1 (XOR.CSV)" );
	printf( "\nNumber of model vectors: %i", aiGetNumberOfModelVectors(model));
	printf( "\n    Number of variables: %i", aiGetNumberOfVariables(model));
	printf( "\n         Variable names: A,   B,   A xor B" );
	printf( "\n          Discrete flag: %i,   %i,   %i",
			  aiGetDiscreteFlag(model,1),
			  aiGetDiscreteFlag(model,2),
			  aiGetDiscreteFlag(model,3) );
	for( i=1; i<=aiGetNumberOfModelVectors(model); i++ ) {
		printf( "\n\t\t\t %3.1lf, %3.1lf, %3.1lf",
				  aiGetVariable(model, i,1),
				  aiGetVariable(model, i,2),
				  aiGetVariable(model, i,3) );
	}

	/*
	 * Normalize the model
	 */

	aiNormalize(model,NORMALIZE_REGULAR);

	/*
	 * Prediction: Pen. coefficient = 0.30, Pen. method = STATIC
	 * This test has static penalty coefficient 0.30
	 */

	printf( "\n\n  Penalty coefficient: 0.30" );
	printf(   "\n       Penalty method: STATIC" );
	printf(   "\n\t A(inp), B(inp), A xor B(out)" );
	for ( i=0; i<4; i++ ) {
		aiPrediction( model, predict[i], 0.30, PENALTY_STATIC );
		printf( "\n\t%7.4f, %7.4f, %7.4f",
				  predict[i][0],predict[i][1],predict[i][2] );
	}

	/*
	 * Denormalize the model (in this case it is not necessary)
	 */

	aiDenormalize(model);

	/*
	 * We must call the aiDeleteModel function here since the model
	 * was allocated dynamicaly using the aiCreateModelFromCSVFile function.
	 */

	aiDeleteModel(model);

	printf( "\n\nEnd." );
	exit(EXIT_SUCCESS);
}

/* THE END */
