//Defs.h - various structure and type definitions

#ifndef _DEFS_H_
#	define _DEFS_H_

#include "ArbbDll.h"

#define NULL 0

#define FALSE 0
#define TRUE 1

#define PTR TRUE
#define CRS FALSE

typedef struct tagPageInfo {
	unsigned
		// nivelul paginii in (sub)arbore
		nLevel,
		// cati frati mai are
		nBros,
		// al catelea frate este 
		nCount,
		// cate noduri are
		nDim;
} TPageInfo;

// Pentru a infrumuseta operatorii.
typedef ARBBDLL_API int BOOL;

/* Tip de functie apelata de ARBB :: OnEachNode; primeste ca argument un
	pointer la nodul care se traverseaza.
*/
typedef ARBBDLL_API void ( * PFONNODE )( const class NodARBB* pNod );

/* Tip de functie apelata de ARBB :: OnEachPage; pentru aceeasi pagina pot fi
	1 sau 2 apeluri, functie de bCall 
	- TRUE - primul apel;
	- FALSE - al doilea apel
*/
typedef ARBBDLL_API void ( * PFONPAGE )( BOOL bCall );

/*	Tip de functie apelata de ARBB :: GrepSubTree pentru a vedea daca se
	opreste cuprinderea. Cat timp functia returneaza FALSE, se avanseaza cu un
	nivel. Altfel, asa ramane subarborele.
	- nLevel : nivelul curent, relativ la subarbore;
	- nNodes: numarul de noduri pe nivelul curent;
	- nPages: numarul de pagini pe nivelul curent.
*/
typedef ARBBDLL_API BOOL ( * PFONGREP ) ( unsigned nLevels, unsigned nNodes, unsigned nPages );

/*	Tip de functie apelata de ARBB :: WalkOnSnake pentru a vedea daca se
	opreste parcirgerea, daca functia returneaza TRUE.
*/
typedef ARBBDLL_API BOOL ( * PFONWALK ) ();

/* Tip de functie cu care se poate face o legatura intre pagina parinte si fiu.
	Primele doua argumente sunt coordonatele coltului corespunzator paginii
	parinte,	urmatoarele 2 sunt ale inceputului paginii care se deseneaza.
	Radacina este singura care nu are frati, deci numai pentru ea e valabil
	( ARBB :: GetComBuff () ) -> nBros == 0.
	Puteti apela operatorul de indexare [] pentru a desena, pe rand, nodurile.
*/
typedef ARBBDLL_API void ( * PFONDRAW ) ( unsigned hCoordPar, unsigned vCoordPar,
							  unsigned hCoordChild, unsigned vCoordChild );
typedef ARBBDLL_API struct tagStatus {
	unsigned long
		nInserts,
		nExtracts,
		nHitSearches,
		nMissedSearches,
		nSplits,
		nMerges,
		nLeftBorrows,
		nRightBorrows;
} TStatus;

#endif