#include "chartdir.h"

int main(int argc, char *argv[])
{
	//The data for the bar chart
	double data0[] = {100, 125, 245.78, 147, 67};
	double data1[]	= {85, 156, 179.5, 211, 123};
	double data2[]	= {97, 87, 56, 267, 157};

	//The labels for the bar chart
	const char *labels[] = {"Mon", "Tue", "Wed", "Thu", "Fri"};

	//First, create a XYChart of size 500 pixels x 320 pixels
	XYChart *c = XYChart::create(500, 320);

	//Set the plotarea rectangle to start at (100, 40) and of 
	//280 pixels in width and 240 in height
	c->setPlotArea(100, 40, 280, 240);

	//Add a legend box at (400, 100)
	c->addLegend(400, 100);

	//Add a title to the chart
	c->addTitle("Weekday Network Load");

	//Add a multiline title to the y axis. draw the title upright by setting the 
	//font angle 0 (the default is to draw the title sideways for y axis)
	c->yAxis()->setTitle("Average\nThroughput\n(MBytes\nPer Hour)")->setFontAngle(0);
	
	//Set the labels on the x axis
	c->xAxis()->setLabels(sizeof(labels) / sizeof(labels[0]), labels);

	//Add three bar layers, each represent one data set
	c->addBarLayer(sizeof(data0) / sizeof(data0[0]), data0, 0x808080ff, "Server #1", 5);
	c->addBarLayer(sizeof(data1) / sizeof(data1[0]), data1, 0x80ff0000, "Server #2", 5);
	c->addBarLayer(sizeof(data2) / sizeof(data2[0]), data2, 0x8000ff00, "Server #3", 5);

	//output the chart as a PNG file
	c->makeChart("depthbar.png");

	//destroy the chart to free up resources
	c->destroy();

	return 0;
}
