/*
 * Copyright (C) 2001 Advanced Software Engineering Limited.
 *
 * This file is part of the ChartDirector software. Usage of this file is
 * subjected to the ChartDirector license agreement. See the LICENSE.TXT
 * file that comes with the ChartDirector software release, or visit
 * Advanced Software Engineering's web site at www.advsofteng.com or 
 * email to support@advsofteng.com for information.
 *
 */
 
#ifndef XYCHART_HDR
#define XYCHART_HDR


#include "basechart.h"
#include "axis.h"
#include "barlayer.h"
#include "linelayer.h"
#include "arealayer.h"
#include "hloclayer.h"


class PlotArea
{
public :
	virtual void setBackground(int color, int altBgColor = -1, int edgeColor = LineColor) = 0;
	virtual void setBackground(const char *img, Alignment align = Center) = 0;
	virtual void setGridColor(int hGridColor, int vGridColor = Transparent) = 0;
};


class XYChart : virtual public BaseChart
{
public :
	__declspec(dllexport) static XYChart *create(int width, int height, int bgColor = BackgroundColor, 
		int edgeColor = Transparent);

	virtual YAxis *yAxis() = 0;
	virtual YAxis *yAxis2() = 0;
	virtual void syncYAxis(double slope = 1, double intercept = 0) = 0;
	virtual void setYAxisOnRight(bool b) = 0;
	virtual XAxis *xAxis() = 0;
	virtual XAxis *xAxis2() = 0;

	virtual PlotArea *setPlotArea(int x, int y, int width, int height, 
		int bgColor = Transparent, int altBgColor = -1, int edgeColor = LineColor, 
		int hGridColor = 0xc0c0c0, int vGridColor = Transparent) = 0;

	virtual Layer *addLayer(Layer *layer) = 0;
	virtual BarLayer *addBarLayer(int noOfPoints, const double *data, int color = -1, const char *name = 0, int depth = 0) = 0;
	virtual BarLayer *addBarLayer(Layer::DataCombineMethod dataCombineMethod = Layer::Side, int depth = 0) = 0;
	virtual LineLayer *addLineLayer(int noOfPoints, const double *data, int color = -1, const char *name = 0, int depth = 0) = 0;
	virtual LineLayer *addLineLayer(Layer::DataCombineMethod dataCombineMethod = Layer::Overlay, int depth = 0) = 0;
	virtual AreaLayer *addAreaLayer(int noOfPoints, const double *data, int color = -1, const char *name = 0, int depth = 0) = 0;
	virtual AreaLayer *addAreaLayer(Layer::DataCombineMethod dataCombineMethod = Layer::Stack, int depth = 0) = 0;
	virtual HLOCLayer *addHLOCLayer() = 0;
	virtual HLOCLayer *addHLOCLayer(int noOfPoints, const double *highData, const double *lowData, const double *openData, const double *closeData, 
		int color = -1) = 0;
};


#endif