<?php
include("phpchartdir.php");

#The data for the pie chart
$data = array( 25, 18, 15, 12, 8, 30, 35 );

#The labels for the pie chart
$labels = array( "Labor", "Licenses", "Taxes", "Legal", 
	"Insurance", "Facilities", "Production" );

#First, create a PieChart of size 480 pixels x 300 pixels
$c = new PieChart(480, 300);

#the center of the pie at (150, 150) and the radius to 100 pixels
$c->setPieSize(150, 150, 100);

#Add a title to the pie chart, using the font Monotype Corsiva 
#("mtcorsva") at size of 20 points. text color is deep blue (0x000080)
$c->addTitle("Project Cost Breakdown", "mtcorsva.ttf", 20, 0x000080);

#Draw the pie in 3D
$c->set3D();

#add a legend box using the font Times New Romans Bold ("timesbd.ttf") 
#at size of 12 points. Set the background color of the legend box to 
#light gray (0xd0d0d0), and its border to blue (0x0000ff).
$legendBox = $c->addLegend(340, 80, 1, "timesbd.ttf", 12);
$legendBox->setBackground(0xd0d0d0, 0x0000ff);

#set the default font for all sector labels to Impact ("impact.ttf") 
#at size of 8 points. Font color is set to dark green (0x008000).
$c->setLabelStyle("impact.ttf", 8, 0x008000);

#the pie data and the pie labels
$c->setData($data, $labels);

#Explode the 3rd sector
$sectorObj = $c->sector(2);
$sectorObj->setExplode(40);

#Use Impact/12 points/Red color as font for the 3rd sector
$sectorObj->setLabelStyle("impact.ttf", 12, 0xff0000);

#Use default font (Arial)/8 points/deep blue for the 5th sector label font
$sectorObj = $c->sector(4);
$sectorObj->setLabelStyle("", 8, 0x000080);

#Use Times New Romans/8 points/deep red for the 6th sector label font
$sectorObj = $c->sector(5);
$sectorObj->setLabelStyle("times.ttf", 8, 0x800000);

#Use Impact/8 points/deep green as the 7th sector label font. In addition,
#add a background box to the label filled with yellow color (0xffff00) with 
#a black (0x000000) border.
$sectorObj = $c->sector(6);
$textBox = $sectorObj->setLabelStyle("impact.ttf", 8, 0x008000);
$textBox->setBackground(0xffff00, 0x000000);

#output the chart
header("Content-type: image/png");
print($c->makeChart2(PNG));
?>