from pychartdir import *


def main() :

	#The data for the line chart
	data = [25, 18, 9, 4, 5, 8, 14, 20, 40, 92, 75, 88, 75, 
		58, 90, 95, 83, 75, 70, 66, 46, 38, 28, 15, 22]

	#The labels for the line chart
	labels = ["0", "", "", "3", "", "", "6", "", "", "9", "", "", 
		"12", "", "", "15", "", "", "18", "", "", "21", "", "", "24"]

	#First, create a XYChart of size 300 pixels x 300 pixels
	c = XYChart(300, 300)

	#Set the plotarea rectangle to start at (50, 40) and of 
	#200 pixels in width and 200 in height
	c.setPlotArea(50, 40, 200, 200)

	#Add a title to the chart
	c.addTitle("Daily Server Utilization")

	#Add a title to the y axis
	c.yAxis().setTitle("CPU %")

	#Add a title to the x axis
	c.xAxis().setTitle("June 12, 2001")

	#Add a line chart layer using the supplied data
	c.addLineLayer(data).set3D()

	#Set the x axis labels using the supplied labels
	c.xAxis().setLabels(labels)

	#output the chart as a PNG file
	c.makeChart("threedline.png")


if __name__ == '__main__':
    main()