#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <dos.h>
#include <time.h>

#include "langext.h"
#include "defines.h"
#include "types.h"
#include "subs.h"
#include "globals.h"
/*                                 MEMORY.C                                */

/* I rewrote this entirely */


/*+-------------------------------------------------------------------------+
  |                                                                         |
  |                            initialize_memory                            |
  |                                                                         |
  +-------------------------------------------------------------------------+*/

void initialize_memory (void)
BeginDeclarations
byte_ptr rv;
EndDeclarations
BeginCode
EndCode

/*+-------------------------------------------------------------------------+
  |                                                                         |
  |                            allocate_memory                              |
  |                                                                         |
  +-------------------------------------------------------------------------+*/

byte_ptr allocate_memory (bit_32 size)
BeginDeclarations
byte_ptr rv;
EndDeclarations
BeginCode
 If size IsZero
  Then
   return NULL;
  EndIf;
 rv = calloc(size,1);
 If rv IsNull
  Then
   linker_error(12,"Out of memory\n");
  EndIf;
 return rv;
EndCode

/*+-------------------------------------------------------------------------+
  |                                                                         |
  |                            reallocate_memory                            |
  |                                                                         |
  +-------------------------------------------------------------------------+*/

byte_ptr reallocate_memory (ptr mem, bit_32 size)
BeginDeclarations
byte_ptr rv;
EndDeclarations
BeginCode
 If size IsZero
  Then
   free(mem) ;
   return NULL;
  EndIf;
 If mem IsNull 
  Then
   rv = calloc(size,1) ;
  Else
   rv = realloc(mem, size);
  EndIf
 If rv IsNull
  Then
   linker_error(12,"Out of memory\n");
  EndIf;
 return rv;
EndCode

/*+-------------------------------------------------------------------------+
  |                                                                         |
  |                              release_memory                             |
  |                                                                         |
  +-------------------------------------------------------------------------+*/

void release_memory(byte_ptr mem)
BeginDeclarations
EndDeclarations
BeginCode
 free(mem);
EndCode
